/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

class Row
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_colCnt;
    private Object[] m_colValue;
    private Object[] m_colChangedValue;
    private boolean[] m_colChanged;
    private boolean[] m_colOrigNull;
    private boolean m_rowUpdated;
    private boolean m_rowInserted;
    private int m_colInsertedCnt;
    private boolean m_rowDeleted;

    public Row(int cnt) {
        this.m_colCnt = cnt;
        this.m_colValue = new Object[cnt];
        this.m_colChangedValue = new Object[cnt];
        this.m_colChanged = new boolean[cnt];
        this.m_colOrigNull = new boolean[cnt];
        this.m_rowUpdated = false;
        this.m_rowInserted = false;
        this.m_colInsertedCnt = 0;
        this.m_rowDeleted = false;
    }

    public Row(int cnt, boolean insert) {
        this(cnt);
        this.m_rowInserted = insert;
    }

    public Row(int cnt, Object[] vals) {
        this(cnt);
        System.arraycopy(vals, 0, this.m_colValue, 0, cnt);
    }

    public Object getColumn(int col) {
        return this.m_colValue[col];
    }

    public Object getChangedColumn(int col) {
        return this.m_colChangedValue[col];
    }

    public Object[] getOriginalRow() {
        return this.m_colValue;
    }

    public boolean isOriginalNull(int col) {
        return this.m_colOrigNull[col];
    }

    public boolean isOriginalWithNull() {
        boolean withNull = false;
        int i2 = 0;
        while (i2 < this.m_colCnt) {
            if (this.isOriginalNull(i2)) {
                withNull = true;
                break;
            }
            ++i2;
        }
        return withNull;
    }

    void setOriginalNull(int col, boolean flag) {
        this.m_colOrigNull[col] = flag;
    }

    public void setColumnValue(int col, Object val) {
        this.m_colValue[col] = val;
        if (this.m_rowInserted) {
            ++this.m_colInsertedCnt;
        }
    }

    public void updateColumnValue(int col, Object nval) {
        this.m_colChanged[col] = true;
        this.m_colChangedValue[col] = nval;
        if (this.m_rowInserted) {
            ++this.m_colInsertedCnt;
        }
    }

    public boolean isColumnChanged(int col) {
        return this.m_colChanged[col];
    }

    public void insertRow() {
        System.arraycopy(this.m_colChangedValue, 0, this.m_colValue, 0, this.m_colCnt);
        this.m_colChanged = null;
        this.m_colChanged = new boolean[this.m_colCnt];
        this.m_colChangedValue = null;
        this.m_colChangedValue = new Object[this.m_colCnt];
        this.m_colInsertedCnt = 0;
    }

    public boolean isRowDeleted() {
        return this.m_rowDeleted;
    }

    public boolean isRowInserted() {
        return this.m_rowInserted;
    }

    public boolean isRowUpdated() {
        if (this.m_rowDeleted || this.m_rowInserted) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_colCnt) {
            if (this.m_colChanged[i2]) {
                return true;
            }
            ++i2;
        }
        return this.m_rowUpdated;
    }

    public void cancelRowDeletion() {
        this.m_rowDeleted = false;
    }

    public void cancelRowUpdates() {
        int i2 = 0;
        while (i2 < this.m_colCnt) {
            this.m_colChanged[i2] = false;
            ++i2;
        }
        this.m_colChangedValue = new Object[this.m_colCnt];
        this.m_colInsertedCnt = 0;
    }

    public void setRowUpdated(boolean flag) {
        this.m_rowUpdated = flag;
        if (!flag) {
            this.cancelRowUpdates();
        }
    }

    public void setRowDeleted(boolean flag) {
        this.m_rowDeleted = flag;
    }

    public void setRowInserted(boolean flag) {
        this.m_rowInserted = flag;
    }

    public boolean isRowFullyPopulated() {
        if (!this.m_rowInserted) {
            return false;
        }
        return this.m_colCnt == this.m_colInsertedCnt;
    }

    void setUpdatesOriginal() {
        int i2 = 0;
        while (i2 < this.m_colCnt) {
            if (this.m_colChanged[i2]) {
                this.m_colValue[i2] = this.m_colChangedValue[i2];
                this.m_colChangedValue[i2] = null;
                this.m_colChanged[i2] = false;
            }
            ++i2;
        }
        this.m_rowUpdated = false;
    }

    public Collection toCollection() {
        Vector<Object> columns = new Vector<Object>(this.m_colCnt);
        int i2 = 0;
        while (i2 < this.m_colCnt) {
            columns.add(this.isColumnChanged(i2) ? this.getChangedColumn(i2) : this.getColumn(i2));
            ++i2;
        }
        return columns;
    }

    public Row createCopy() {
        Row row = new Row(this.m_colCnt);
        System.arraycopy(this.m_colValue, 0, row.m_colValue, 0, this.m_colCnt);
        System.arraycopy(this.m_colChangedValue, 0, this.m_colChangedValue, 0, this.m_colCnt);
        System.arraycopy(this.m_colChanged, 0, row.m_colChanged, 0, this.m_colCnt);
        row.m_colInsertedCnt = this.m_colInsertedCnt;
        row.m_rowDeleted = this.m_rowDeleted;
        row.m_rowInserted = this.m_rowInserted;
        row.m_rowUpdated = this.m_rowUpdated;
        return row;
    }
}

