/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.Resource;
import javax.transaction.xa.XAException;

public class DmdbXAException
extends XAException {
    private static final long serialVersionUID = 1L;

    public DmdbXAException(int errcode) {
        this(DmdbXAException.getXAErrorMessage(errcode), errcode);
    }

    public DmdbXAException(String msg) {
        super(msg);
    }

    public DmdbXAException(String message, int errcode) {
        super(message);
        this.errorCode = errcode;
    }

    private static String getXAErrorMessage(int sqlcode) {
        String str = "";
        switch (sqlcode) {
            case -2: {
                str = Resource.get("error.xa.XAER_ASYNC");
                break;
            }
            case -8: {
                str = Resource.get("error.xa.XAER_DUPID");
                break;
            }
            case -5: {
                str = Resource.get("error.xa.XAER_INVAL");
                break;
            }
            case -4: {
                str = Resource.get("error.xa.XAER_NOTA");
                break;
            }
            case -9: {
                str = Resource.get("error.xa.XAER_OUTSIDE");
                break;
            }
            case -6: {
                str = Resource.get("error.xa.XAER_PROTO");
                break;
            }
            case -3: {
                str = Resource.get("error.xa.XAER_RMERR");
                break;
            }
            case -7: {
                str = Resource.get("error.xa.XAER_RMFAIL");
                break;
            }
            case 7: {
                str = Resource.get("error.xa.XA_HEURCOM");
                break;
            }
            case 8: {
                str = Resource.get("error.xa.XA_HEURHAZ");
                break;
            }
            case 5: {
                str = Resource.get("error.xa.XA_HEURMIX");
                break;
            }
            case 6: {
                str = Resource.get("error.xa.XA_HEURRB");
                break;
            }
            case 9: {
                str = Resource.get("error.xa.XA_NOMIGRATE");
                break;
            }
            case 100: {
                str = Resource.get("error.xa.XA_RBBASE");
                break;
            }
            case 101: {
                str = Resource.get("error.xa.XA_RBCOMMFAIL");
                break;
            }
            case 102: {
                str = Resource.get("error.xa.XA_RBDEADLOCK");
                break;
            }
            case 107: {
                str = Resource.get("error.xa.XA_RBEND");
                break;
            }
            case 103: {
                str = Resource.get("error.xa.XA_RBINTEGRITY");
                break;
            }
            case 104: {
                str = Resource.get("error.xa.XA_RBOTHER");
                break;
            }
            case 105: {
                str = Resource.get("error.xa.XA_RBPROTO");
                break;
            }
            case 106: {
                str = Resource.get("error.xa.XA_RBTIMEOUT");
                break;
            }
            case 3: {
                str = Resource.get("error.xa.XA_RDONLY");
                break;
            }
            case 4: {
                str = Resource.get("error.xa.XA_RETRY");
                break;
            }
            default: {
                str = Resource.get("error.xa.XA_INTERNAL_ERROR");
            }
        }
        return str;
    }
}

