/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DBParameter;
import dm.jdbc.driver.DBWarning;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDataSource;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbRowSetMetaData;
import dm.jdbc.driver.DmdbRowSetReader;
import dm.jdbc.driver.DmdbRowSetWriter;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.Row;
import dm.jdbc.internal.AbstractRowSet;
import dm.jdbc.internal.convert.DB2J;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.ReaderToInputStream;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

public class DmdbRowSet
extends AbstractRowSet
implements RowSetInternal,
CachedRowSet {
    private transient DmdbConnection m_conn_bs = null;
    protected DmdbResultSet m_resultSet_bs = null;
    protected int m_currentRow = 0;
    protected boolean m_previousColNull;
    private int m_pageSize = 0;
    private boolean m_populatedDone = false;
    protected int m_columnCount = 0;
    protected int m_rowCount = 0;
    protected Vector<Row> m_rows = null;
    private Row m_insertRow = null;
    private int m_insertRowPos = 0;
    private int m_updateRowPos = 0;
    private boolean m_insertFlag = false;
    private boolean m_updateFlag = false;
    public Vector<DBParameter> m_params = null;
    private SQLWarning m_sqlWarning = null;
    private RowSetWarning m_rowsetWarning;
    protected DmdbRowSetMetaData m_rsmd = null;
    private String[] m_columnNames = null;
    private String m_tableName = null;
    private int[] m_keyColumns;
    private DmdbRowSetReader m_reader;
    private DmdbRowSetWriter m_writer;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private SyncProvider m_syncProvider = null;
    protected boolean m_closed = false;
    private boolean m_KeepConnecting = false;

    public DmdbRowSet() throws SQLException {
        this.initialize();
    }

    private void initialize() throws SQLException {
        this.m_currentRow = 0;
        this.m_columnCount = 0;
        this.m_previousColNull = false;
        this.m_pageSize = 0;
        this.m_resultSet_bs = null;
        this.m_populatedDone = false;
        this.m_rowCount = 0;
        if (this.m_rows == null) {
            this.m_rows = new Vector(50);
        } else {
            this.m_rows.clear();
        }
        this.m_showDeleted = false;
        this.m_insertRow = null;
        this.m_insertRowPos = 0;
        this.m_insertFlag = false;
        this.m_updateFlag = false;
        this.m_params = new Vector(10);
        this.m_sqlWarning = new SQLWarning();
        this.m_rowsetWarning = new RowSetWarning();
        this.m_rsmd = null;
        this.m_columnNames = null;
        this.m_tableName = null;
        this.m_keyColumns = new int[0];
        this.m_reader = new DmdbRowSetReader();
        this.m_writer = new DmdbRowSetWriter();
        this.m_closed = false;
        this.m_KeepConnecting = false;
        try {
            this.m_syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
        }
        catch (SyncFactoryException syncfactoryexception) {
            DBError.throwException("SyncProvider instance not constructed.", syncfactoryexception);
        }
    }

    private void uninitialize() {
        this.m_currentRow = 0;
        this.m_columnCount = 0;
        this.m_resultSet_bs = null;
        this.m_populatedDone = false;
        this.m_rowCount = 0;
        this.m_rows = null;
        this.m_showDeleted = false;
        this.m_insertRow = null;
        this.m_insertRowPos = 0;
        this.m_insertFlag = false;
        this.m_updateFlag = false;
    }

    protected Row getCurrentRow() throws SQLException {
        if (this.m_currentRow < 1 || this.m_currentRow > this.m_rowCount) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
        return this.m_rows.elementAt(this.m_currentRow - 1);
    }

    protected synchronized Object getObjectInner(int col) throws SQLException {
        this.checkColumn(col);
        Row row = this.getCurrentRow();
        Object obj = null;
        obj = row.isColumnChanged(col - 1) ? row.getChangedColumn(col - 1) : row.getColumn(col - 1);
        boolean bl = this.m_previousColNull = obj == null;
        if (!this.m_previousColNull && obj instanceof Struct) {
            Struct struct = (Struct)obj;
            obj = DB2J.toSQLData(struct, this.getTypeMap());
        }
        return obj;
    }

    protected synchronized Object getObjectInner(int col, Map<String, Class<?>> map) throws SQLException {
        this.checkColumn(col);
        Row row = this.getCurrentRow();
        Object obj = null;
        obj = row.isColumnChanged(col - 1) ? row.getChangedColumn(col - 1) : row.getColumn(col - 1);
        boolean bl = this.m_previousColNull = obj == null;
        if (!this.m_previousColNull && obj instanceof Struct) {
            Struct struct = (Struct)obj;
            obj = DB2J.toSQLData(struct, this.getTypeMap());
        }
        return obj;
    }

    protected synchronized InputStream getStreamInner(int col) throws SQLException {
        Object obj = this.getObjectInner(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        if (obj instanceof Byte) {
            byte[] bs = new byte[]{};
            bs[0] = (Byte)obj;
            return new ByteArrayInputStream(bs);
        }
        if (obj instanceof String) {
            return new ByteArrayInputStream(ByteUtil.fromString((String)obj, this.m_conn_bs.getServerEncoding()));
        }
        if (obj instanceof Blob) {
            return ((Blob)obj).getBinaryStream();
        }
        if (obj instanceof Clob) {
            return ((Clob)obj).getAsciiStream();
        }
        if (obj instanceof Reader) {
            BufferedReader breader = new BufferedReader((Reader)obj);
            ReaderToInputStream chgTemp = new ReaderToInputStream();
            InputStream in = chgTemp.ReaderTo(breader, this.m_conn_bs.getServerEncoding());
            return in;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    protected synchronized void updateObjectInner(int i2, Object obj) throws SQLException {
        this.checkColumn(i2);
        if (this.m_insertFlag) {
            this.m_insertRow.updateColumnValue(i2 - 1, obj);
            return;
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        } else {
            this.m_updateFlag = true;
            this.m_updateRowPos = this.m_currentRow;
            this.getCurrentRow().updateColumnValue(i2 - 1, obj);
        }
    }

    protected synchronized Number getNumber(int i2) throws SQLException {
        Object obj = this.getObjectInner(i2);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return i2;
    }

    private boolean setOriginalRowInner(int rowIndex) {
        Row row = this.m_rows.get(rowIndex);
        if (row.isRowDeleted()) {
            this.m_rows.removeElementAt(rowIndex);
            --this.m_rowCount;
            return true;
        }
        if (row.isRowInserted()) {
            row.setRowInserted(false);
        } else if (row.isRowUpdated()) {
            row.setUpdatesOriginal();
        }
        return false;
    }

    protected void setOriginal() {
        int i2 = 0;
        while (i2 < this.m_rowCount) {
            if (this.setOriginalRowInner(i2)) {
                --i2;
            }
            ++i2;
        }
    }

    protected synchronized void notifyCursorMoved() throws SQLException {
        if (this.m_insertFlag) {
            this.m_insertFlag = false;
            this.m_insertRow.setRowUpdated(false);
            this.m_sqlWarning.setNextWarning(DBWarning.getSQLWarning(DBError.ECJDBC_CRS_CURSOR_MOVED));
        } else if (this.m_updateFlag) {
            this.m_updateFlag = false;
            int i2 = this.m_currentRow;
            this.m_currentRow = this.m_updateRowPos;
            this.getCurrentRow().setRowUpdated(false);
            this.m_currentRow = i2;
            this.m_sqlWarning.setNextWarning(DBWarning.getSQLWarning(DBError.ECJDBC_CRS_CURSOR_MOVED));
        }
    }

    protected void checkCurrentRow() throws SQLException {
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
    }

    protected void checkColumn(int idx) throws SQLException {
        if (idx < 1 || idx > this.m_columnCount) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
    }

    private void checkRowSet() throws SQLException {
        if (this.m_rows == null || this.m_rows.size() == 0) {
            DBError.ECJDBC_ROW_SET_NULL.throwz(new Object[0]);
        }
    }

    private void putParamToVector(Object col, DBParameter param) {
        boolean exist = false;
        int len = this.m_params.size();
        String pName = null;
        int pIndex = -1;
        int i2 = 0;
        while (i2 < len) {
            DBParameter parameter = this.m_params.elementAt(i2);
            pName = parameter.getParamName();
            pIndex = parameter.getParamIndex();
            if (pName != null && pName.equalsIgnoreCase((String)col) || pName == null && pIndex == (Integer)col) {
                this.m_params.set(i2, param);
                exist = true;
                break;
            }
            ++i2;
        }
        if (!exist) {
            this.m_params.add(param);
        }
    }

    protected void setObjectInner(Object col, Object obj) throws SQLException {
        Object[] params = new Object[]{obj};
        this.putParamToVector(col, new DBParameter(col, params));
    }

    protected void setObjectInner(Object col, Object obj, int i2, boolean bySetObject) throws SQLException {
        Object[] params = new Object[]{obj, i2};
        DBParameter param = new DBParameter(col, params);
        param.setBySetObject(bySetObject);
        this.putParamToVector(col, param);
    }

    protected void setObjectInner(Object col, Object obj, long l2) throws SQLException {
        Object[] params = new Object[]{obj, l2};
        DBParameter param = new DBParameter(col, params);
        this.putParamToVector(col, param);
    }

    protected void setObjectInner(Object col, Object obj, Calendar cal) throws SQLException {
        Object[] params = new Object[]{obj, cal};
        this.putParamToVector(col, new DBParameter(col, params));
    }

    protected void setObjectInner(Object col, Object obj, int i2, String str) throws SQLException {
        Object[] params = new Object[]{obj, i2, str};
        DBParameter param = new DBParameter(col, params);
        param.setBySetObject(true);
        this.putParamToVector(col, param);
    }

    protected void setObjectInner(Object col, Object obj, int i2, int j2) throws SQLException {
        Object[] params = new Object[]{obj, i2, j2};
        DBParameter param = new DBParameter(col, params);
        param.setBySetObject(true);
        this.putParamToVector(col, param);
    }

    boolean keepConnecting() {
        return this.m_KeepConnecting;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.m_rowCount <= 0) {
            return false;
        }
        int fetchDirection = this.getFetchDirection();
        if (fetchDirection == 1000 || fetchDirection == 1002) {
            if (this.m_currentRow < this.m_rowCount) {
                ++this.m_currentRow;
                Row row = this.getCurrentRow();
                if (!this.m_showDeleted && row.isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = this.m_rowCount + 1;
            return false;
        }
        if (fetchDirection == 1001) {
            if (this.m_currentRow > 1) {
                --this.m_currentRow;
                Row row = this.getCurrentRow();
                if (!this.m_showDeleted && row.isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = 0;
            return false;
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.m_currentRow = 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == this.m_rowCount + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == this.m_rowCount;
    }

    @Override
    public void afterLast() throws SQLException {
        this.m_currentRow = this.m_rowCount + 1;
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.getType() == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if (row == 0 || this.m_rowCount == 0) {
            return false;
        }
        if (this.m_currentRow == row) {
            return true;
        }
        if (row > 0 && Math.abs(row) > this.m_rowCount) {
            this.m_currentRow = this.m_rowCount + 1;
            this.notifyCursorMoved();
            return false;
        }
        if (row < 0 && Math.abs(row) > this.m_rowCount) {
            this.m_currentRow = 0;
            this.notifyCursorMoved();
            return false;
        }
        this.m_currentRow = row > 0 ? row : this.m_rowCount + row + 1;
        this.notifyCursorMoved();
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.m_currentRow + rows);
    }

    @Override
    public boolean previous() throws SQLException {
        int fetchDirection;
        if (this.getType() == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if ((fetchDirection = this.getFetchDirection()) == 1001) {
            if (this.m_currentRow < this.m_columnCount) {
                ++this.m_currentRow;
                if (!this.m_showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = this.m_columnCount + 1;
            this.notifyCursorMoved();
            return false;
        }
        if (fetchDirection == 1000 || fetchDirection == 1002) {
            if (this.m_currentRow > 1) {
                --this.m_currentRow;
                if (!this.m_showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = 0;
            this.notifyCursorMoved();
            return false;
        }
        return false;
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.getFetchDirection() == 1001 && this.m_resultSet_bs != null && this.m_resultSet_bs.do_getType() == 1003) {
            DBError.ECJDBC_CRS_RESULTSET_NOTSUPT.throwz(new Object[0]);
        }
        if (this.m_rows == null || this.m_rows.size() == 0 && !this.m_populatedDone) {
            DBError.ECJDBC_CRS_NPREP_PAGING.throwz(new Object[0]);
        }
        if (this.m_resultSet_bs.do_isAfterLast()) {
            return false;
        }
        this.populate(this.m_resultSet_bs);
        return true;
    }

    @Override
    public boolean previousPage() throws SQLException {
        if (this.m_resultSet_bs != null && this.m_resultSet_bs.do_getType() == 1003) {
            DBError.ECJDBC_CRS_RESULTSET_NOTSUPT.throwz(new Object[0]);
        }
        if (this.m_rows == null || this.m_rows.size() == 0 && !this.m_populatedDone) {
            DBError.ECJDBC_CRS_NPREP_PAGING.throwz(new Object[0]);
        }
        if (this.m_resultSet_bs.do_isBeforeFirst() || this.m_resultSet_bs.currentPos < (long)this.m_pageSize) {
            return false;
        }
        this.m_resultSet_bs.do_relative(-(this.m_pageSize + this.m_rowCount + 1));
        this.populate(this.m_resultSet_bs);
        return true;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_NOT_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        if (!this.m_insertRow.isRowFullyPopulated()) {
            DBError.ECJDBC_CRS_NPOPU_FULLY.throwz(new Object[0]);
        }
        this.m_insertRow.insertRow();
        this.m_rows.insertElementAt(this.m_insertRow, this.m_insertRowPos - 1);
        ++this.m_rowCount;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        if (!this.m_updateFlag) {
            DBError.ECJDBC_RESULTSET_NOT_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        this.getCurrentRow().setRowUpdated(true);
        this.m_updateFlag = false;
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.cancelRowUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        Row row = this.getCurrentRow();
        if (row.isRowUpdated()) {
            this.m_updateFlag = false;
            row.setRowUpdated(false);
            this.notifyRowChanged();
        }
    }

    public void cancelRowInsert() throws SQLException {
        if (this.m_insertRow != null) {
            this.m_rows.remove(this.m_insertRowPos - 1);
            --this.m_rowCount;
            this.m_insertRow = null;
            this.notifyRowChanged();
        }
    }

    public void cancelRowDelete() throws SQLException {
        Row row = this.getCurrentRow();
        if (row.isRowDeleted()) {
            row.setRowDeleted(false);
            this.notifyRowChanged();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.m_insertRow = new Row(this.m_columnCount, true);
        this.m_insertFlag = true;
        this.m_insertRowPos = this.isAfterLast() ? this.m_currentRow : this.m_currentRow + 1;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.m_insertFlag) {
            this.m_insertFlag = false;
            this.m_updateFlag = false;
            this.absolute(this.m_currentRow);
        }
    }

    @Override
    public void populate(ResultSet rs) throws SQLException {
        boolean fetchForward;
        if (rs == null) {
            DBError.ECJDBC_CRS_RS_NULL.throwz(new Object[0]);
        }
        this.m_resultSet_bs = (DmdbResultSet)rs;
        this.m_resultSet_bs.checkClosed();
        this.m_rsmd = new DmdbRowSetMetaData(this.m_resultSet_bs.connection, this.m_resultSet_bs.columns);
        this.m_columnCount = this.m_rsmd.getColumnCount();
        this.m_columnNames = new String[this.m_columnCount];
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            this.m_columnNames[i2] = this.m_rsmd.getColumnName(i2 + 1);
            ++i2;
        }
        if (this.m_columnCount < 1) {
            return;
        }
        this.m_tableName = this.m_rsmd.getTableName(1);
        long rowSize = 0L;
        long maxRows = this.getMaxRows();
        rowSize = maxRows == 0L && this.m_pageSize == 0 ? Long.MAX_VALUE : (maxRows == 0L || this.m_pageSize == 0 ? Math.max(maxRows, (long)this.m_pageSize) : Math.min(maxRows, (long)this.m_pageSize));
        int fetchDirect = this.getFetchDirection();
        boolean bl = fetchForward = fetchDirect == 1000 || fetchDirect == 1002;
        if (this.m_resultSet_bs.do_isBeforeFirst() && !fetchForward && this.m_resultSet_bs.do_getType() != 1003) {
            this.m_resultSet_bs.do_afterLast();
        }
        if (this.m_rows == null) {
            this.m_rows = new Vector(50);
        } else {
            this.m_rows.clear();
        }
        this.m_currentRow = 0;
        this.m_rowCount = 0;
        while ((long)this.m_rowCount < rowSize && !(fetchForward ? !this.m_resultSet_bs.do_next() : !this.m_resultSet_bs.do_previous())) {
            Row row = new Row(this.m_columnCount);
            int i3 = 0;
            while (i3 < this.m_columnCount) {
                Object obj = this.m_resultSet_bs.do_getObject(i3 + 1, this.getTypeMap());
                if (obj instanceof Clob) {
                    SerialClob clob = new SerialClob((Clob)obj);
                    row.setColumnValue(i3, clob);
                } else if (obj instanceof Blob) {
                    SerialBlob blob = new SerialBlob((Blob)obj);
                    row.setColumnValue(i3, blob);
                } else {
                    row.setColumnValue(i3, obj);
                    row.setOriginalNull(i3, this.m_resultSet_bs.do_wasNull());
                }
                ++i3;
            }
            if (fetchForward) {
                this.m_rows.add(row);
            } else {
                this.m_rows.add(0, row);
            }
            ++this.m_rowCount;
        }
        if (fetchForward && this.m_resultSet_bs.do_isAfterLast() || !fetchForward && this.m_resultSet_bs.do_isBeforeFirst()) {
            this.m_populatedDone = true;
        }
        this.notifyRowSetChanged();
    }

    @Override
    public void populate(ResultSet rs, int startRow) throws SQLException {
        boolean fetchForward;
        if (startRow < 0) {
            DBError.ECJDBC_CRS_STARTROW_NNEG.throwz(new Object[0]);
        }
        if (rs == null) {
            DBError.ECJDBC_CRS_RS_NULL.throwz(new Object[0]);
        }
        DmdbResultSet dmRS = (DmdbResultSet)rs;
        if (dmRS.totalRowCount < (long)startRow) {
            DBError.ECJDBC_CRS_RS_TFEW_TOSTARTP.throwz(new Object[0]);
        }
        dmRS.do_absolute(startRow);
        int fetchDirect = dmRS.do_getFetchDirection();
        boolean bl = fetchForward = fetchDirect == 1000 || fetchDirect == 1002;
        if (fetchForward) {
            dmRS.do_previous();
        } else {
            dmRS.do_next();
        }
        this.populate(rs);
    }

    @Override
    public void execute() throws SQLException {
        this.m_reader.readData(this);
    }

    @Override
    public void execute(Connection conn) throws SQLException {
        this.m_KeepConnecting = true;
        this.m_conn_bs = (DmdbConnection)conn;
        this.m_reader.readData(this);
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        try {
            this.m_writer.writeData(this);
        }
        catch (SQLException e2) {
            DBError.throwSyncProviderException(e2);
        }
    }

    @Override
    public void acceptChanges(Connection con) throws SyncProviderException {
        this.m_KeepConnecting = true;
        this.m_conn_bs = (DmdbConnection)con;
        this.acceptChanges();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        int i2 = 0;
        while (i2 < this.m_rowCount) {
            Row row = this.m_rows.elementAt(i2);
            if (row.isRowInserted()) {
                this.m_rows.remove(i2);
                --this.m_rowCount;
                --i2;
            } else if (row.isRowUpdated()) {
                row.setRowUpdated(false);
            } else if (row.isRowDeleted()) {
                row.setRowDeleted(false);
            }
            ++i2;
        }
        this.notifyRowSetChanged();
    }

    @Override
    public void release() throws SQLException {
        this.uninitialize();
        this.notifyRowSetChanged();
    }

    @Override
    public void close() throws SQLException {
        if (this.m_closed) {
            return;
        }
        if (this.m_conn_bs != null && !this.m_conn_bs.do_isClosed()) {
            this.m_conn_bs.do_close();
            this.m_conn_bs = null;
        }
        this.release();
        this.m_closed = true;
    }

    @Override
    public void undoDelete() throws SQLException {
        Row row;
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
        if (!(row = this.getCurrentRow()).isRowDeleted()) {
            DBError.ECJDBC_ROW_SET_NOT_DEL.throwz(new Object[0]);
        }
        row.setRowDeleted(false);
        this.notifyRowChanged();
    }

    @Override
    public void undoInsert() throws SQLException {
        Row row;
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
        if (!(row = this.getCurrentRow()).isRowInserted()) {
            DBError.ECJDBC_ROW_SET_NOT_INSERT.throwz(new Object[0]);
        }
        this.m_rows.remove(--this.m_currentRow);
        --this.m_rowCount;
        this.notifyRowChanged();
    }

    @Override
    public void undoUpdate() throws SQLException {
        Row row;
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwz(new Object[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
        if (!(row = this.getCurrentRow()).isRowUpdated()) {
            DBError.ECJDBC_ROW_SET_NOT_UPDATE.throwz(new Object[0]);
        }
        row.setRowUpdated(false);
        this.notifyRowChanged();
    }

    @Override
    public boolean columnUpdated(int idx) throws SQLException {
        this.checkColumn(idx);
        this.checkCurrentRow();
        return this.getCurrentRow().isColumnChanged(idx - 1);
    }

    @Override
    public boolean columnUpdated(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.columnUpdated(idx);
    }

    @Override
    public Collection<?> toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            int i2 = 0;
            while (i2 < this.m_rowCount) {
                map.put(i2, this.m_rows.elementAt(i2).toCollection());
                ++i2;
            }
        }
        catch (Exception exception) {
            map = null;
            DBError.ECJDBC_ROW_SET_TO_CLC_FAILED.throwz(new Object[0]);
        }
        return map.values();
    }

    @Override
    public Collection<?> toCollection(int column) throws SQLException {
        this.checkColumn(column);
        Vector<Object> cols = new Vector<Object>(this.m_rowCount);
        int i2 = 0;
        while (i2 < this.m_rowCount) {
            Row row = this.m_rows.elementAt(i2);
            Object obj = row.isColumnChanged(column - 1) ? row.getChangedColumn(column - 1) : row.getColumn(column - 1);
            cols.add(obj);
            ++i2;
        }
        return cols;
    }

    @Override
    public Collection<?> toCollection(String column) throws SQLException {
        int idx = this.findColumn(column);
        return this.toCollection(idx);
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.m_syncProvider;
    }

    @Override
    public void setSyncProvider(String provider) throws SQLException {
        try {
            this.m_syncProvider = SyncFactory.getInstance(provider);
        }
        catch (SyncFactoryException syncfactoryexception) {
            DBError.throwException("SyncProvider instance not constructed.", syncfactoryexception);
        }
    }

    @Override
    public int size() {
        return this.m_rowCount;
    }

    protected Row getOriginalRowData() throws SQLException {
        return new Row(this.m_columnCount, this.getCurrentRow().getOriginalRow());
    }

    @Override
    public void setOriginalRow() throws SQLException {
        this.checkCurrentRow();
        this.setOriginalRowInner(this.m_currentRow);
    }

    @Override
    public String getTableName() throws SQLException {
        return this.m_tableName;
    }

    @Override
    public void setTableName(String tabName) throws SQLException {
        if (tabName == null) {
            DBError.ECJDBC_ROW_SET_TAB_NAME_NULL.throwz(new Object[0]);
        }
        this.m_tableName = tabName;
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        this.checkRowSet();
        return this.m_keyColumns;
    }

    @Override
    public void setKeyColumns(int[] keys) throws SQLException {
        boolean valid = true;
        if (keys == null) {
            valid = false;
        } else {
            int[] nArray = keys;
            int n2 = keys.length;
            int n3 = 0;
            while (n3 < n2) {
                int key = nArray[n3];
                if (key < 1 || key > this.m_columnCount) {
                    valid = false;
                    break;
                }
                ++n3;
            }
        }
        if (!valid) {
            DBError.ECJDBC_ROW_SET_COL_KEY_INVALID.throwz(new Object[0]);
        }
        this.m_keyColumns = keys;
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.m_rowsetWarning;
    }

    @Override
    public void setPageSize(int size) throws SQLException {
        if (size < 1 || this.getMaxRows() > 0 && size > this.getMaxRows()) {
            DBError.ECJDBC_ROW_SET_PAGE_SIZE_INVALID.throwz(new Object[0]);
        }
        this.m_pageSize = size;
    }

    @Override
    public int getPageSize() {
        return this.m_pageSize;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (this.m_columnNames == null) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwz(new Object[0]);
        }
        int ret = -1;
        int i2 = 0;
        while (i2 < this.m_columnNames.length) {
            if (this.m_columnNames[i2].equalsIgnoreCase(columnName)) {
                ret = i2 + 1;
                break;
            }
            ++i2;
        }
        if (ret < 1) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwz(new Object[0]);
        }
        return ret;
    }

    @Override
    public Object[] getParams() throws SQLException {
        int size = this.m_params.size();
        Object[] objs = new Object[size];
        int i2 = 0;
        while (i2 < size) {
            objs[i2] = this.m_params.elementAt(i2).getParams()[0];
            ++i2;
        }
        return objs;
    }

    public void setReader(RowSetReader reader) {
        this.m_reader = (DmdbRowSetReader)reader;
    }

    public void setWriter(RowSetWriter writer) {
        this.m_writer = (DmdbRowSetWriter)writer;
    }

    protected void rowsetShared(DmdbRowSet cachedrowset) throws SQLException {
        cachedrowset.m_rows = this.m_rows;
        cachedrowset.setDataSourceName(this.getDataSourceName());
        cachedrowset.setUsername(this.getUsername());
        cachedrowset.setPassword(this.getPassword());
        cachedrowset.setUrl(this.getUrl());
        cachedrowset.setTypeMap(this.getTypeMap());
        cachedrowset.setMaxFieldSize(this.getMaxFieldSize());
        cachedrowset.setMaxRows(this.getMaxRows());
        cachedrowset.setQueryTimeout(this.getQueryTimeout());
        cachedrowset.setFetchSize(this.getFetchSize());
        cachedrowset.setEscapeProcessing(this.getEscapeProcessing());
        cachedrowset.setConcurrency(this.getConcurrency());
        cachedrowset.setReadOnly(this.isReadOnly());
        cachedrowset.setType(this.getType());
        cachedrowset.setFetchDirection(this.getFetchDirection());
        cachedrowset.setCommand(this.getCommand());
        cachedrowset.setTransactionIsolation(this.getTransactionIsolation());
        cachedrowset.m_currentRow = this.m_currentRow;
        cachedrowset.m_columnCount = this.m_columnCount;
        cachedrowset.m_rowCount = this.m_rowCount;
        cachedrowset.m_showDeleted = this.m_showDeleted;
        cachedrowset.m_syncProvider = this.m_syncProvider;
        cachedrowset.m_pageSize = this.m_pageSize;
        cachedrowset.m_tableName = this.m_tableName;
        cachedrowset.m_keyColumns = this.m_keyColumns != null ? (int[])this.m_keyColumns.clone() : null;
        int i2 = this.m_listeners.size();
        int j2 = 0;
        while (j2 < i2) {
            cachedrowset.m_listeners.add((RowSetListener)this.m_listeners.elementAt(j2));
            ++j2;
        }
        cachedrowset.m_rsmd = this.m_rsmd;
        i2 = this.m_params.size();
        int k2 = 0;
        while (k2 < i2) {
            cachedrowset.m_params.add(this.m_params.elementAt(k2));
            ++k2;
        }
        if (this.m_columnNames != null) {
            cachedrowset.m_columnNames = new String[this.m_columnNames.length];
            System.arraycopy(this.m_columnNames, 0, cachedrowset.m_columnNames, 0, this.m_columnNames.length);
        }
    }

    protected void rowsetCopy(DmdbRowSet rowset) throws SQLException {
        this.rowsetShared(rowset);
        rowset.m_rows = new Vector(rowset.m_rowCount);
        int j2 = 0;
        while (j2 < this.m_rowCount) {
            rowset.m_rows.add(this.m_rows.elementAt(j2).createCopy());
            ++j2;
        }
    }

    public void setTIMESTAMP(int parameterIndex, DmdbTimestamp dt) throws SQLException {
        this.setObjectInner(parameterIndex, dt);
    }

    public void setTIMESTAMP(String parameterName, DmdbTimestamp dt) throws SQLException {
        this.setObjectInner(parameterName, dt);
    }

    public void setINTERVALDT(int parameterIndex, DmdbIntervalDT dt) throws SQLException {
        this.setObjectInner(parameterIndex, dt);
    }

    public void setINTERVALDT(String parameterName, DmdbIntervalDT dt) throws SQLException {
        this.setObjectInner(parameterName, dt);
    }

    public void setINTERVALYM(int parameterIndex, DmdbIntervalYM ym) throws SQLException {
        this.setObjectInner(parameterIndex, ym);
    }

    public void setINTERVALYM(String parameterName, DmdbIntervalYM ym) throws SQLException {
        this.setObjectInner(parameterName, ym);
    }

    public void updateINTERVALYM(int i2, DmdbIntervalYM ym) throws SQLException {
        this.updateObjectInner(i2, ym);
    }

    public void updateINTERVALYM(String s2, DmdbIntervalYM ym) throws SQLException {
        this.updateINTERVALYM(this.findColumn(s2), ym);
    }

    public void updateINTERVALDT(int i2, DmdbIntervalDT dt) throws SQLException {
        this.updateObjectInner(i2, dt);
    }

    public void updateINTERVALDT(String s2, DmdbIntervalDT dt) throws SQLException {
        this.updateINTERVALDT(this.findColumn(s2), dt);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObjectInner((Object)parameterIndex, null, sqlType, false);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setObjectInner((Object)paramIndex, null, sqlType, typeName);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.setObjectInner(parameterIndex, Float.valueOf(x2));
    }

    @Override
    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setString(int parameterIndex, String x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x2, length, false);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x2, length, false);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)reader, length, false);
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.setObjectInner((Object)parameterIndex, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.setObjectInner((Object)parameterIndex, x2, targetSqlType, true);
    }

    @Override
    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setRef(int i2, Ref x2) throws SQLException {
        this.setObjectInner(i2, x2 == null ? null : x2.getObject());
    }

    @Override
    public void setBlob(int i2, Blob x2) throws SQLException {
        this.setObjectInner(i2, x2);
    }

    @Override
    public void setClob(int i2, Clob x2) throws SQLException {
        this.setObjectInner(i2, x2);
    }

    @Override
    public void setArray(int i2, Array x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x2, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x2, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x2, cal);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.m_params.clear();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_previousColNull;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() != 0.0;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return false;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? (short)0 : num.shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0 : num.intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0L : num.longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0.0f : num.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0.0 : num.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Number num = this.getNumber(columnIndex);
        if (num == null) {
            return null;
        }
        BigDecimal bd = null;
        bd = num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.doubleValue());
        bd.setScale(scale);
        return bd;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            return new Date(time.getTime());
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return new Date(timestamp.getTime());
        }
        if (obj instanceof String) {
            return DmdbTimestamp.valueOf((String)obj).toDate();
        }
        if (obj instanceof DmdbTimestamp) {
            return ((DmdbTimestamp)obj).toDate();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            return new Time(date.getTime());
        }
        if (obj instanceof Timestamp) {
            Timestamp timstamp = (Timestamp)obj;
            return new Time(timstamp.getTime());
        }
        if (obj instanceof String) {
            return DmdbTimestamp.valueOf((String)obj).toTime();
        }
        if (obj instanceof DmdbTimestamp) {
            return ((DmdbTimestamp)obj).toTime();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof DmdbTimestamp) {
            return ((DmdbTimestamp)obj).toTimestamp();
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof Time) {
            return new Timestamp(((Time)obj).getTime());
        }
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        if (obj instanceof String) {
            return DmdbTimestamp.valueOf((String)obj).toTimestamp();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getStreamInner(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return new StringBufferInputStream((String)obj);
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getStreamInner(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.m_sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_sqlWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObjectInner(columnIndex, this.getTypeMap());
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])obj));
        }
        if (obj instanceof Byte) {
            byte[] bs = new byte[]{(Byte)obj};
            return new InputStreamReader(new ByteArrayInputStream(bs));
        }
        if (obj instanceof String) {
            return new StringReader((String)obj);
        }
        if (obj instanceof Blob) {
            return new InputStreamReader(((Blob)obj).getBinaryStream());
        }
        if (obj instanceof Clob) {
            return ((Clob)obj).getCharacterStream();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        if (num == null) {
            return null;
        }
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        return new BigDecimal(num.doubleValue());
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public int getRow() throws SQLException {
        return this.m_currentRow;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.updateObjectInner(columnIndex, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateByte(int columnIndex, byte x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateShort(int columnIndex, short x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateInt(int columnIndex, int x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateLong(int columnIndex, long x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateFloat(int columnIndex, float x2) throws SQLException {
        this.updateObjectInner(columnIndex, Float.valueOf(x2));
    }

    @Override
    public void updateDouble(int columnIndex, double x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateString(int columnIndex, String x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateDate(int columnIndex, Date x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateTime(int columnIndex, Time x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateObject(int columnIndex, Object x2, int scale) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateObject(int columnIndex, Object x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x2);
    }

    @Override
    public void updateByte(String columnName, byte x2) throws SQLException {
        this.updateByte(this.findColumn(columnName), x2);
    }

    @Override
    public void updateShort(String columnName, short x2) throws SQLException {
        this.updateShort(this.findColumn(columnName), x2);
    }

    @Override
    public void updateInt(String columnName, int x2) throws SQLException {
        this.updateInt(this.findColumn(columnName), x2);
    }

    @Override
    public void updateLong(String columnName, long x2) throws SQLException {
        this.updateLong(this.findColumn(columnName), x2);
    }

    @Override
    public void updateFloat(String columnName, float x2) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x2);
    }

    @Override
    public void updateDouble(String columnName, double x2) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x2);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x2);
    }

    @Override
    public void updateString(String columnName, String x2) throws SQLException {
        this.updateString(this.findColumn(columnName), x2);
    }

    @Override
    public void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x2);
    }

    @Override
    public void updateDate(String columnName, Date x2) throws SQLException {
        this.updateDate(this.findColumn(columnName), x2);
    }

    @Override
    public void updateTime(String columnName, Time x2) throws SQLException {
        this.updateTime(this.findColumn(columnName), x2);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x2);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x2, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x2, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.updateObject(columnName, x2);
    }

    @Override
    public void updateObject(String columnName, Object x2) throws SQLException {
        this.updateObjectInner(this.findColumn(columnName), x2);
    }

    @Override
    public Object getObject(int i2, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectInner(i2, map);
    }

    @Override
    public Ref getRef(int i2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Blob getBlob(int i2) throws SQLException {
        Object obj = this.getObjectInner(i2);
        if (obj == null) {
            return null;
        }
        if (obj instanceof SerialBlob) {
            return (Blob)obj;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Clob getClob(int i2) throws SQLException {
        Object obj = this.getObjectInner(i2);
        if (obj == null) {
            return null;
        }
        if (obj instanceof SerialClob) {
            return (Clob)obj;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Array getArray(int i2) throws SQLException {
        Object obj = this.getObjectInner(i2);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Array) {
            return (Array)obj;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectInner(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public void updateRef(int columnIndex, Ref x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2 == null ? null : x2.getObject());
    }

    @Override
    public void updateRef(String columnName, Ref x2) throws SQLException {
        this.updateRef(this.findColumn(columnName), x2);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateBlob(String columnName, Blob x2) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x2);
    }

    @Override
    public void updateClob(int columnIndex, Clob x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateClob(String columnName, Clob x2) throws SQLException {
        this.updateClob(this.findColumn(columnName), x2);
    }

    @Override
    public void updateArray(int columnIndex, Array x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateArray(String columnName, Array x2) throws SQLException {
        this.updateObjectInner(this.findColumn(columnName), x2);
    }

    @Override
    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    @Override
    public void rollback(Savepoint s2) throws SQLException {
        this.getConnection().rollback(s2);
    }

    @Override
    public DmdbConnection getConnection() throws SQLException {
        if (!this.m_closed && this.m_conn_bs != null && !this.m_conn_bs.do_isClosed()) {
            return this.m_conn_bs;
        }
        String dataSourceName = this.getDataSourceName();
        if (dataSourceName != null) {
            try {
                Properties localProperties = System.getProperties();
                InitialContext initialcontext = new InitialContext(localProperties);
                DmdbDataSource datasource = (DmdbDataSource)initialcontext.lookup(dataSourceName);
                this.m_conn_bs = (DmdbConnection)datasource.getConnection();
            }
            catch (NamingException namingexception) {
                DBError.throwException("Unable to connect through the DataSource", namingexception);
            }
        } else {
            Properties props = new Properties();
            if (StringUtil.isNotEmpty(this.m_userName)) {
                props.setProperty("user", this.m_userName);
            }
            if (StringUtil.isNotEmpty(this.m_password)) {
                props.setProperty("password", this.m_password);
            }
            this.m_conn_bs = (DmdbConnection)DmDriver.driver.connect(this.getUrl(), props);
        }
        this.m_conn_bs.do_setTransactionIsolation(this.getTransactionIsolation());
        this.m_conn_bs.do_setTypeMap(this.getTypeMap());
        this.m_closed = false;
        return this.m_conn_bs;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj);
        }
        if (obj instanceof SerialBlob) {
            SerialBlob blob = (SerialBlob)obj;
            byte[] bs = ConvertUtil.getBlobData(blob);
            return new String(bs);
        }
        if (obj instanceof SerialClob) {
            SerialClob clob = (SerialClob)obj;
            return ConvertUtil.getClobData(clob);
        }
        return obj.toString();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes()[0];
        }
        if (obj instanceof SerialBlob) {
            SerialBlob blob = (SerialBlob)obj;
            byte[] bs = ConvertUtil.getBlobData(blob);
            return bs[0];
        }
        if (obj instanceof SerialClob) {
            SerialClob clob = (SerialClob)obj;
            return ConvertUtil.getClobData(clob).getBytes()[0];
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return 0;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        if (obj instanceof Number) {
            return obj.toString().getBytes();
        }
        if (obj instanceof SerialBlob) {
            SerialBlob blob = (SerialBlob)obj;
            byte[] bs = ConvertUtil.getBlobData(blob);
            return bs;
        }
        if (obj instanceof SerialClob) {
            SerialClob clob = (SerialClob)obj;
            return ConvertUtil.getClobData(clob).getBytes();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.m_rsmd;
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.m_resultSet_bs != null) {
            return this.m_resultSet_bs.do_getStatement();
        }
        DBError.ECJDBC_ROW_SET_RS_NOT_OPEN.throwz(new Object[0]);
        return null;
    }

    @Override
    public void setMetaData(RowSetMetaData md) throws SQLException {
        this.m_rsmd = (DmdbRowSetMetaData)md;
        if (this.m_rsmd != null) {
            this.m_columnCount = this.m_rsmd.getColumnCount();
            this.m_columnNames = new String[this.m_columnCount];
            int i2 = 0;
            while (i2 < this.m_columnCount) {
                this.m_columnNames[i2] = this.m_rsmd.getColumnName(i2 + 1);
                ++i2;
            }
        }
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        DmdbRowSet cachedrowset = new DmdbRowSet();
        cachedrowset.m_rsmd = this.m_rsmd;
        cachedrowset.m_rowCount = this.m_rowCount;
        cachedrowset.m_columnCount = this.m_columnCount;
        cachedrowset.m_currentRow = 0;
        cachedrowset.setType(1004);
        cachedrowset.setConcurrency(1008);
        cachedrowset.setReader(null);
        cachedrowset.setWriter(null);
        Row row = null;
        int i2 = 0;
        while (i2 < this.m_rows.size()) {
            row = new Row(this.m_columnCount, this.m_rows.elementAt(i2).getOriginalRow());
            cachedrowset.m_rows.add(row);
            ++i2;
        }
        return cachedrowset;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        DmdbRowSet cachedrowset = new DmdbRowSet();
        cachedrowset.m_rsmd = this.m_rsmd;
        cachedrowset.m_rowCount = 1;
        cachedrowset.m_columnCount = this.m_columnCount;
        cachedrowset.m_currentRow = 0;
        cachedrowset.setReader(null);
        cachedrowset.setWriter(null);
        Row row = new Row(this.m_rsmd.getColumnCount(), this.getCurrentRow().getOriginalRow());
        cachedrowset.m_rows.add(row);
        return cachedrowset;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long && this.m_conn_bs.msgVersion < 9) {
            return new DmdbRowId(ByteUtil.fromLong((Long)obj));
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x2) throws SQLException {
        this.updateObjectInner(this.findColumn(columnLabel), x2);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_resultSet_bs.holdability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateClob(columnIndex, (Clob)nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateClob(columnLabel, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return (NClob)this.getClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return (NClob)this.getClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.updateObjectInner(columnIndex, xmlObject == null ? null : ((DmdbSQLXML)xmlObject).serializeAsCharacterStream());
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.updateCharacterStream(columnIndex, x2);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(columnLabel, reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setObjectInner((Object)parameterName, null, sqlType, false);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setObjectInner((Object)parameterName, null, sqlType, typeName);
    }

    @Override
    public void setBoolean(String parameterName, boolean x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setByte(String parameterName, byte x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setShort(String parameterName, short x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setInt(String parameterName, int x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setLong(String parameterName, long x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setFloat(String parameterName, float x2) throws SQLException {
        this.setObjectInner(parameterName, Float.valueOf(x2));
    }

    @Override
    public void setDouble(String parameterName, double x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setString(String parameterName, String x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBytes(String parameterName, byte[] x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setObjectInner(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setObjectInner(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        this.setObjectInner((Object)parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.setObjectInner((Object)parameterName, x2, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setObjectInner(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setObjectInner(parameterName, inputStream);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setObjectInner(parameterIndex, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setObjectInner(parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setDate(String parameterName, Date x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, cal);
    }

    @Override
    public void setTime(String parameterName, Time x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setTime(String parameterName, Time x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, cal);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setObjectInner(parameterIndex, xmlObject);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setObjectInner(parameterName, xmlObject);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setRowId(String parameterName, RowId x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setString(parameterName, value);
    }

    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)value, length);
    }

    public void setCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setClob(parameterName, (Clob)value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(parameterName, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, (Clob)value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setURL(int parameterIndex, URL x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public RowSet createShared() throws SQLException {
        DmdbRowSet rowset = new DmdbRowSet();
        this.rowsetShared(rowset);
        return rowset;
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        DmdbRowSet rowset = new DmdbRowSet();
        this.rowsetCopy(rowset);
        return rowset;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        DmdbRowSet rowset = (DmdbRowSet)this.createCopy();
        rowset.m_rows = null;
        rowset.m_currentRow = 0;
        rowset.m_rowCount = 0;
        return rowset;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        DmdbRowSet rowset = (DmdbRowSet)this.createCopy();
        rowset.m_listeners = new Vector();
        rowset.unsetMatchColumn(rowset.getMatchColumnIndexes());
        rowset.unsetMatchColumn(rowset.getMatchColumnNames());
        return rowset;
    }

    @Override
    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
        if (numRows < 0 || numRows > this.m_rowCount) {
            DBError.ECJDBC_CRS_INVALID_ROW_PARAM.throwz(new Object[0]);
        }
        if (this.m_rowCount % numRows == 0) {
            event = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }
}

