/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbDataSourceFactory;
import dm.jdbc.util.StringUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class DmdbDataSource
implements Serializable,
Referenceable,
DataSource {
    private static final long serialVersionUID = 1L;
    private PrintWriter logWriter;
    private int loginTimeout;
    protected String user;
    protected String password;
    private String hostName;
    private int port;
    private String url;

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (StringUtil.isNotEmpty(this.hostName)) {
            props.setProperty(Configuration.host.getName(), this.hostName);
        }
        if (this.port > 0) {
            props.setProperty(Configuration.port.getName(), String.valueOf(this.port));
        }
        if (StringUtil.isNotEmpty(username)) {
            props.setProperty(Configuration.user.getName(), username);
        }
        if (StringUtil.isNotEmpty(password)) {
            props.setProperty(Configuration.password.getName(), password);
        }
        return DmDriver.driver.connect(this.getURL(), props);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public String getURL() {
        return StringUtil.isNotEmpty(this.url) ? this.url : "jdbc:dm://" + this.hostName + ":" + this.port;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getServer() {
        return this.hostName;
    }

    public void setServer(String server) {
        this.hostName = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p2) {
        this.port = p2;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Reference getReference() throws NamingException {
        String factoryName = DmdbDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr(Configuration.host.getName(), this.getServer()));
        ref.add(new StringRefAddr(Configuration.port.getName(), String.valueOf(this.getPort())));
        if (this.url != null) {
            ref.add(new StringRefAddr(Configuration.url.getName(), this.url));
        }
        ref.add(new StringRefAddr(Configuration.user.getName(), this.getUser()));
        ref.add(new StringRefAddr(Configuration.password.getName(), this.password));
        return ref;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

