/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.readwritesplitting;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.api.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.api.SQLStatementVisitorEngine;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.opengauss.hostchooser.HostRequirement;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.readwritesplitting.ReadWriteSplittingHostSpec;
import org.opengauss.readwritesplitting.ReadWriteSplittingPgConnection;
import org.opengauss.util.HostSpec;

public class SqlRouteEngine {
    private static final String DATABASE_TYPE = "openGauss";
    private static final SQLParserEngine PARSE_ENGINE = new SQLParserEngine("openGauss", new CacheOption(128, 1024L));
    private static Log LOGGER = Logger.getLogger(SqlRouteEngine.class.getName());

    public static Connection getRoutedConnection(ReadWriteSplittingPgConnection readWriteSplittingPgConnection, String sql) throws SQLException {
        HostSpec hostSpec = SqlRouteEngine.route(sql, readWriteSplittingPgConnection);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Routed connection host spec: " + hostSpec);
        }
        return readWriteSplittingPgConnection.getConnectionManager().getConnection(hostSpec);
    }

    public static HostSpec route(String sql, ReadWriteSplittingPgConnection readWriteSplittingPgConnection) throws SQLException {
        ReadWriteSplittingHostSpec hostSpec = readWriteSplittingPgConnection.getReadWriteSplittingHostSpec();
        if (!readWriteSplittingPgConnection.getAutoCommit()) {
            return hostSpec.getWriteHostSpec();
        }
        try {
            if (HostRequirement.master == hostSpec.getTargetServerType()) {
                return hostSpec.getWriteHostSpec();
            }
            if (HostRequirement.secondary == hostSpec.getTargetServerType()) {
                return hostSpec.readLoadBalance();
            }
            ParseASTNode parseASTNode = PARSE_ENGINE.parse(sql, true);
            SQLStatement sqlStatement = new SQLStatementVisitorEngine(DATABASE_TYPE, false).visit(parseASTNode);
            if (SqlRouteEngine.isWriteRouteStatement(sqlStatement)) {
                return hostSpec.getWriteHostSpec();
            }
        }
        catch (Exception ignored) {
            return hostSpec.getWriteHostSpec();
        }
        return hostSpec.readLoadBalance();
    }

    private static boolean isWriteRouteStatement(SQLStatement sqlStatement) {
        return SqlRouteEngine.containsLockSegment(sqlStatement) || !(sqlStatement instanceof SelectStatement);
    }

    private static boolean containsLockSegment(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && SelectStatementHandler.getLockSegment((SelectStatement)((SelectStatement)sqlStatement)).isPresent();
    }
}

