/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.dsiext.dataengine;

import com.cloudera.dsi.core.impl.DSIDriver;
import com.cloudera.dsi.core.interfaces.IStatement;
import com.cloudera.dsi.core.utilities.AttributeDataMap;
import com.cloudera.dsi.core.utilities.Variant;
import com.cloudera.dsi.dataengine.impl.DSIDataEngine;
import com.cloudera.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.dsi.exceptions.BadAttrValException;
import com.cloudera.dsi.exceptions.BadPropertyKeyException;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.dsi.exceptions.InvalidOperationException;
import com.cloudera.dsi.exceptions.NumericOverflowException;
import com.cloudera.dsi.exceptions.ParsingException;
import com.cloudera.dsi.utilities.DSIMessageKey;
import com.cloudera.sqlengine.aeprocessor.aebuilder.AETreeBuilder;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.cloudera.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.cloudera.sqlengine.dsiext.dataengine.IScalarFnMetadataHandler;
import com.cloudera.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.sqlengine.dsiext.dataengine.OperationHandlerFactory;
import com.cloudera.sqlengine.dsiext.dataengine.SqlCustomBehaviourProvider;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.sqlengine.dsiext.dataengine.SqlScalarFnMetadataHandler;
import com.cloudera.sqlengine.dsiext.dataengine.StoredProcedure;
import com.cloudera.sqlengine.dsiext.dataengine.ddl.TableSpecification;
import com.cloudera.sqlengine.dsiext.dataengine.utils.Variants;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.executor.conversions.SqlConverterGenerator;
import com.cloudera.sqlengine.parser.DefaultLimitChecker;
import com.cloudera.sqlengine.parser.IPTLimitChecker;
import com.cloudera.sqlengine.parser.PTParser;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.utilities.AEStringLogger;
import com.cloudera.sqlengine.utilities.PTStringLogger;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.SettingReader;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlDataEngine
extends DSIDataEngine {
    private AttributeDataMap m_engineProperties = new AttributeDataMap();
    private SqlDataEngineContext m_context = null;

    protected SqlDataEngine(IStatement iStatement) throws ErrorException {
        super(iStatement);
        this.loadProperties();
    }

    public ICoercionHandler createCoercionHandler() {
        return new AEMetadataCoercionHandler();
    }

    public IScalarFnMetadataHandler createScalarFnMetadataHandler() {
        return new SqlScalarFnMetadataHandler();
    }

    protected SqlQueryExecutor createQueryExecutor(AEStatements aEStatements) throws ErrorException {
        return new SqlQueryExecutor(aEStatements, this.getContext(), this.getLog());
    }

    public IMetadataHelper createMetadataHelper() {
        return null;
    }

    public OperationHandlerFactory createOperationHandlerFactory() {
        return null;
    }

    public SqlCustomBehaviourProvider createCustomBehaviorProvider() {
        return new SqlCustomBehaviourProvider();
    }

    public SqlConverterGenerator createSqlConverterGenerator() {
        return Holder.INSTANCE;
    }

    public void createTable(TableSpecification tableSpecification) throws ErrorException {
        throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.CREATE_TABLE_NOT_SUPPORTED.name());
    }

    public boolean doesTableExist(String string, String string2, String string3) throws ErrorException {
        return null != this.openTable(string, string2, string3, OpenTableType.READ_ONLY);
    }

    public void dropTable(String string, String string2, String string3, DropTableOption dropTableOption) throws ErrorException {
        throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.DROP_TABLE_NOT_SUPPORTED.name());
    }

    public SqlDataEngineContext getContext() {
        if (null == this.m_context) {
            throw new InvalidOperationException();
        }
        return this.m_context;
    }

    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        if (null == this.m_engineProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.m_engineProperties.isProperty(n)) {
            return this.m_engineProperties.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    public AttributeDataMap getPropertyMap() {
        return this.m_engineProperties;
    }

    public abstract StoredProcedure openProcedure(String var1, String var2, String var3) throws ErrorException;

    public abstract DSIExtJResultSet openTable(String var1, String var2, String var3, OpenTableType var4) throws ErrorException;

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        Object object;
        Object object2;
        IPTNode iPTNode = null;
        if (this.getProperty(6).getString().equalsIgnoreCase("Y")) {
            iPTNode = PTParser.parse(string);
        } else {
            object2 = new DefaultLimitChecker();
            ((DefaultLimitChecker)object2).initLimitCheckValues(this.getParentStatement().getParentConnection());
            iPTNode = PTParser.parse(string, (IPTLimitChecker)object2);
        }
        if (this.getProperty(7).getString().equalsIgnoreCase("Y")) {
            object2 = SettingReader.readSetting("LogPath");
            object = new File((String)object2, "ParseTree.log");
            try {
                PTStringLogger.writePTLogString(iPTNode, new FileOutputStream((File)object));
            }
            catch (Exception exception) {
                this.getLog().logError(this.getClass().getPackage().getName(), this.getClass().getName(), "prepare", "Could not create or write to ParseTree.log");
            }
        }
        this.m_context = new SqlDataEngineContext(this.getParentStatement(), this);
        object2 = AETreeBuilder.build(iPTNode, this);
        try {
            if (0L != (this.getProperty(4).getLong() & 1L)) {
                object = SettingReader.readSetting("LogPath");
                File file = new File((String)object, "AETree.log");
                AEStringLogger.logAETree((IAENode)object2, file.getPath(), new Timestamp(System.currentTimeMillis()).toString() + " :: Pre-Optimize ==============================================================");
            }
        }
        catch (IOException iOException) {
            this.getLog().logError(this.getClass().getPackage().getName(), this.getClass().getName(), "prepare", "Could not create or write to AETree.log");
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new AssertionError((Object)incorrectTypeException);
        }
        object = new AEStatements();
        ((AEStatements)object).addStatement((IAEStatement)object2);
        return this.createQueryExecutor((AEStatements)object);
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_ACTION_SQLENGINE.name());
    }

    @Override
    public void setDirectExecute() {
    }

    @Override
    public void setMetadataNeeded(boolean bl) {
    }

    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        if (null == this.m_engineProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        this.m_engineProperties.setProperty(n, variant);
    }

    private void loadProperties() {
        this.m_engineProperties.setProperty(0, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(1, Variants.makeWString("Y"));
        this.m_engineProperties.setProperty(2, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(3, Variants.makeWString("Y"));
        try {
            this.m_engineProperties.setProperty(4, Variants.makeUInt32(0L));
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
        this.m_engineProperties.setProperty(5, Variants.makeWString("Y"));
        this.m_engineProperties.setProperty(6, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(7, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(8, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(9, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(10, Variants.makeWString("N"));
    }

    private static class Holder {
        public static final SqlConverterGenerator INSTANCE = new SqlConverterGenerator();

        private Holder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DropTableOption {
        DROP_TABLE_CASCADE,
        DROP_TABLE_RESTRICT,
        DROP_TABLE_UNSPECIFIED;

    }
}

