/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AboutBlock
extends HtmlBlock {
    final ResourceManager rm;

    @Inject
    AboutBlock(ResourceManager rm, View.ViewContext ctx) {
        super(ctx);
        this.rm = rm;
    }

    protected void render(HtmlBlock.Block html) {
        html._(MetricsOverviewTable.class);
        ResourceManager rm = (ResourceManager)this.getInstance(ResourceManager.class);
        ClusterInfo cinfo = new ClusterInfo(rm);
        this.info("Cluster overview")._("Cluster ID:", (Object)cinfo.getClusterId())._("ResourceManager state:", (Object)cinfo.getState())._("ResourceManager HA state:", (Object)cinfo.getHAState())._("ResourceManager RMStateStore:", (Object)cinfo.getRMStateStore())._("ResourceManager started on:", (Object)Times.format((long)cinfo.getStartedOn()))._("ResourceManager version:", (Object)(cinfo.getRMBuildVersion() + " on " + cinfo.getRMVersionBuiltOn()))._("Hadoop version:", (Object)(cinfo.getHadoopBuildVersion() + " on " + cinfo.getHadoopVersionBuiltOn()));
        html._(InfoBlock.class);
    }
}

