/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

class CSQueueUtils {
    private static final Log LOG = LogFactory.getLog(CSQueueUtils.class);
    static final float EPSILON = 1.0E-4f;

    CSQueueUtils() {
    }

    public static void checkMaxCapacity(String queueName, float capacity, float maximumCapacity) {
        if (maximumCapacity < 0.0f || maximumCapacity > 1.0f) {
            throw new IllegalArgumentException("Illegal value  of maximumCapacity " + maximumCapacity + " used in call to setMaxCapacity for queue " + queueName);
        }
    }

    public static void checkAbsoluteCapacity(String queueName, float absCapacity, float absMaxCapacity) {
        if (absMaxCapacity < absCapacity - 1.0E-4f) {
            throw new IllegalArgumentException("Illegal call to setMaxCapacity. Queue '" + queueName + "' has " + "an absolute capacity (" + absCapacity + ") greater than " + "its absolute maximumCapacity (" + absMaxCapacity + ")");
        }
    }

    public static void checkAbsoluteCapacitiesByLabel(String queueName, Map<String, Float> absCapacities, Map<String, Float> absMaximumCapacities) {
        for (Map.Entry<String, Float> entry : absCapacities.entrySet()) {
            String label = entry.getKey();
            float absCapacity = entry.getValue().floatValue();
            float absMaxCapacity = absMaximumCapacities.get(label).floatValue();
            if (!(absMaxCapacity < absCapacity - 1.0E-4f)) continue;
            throw new IllegalArgumentException("Illegal call to setMaxCapacity. Queue '" + queueName + "' has " + "an absolute capacity (" + absCapacity + ") greater than " + "its absolute maximumCapacity (" + absMaxCapacity + ") of label=" + label);
        }
    }

    public static float computeAbsoluteMaximumCapacity(float maximumCapacity, CSQueue parent) {
        float parentAbsMaxCapacity = parent == null ? 1.0f : parent.getAbsoluteMaximumCapacity();
        return parentAbsMaxCapacity * maximumCapacity;
    }

    public static Map<String, Float> computeAbsoluteCapacityByNodeLabels(Map<String, Float> nodeLabelToCapacities, CSQueue parent) {
        if (parent == null) {
            return nodeLabelToCapacities;
        }
        HashMap<String, Float> absoluteCapacityByNodeLabels = new HashMap<String, Float>();
        for (Map.Entry<String, Float> entry : nodeLabelToCapacities.entrySet()) {
            String label = entry.getKey();
            float capacity = entry.getValue().floatValue();
            absoluteCapacityByNodeLabels.put(label, Float.valueOf(capacity * parent.getAbsoluteCapacityByNodeLabel(label)));
        }
        return absoluteCapacityByNodeLabels;
    }

    public static Map<String, Float> computeAbsoluteMaxCapacityByNodeLabels(Map<String, Float> maximumNodeLabelToCapacities, CSQueue parent) {
        if (parent == null) {
            return maximumNodeLabelToCapacities;
        }
        HashMap<String, Float> absoluteMaxCapacityByNodeLabels = new HashMap<String, Float>();
        for (Map.Entry<String, Float> entry : maximumNodeLabelToCapacities.entrySet()) {
            String label = entry.getKey();
            float maxCapacity = entry.getValue().floatValue();
            absoluteMaxCapacityByNodeLabels.put(label, Float.valueOf(maxCapacity * parent.getAbsoluteMaximumCapacityByNodeLabel(label)));
        }
        return absoluteMaxCapacityByNodeLabels;
    }

    public static int computeMaxActiveApplications(ResourceCalculator calculator, Resource clusterResource, Resource minimumAllocation, float maxAMResourcePercent, float absoluteMaxCapacity) {
        return Math.max((int)Math.ceil(Resources.ratio((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)minimumAllocation) * maxAMResourcePercent * absoluteMaxCapacity), 1);
    }

    public static int computeMaxActiveApplicationsPerUser(int maxActiveApplications, int userLimit, float userLimitFactor) {
        return Math.max((int)Math.ceil((float)maxActiveApplications * ((float)userLimit / 100.0f) * userLimitFactor), 1);
    }

    @Lock(value={CSQueue.class})
    public static void updateQueueStatistics(ResourceCalculator calculator, CSQueue childQueue, CSQueue parentQueue, Resource clusterResource, Resource minimumAllocation) {
        Resource queueLimit = Resources.none();
        Resource usedResources = childQueue.getUsedResources();
        float absoluteUsedCapacity = 0.0f;
        float usedCapacity = 0.0f;
        if (Resources.greaterThan((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)clusterResource, (Resource)Resources.none())) {
            queueLimit = Resources.multiply((Resource)clusterResource, (double)childQueue.getAbsoluteCapacity());
            absoluteUsedCapacity = Resources.divide((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)usedResources, (Resource)clusterResource);
            usedCapacity = Resources.equals((Resource)queueLimit, (Resource)Resources.none()) ? 0.0f : Resources.divide((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)usedResources, (Resource)queueLimit);
        }
        childQueue.setUsedCapacity(usedCapacity);
        childQueue.setAbsoluteUsedCapacity(absoluteUsedCapacity);
        Resource available = Resources.subtract((Resource)queueLimit, (Resource)usedResources);
        childQueue.getMetrics().setAvailableResourcesToQueue(Resources.max((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)available, (Resource)Resources.none()));
    }

    public static float getAbsoluteMaxAvailCapacity(ResourceCalculator resourceCalculator, Resource clusterResource, CSQueue queue) {
        CSQueue parent = queue.getParent();
        if (parent == null) {
            return queue.getAbsoluteMaximumCapacity();
        }
        float parentMaxAvail = CSQueueUtils.getAbsoluteMaxAvailCapacity(resourceCalculator, clusterResource, parent);
        Resource parentResource = Resources.multiply((Resource)clusterResource, (double)parentMaxAvail);
        if (Resources.isInvalidDivisor((ResourceCalculator)resourceCalculator, (Resource)parentResource)) {
            return 0.0f;
        }
        float siblingUsedCapacity = Resources.ratio((ResourceCalculator)resourceCalculator, (Resource)Resources.subtract((Resource)parent.getUsedResources(), (Resource)queue.getUsedResources()), (Resource)parentResource);
        float maxAvail = Math.min(queue.getMaximumCapacity(), 1.0f - siblingUsedCapacity);
        float absoluteMaxAvail = maxAvail * parentMaxAvail;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("qpath " + queue.getQueuePath()));
            LOG.debug((Object)("parentMaxAvail " + parentMaxAvail));
            LOG.debug((Object)("siblingUsedCapacity " + siblingUsedCapacity));
            LOG.debug((Object)("getAbsoluteMaximumCapacity " + queue.getAbsoluteMaximumCapacity()));
            LOG.debug((Object)("maxAvail " + maxAvail));
            LOG.debug((Object)("absoluteMaxAvail " + absoluteMaxAvail));
        }
        if (absoluteMaxAvail < 0.0f) {
            absoluteMaxAvail = 0.0f;
        } else if (absoluteMaxAvail > 1.0f) {
            absoluteMaxAvail = 1.0f;
        }
        return absoluteMaxAvail;
    }
}

