/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacitySchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.PlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.UTCClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public abstract class AbstractReservationSystem
extends AbstractService
implements ReservationSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReservationSystem.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private boolean initialized = false;
    private final Clock clock = new UTCClock();
    private AtomicLong resCounter = new AtomicLong();
    private Map<String, Plan> plans = new HashMap<String, Plan>();
    private Map<ReservationId, String> resQMap = new HashMap<ReservationId, String>();
    private RMContext rmContext;
    private ResourceScheduler scheduler;
    private ScheduledExecutorService scheduledExecutorService;
    protected Configuration conf;
    protected long planStepSize;
    private PlanFollower planFollower;

    public AbstractReservationSystem(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRMContext(RMContext rmContext) {
        this.writeLock.lock();
        try {
            this.rmContext = rmContext;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws YarnException {
        this.writeLock.lock();
        try {
            if (!this.initialized) {
                this.initialize(conf);
                this.initialized = true;
            } else {
                this.initializeNewPlans(conf);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initialize(Configuration conf) throws YarnException {
        LOG.info("Initializing Reservation system");
        this.conf = conf;
        this.scheduler = this.rmContext.getScheduler();
        this.planStepSize = conf.getTimeDuration("yarn.resourcemanager.reservation-system.planfollower.time-step", 1000L, TimeUnit.MILLISECONDS);
        if (this.planStepSize < 0L) {
            this.planStepSize = 1000L;
        }
        Set<String> planQueueNames = this.scheduler.getPlanQueues();
        for (String planQueueName : planQueueNames) {
            Plan plan = this.initializePlan(planQueueName);
            this.plans.put(planQueueName, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNewPlans(Configuration conf) {
        LOG.info("Refreshing Reservation system");
        this.writeLock.lock();
        try {
            Set<String> planQueueNames = this.scheduler.getPlanQueues();
            for (String planQueueName : planQueueNames) {
                if (!this.plans.containsKey(planQueueName)) {
                    Plan plan = this.initializePlan(planQueueName);
                    this.plans.put(planQueueName, plan);
                    continue;
                }
                LOG.warn("Plan based on reservation queue {0} already exists.", (Object)planQueueName);
            }
            if (this.planFollower != null) {
                this.planFollower.setPlans(this.plans.values());
            }
        }
        catch (YarnException e) {
            LOG.warn("Exception while trying to refresh reservable queues", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private PlanFollower createPlanFollower() {
        String planFollowerPolicyClassName = this.conf.get("yarn.resourcemanager.reservation-system.plan.follower", this.getDefaultPlanFollower());
        if (planFollowerPolicyClassName == null) {
            return null;
        }
        LOG.info("Using PlanFollowerPolicy: " + planFollowerPolicyClassName);
        try {
            Class planFollowerPolicyClazz = this.conf.getClassByName(planFollowerPolicyClassName);
            if (PlanFollower.class.isAssignableFrom(planFollowerPolicyClazz)) {
                return (PlanFollower)ReflectionUtils.newInstance((Class)planFollowerPolicyClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + planFollowerPolicyClassName + " not instance of " + PlanFollower.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate PlanFollowerPolicy: " + planFollowerPolicyClassName, (Throwable)e);
        }
    }

    private String getDefaultPlanFollower() {
        if (this.scheduler instanceof CapacityScheduler) {
            return CapacitySchedulerPlanFollower.class.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plan getPlan(String planName) {
        this.readLock.lock();
        try {
            Plan plan = this.plans.get(planName);
            return plan;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPlanFollowerTimeStep() {
        this.readLock.lock();
        try {
            long l = this.planStepSize;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizePlan(String planName) {
        this.writeLock.lock();
        try {
            Plan plan = this.plans.get(planName);
            if (plan != null) {
                this.planFollower.synchronizePlan(plan);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void serviceInit(Configuration conf) throws Exception {
        Configuration configuration = new Configuration(conf);
        this.reinitialize(configuration, this.rmContext);
        this.planFollower = this.createPlanFollower();
        if (this.planFollower != null) {
            this.planFollower.init(this.clock, this.scheduler, this.plans.values());
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        if (this.planFollower != null) {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
            this.scheduledExecutorService.scheduleWithFixedDelay(this.planFollower, 0L, this.planStepSize, TimeUnit.MILLISECONDS);
        }
        super.serviceStart();
    }

    public void serviceStop() {
        if (this.scheduledExecutorService != null && !this.scheduledExecutorService.isShutdown()) {
            this.scheduledExecutorService.shutdown();
        }
        this.plans.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQueueForReservation(ReservationId reservationId) {
        this.readLock.lock();
        try {
            String string = this.resQMap.get(reservationId);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueueForReservation(ReservationId reservationId, String queueName) {
        this.writeLock.lock();
        try {
            this.resQMap.put(reservationId, queueName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReservationId getNewReservationId() {
        this.writeLock.lock();
        try {
            ReservationId resId = ReservationId.newInstance((long)ResourceManager.getClusterTimeStamp(), (long)this.resCounter.incrementAndGet());
            LOG.info("Allocated new reservationId: " + resId);
            ReservationId reservationId = resId;
            return reservationId;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Map<String, Plan> getAllPlans() {
        return this.plans;
    }

    public static String getDefaultReservationSystem(ResourceScheduler scheduler) {
        if (scheduler instanceof CapacityScheduler) {
            return CapacityReservationSystem.class.getName();
        }
        return null;
    }

    protected abstract Plan initializePlan(String var1) throws YarnException;

    protected abstract Planner getReplanner(String var1);

    protected abstract ReservationAgent getAgent(String var1);

    protected abstract SharingPolicy getAdmissionPolicy(String var1);
}

