/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.value;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.sqlengine.executor.IWarningSource;
import com.cloudera.sqlengine.executor.conversions.ConversionUtil;
import com.cloudera.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.sqlengine.executor.etree.value.ETUnaryValueExpr;
import com.cloudera.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETConvert
extends ETUnaryValueExpr
implements IWarningSource {
    private IWarningListener m_warningListener;
    private ETDataRequest m_sourceData;
    private ISqlConverter m_converter;

    public ETConvert(ETValueExpr eTValueExpr, IColumn iColumn, ISqlConverter iSqlConverter) throws ErrorException {
        super(eTValueExpr);
        this.m_sourceData = new ETDataRequest(iColumn);
        this.m_sourceData.setMaxBytes(-1L);
        this.m_sourceData.setOffset(0L);
        this.m_converter = iSqlConverter;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        boolean bl = this.getOperand().retrieveData(this.m_sourceData);
        if (bl) {
            throw new IllegalStateException("Has more data after retrieve all data");
        }
        return ConversionUtil.doConvert(eTDataRequest, this.m_sourceData.getData(), this.m_converter, this.m_warningListener, false);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        if (iWarningListener == null) {
            throw new IllegalArgumentException("Warning listener can not be null.");
        }
        this.m_warningListener = iWarningListener;
    }
}

