/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.common;

import com.cloudera.dsi.core.interfaces.IConnection;
import com.cloudera.dsi.dataengine.interfaces.IArray;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.exceptions.JDBCMessageKey;
import com.cloudera.support.ILogger;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ExceptionType;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public abstract class SArray
implements Array {
    protected static final int RETRIEVE_ALL_DATA = -1;
    private IArray m_array;
    private IConnection m_parentConnection;
    private ILogger m_logger;
    private IWarningListener m_warningListener;

    public SArray(IArray iArray, IConnection iConnection, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_array = iArray;
        this.m_parentConnection = iConnection;
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            return this.createArray(1L, -1);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener());
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray(Map)");
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        try {
            return this.createArray(l, n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener());
        }
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray(long,int,Map)");
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            return TypeUtilities.mapDataTypes(this.m_array.getBaseColumn().getTypeMetadata().getType());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.m_array.getBaseColumn().getTypeMetadata().getTypeName();
    }

    public final int getUnmappedBaseType() throws SQLException {
        try {
            return this.m_array.getBaseColumn().getTypeMetadata().getType();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.createResultSet(1L, -1);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getResultSet(Map)");
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        try {
            return this.createResultSet(l, n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getResultSet(long,int,Map)");
    }

    @Override
    public void free() throws SQLException {
        try {
            this.m_array.free();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    protected abstract Object createArray(long var1, int var3) throws SQLException;

    protected abstract ResultSet createResultSet(long var1, int var3) throws SQLException;

    protected IArray getDSIArray() {
        return this.m_array;
    }

    protected ILogger getLogger() {
        return this.m_logger;
    }

    protected IConnection getParentConnection() {
        return this.m_parentConnection;
    }

    protected IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    public String toString() {
        return this.getDSIArray().getStringRepresentation();
    }
}

