/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.common4;

import com.cloudera.dsi.core.interfaces.IStatement;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.exceptions.JDBCMessageKey;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SPreparedStatement;
import com.cloudera.jdbc.common4.utilities.WrapperUtilities;
import com.cloudera.streams.parameters.AsciiParameterStream;
import com.cloudera.streams.parameters.BinaryParameterStream;
import com.cloudera.streams.parameters.CharacterParameterStream;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ExceptionType;
import com.cloudera.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;

public abstract class C4SPreparedStatement
extends SPreparedStatement {
    public C4SPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setAsciiStream(n, inputStream, -1);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(((TypeMetadata)this.m_setMetadata.get(n - 1)).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == inputStream) {
                this.setNull(n, -1);
            } else {
                AsciiParameterStream asciiParameterStream = new AsciiParameterStream(inputStream, l);
                this.setParameterInputStream(n, asciiParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setBinaryStream(n, inputStream, -1);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            } else if (TypeConverter.canConvertStreamTo(((TypeMetadata)this.m_setMetadata.get(n - 1)).getType(), -4)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            }
            if (null == inputStream) {
                this.setNull(n, -4);
            } else {
                BinaryParameterStream binaryParameterStream = new BinaryParameterStream(inputStream, l);
                this.setParameterInputStream(n, binaryParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.setCharacterStream(n, reader, -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(((TypeMetadata)this.m_setMetadata.get(n - 1)).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == reader) {
                this.setNull(n, -1);
            } else {
                CharacterParameterStream characterParameterStream = new CharacterParameterStream(reader, l);
                this.setParameterInputStream(n, characterParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, nClob);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNString(int n, String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, string);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), bl);
        this.checkIfOpen();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, rowId);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, sQLXML);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }
}

