/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ReaderToInputStream {
    public InputStream ReaderTo(Reader reader, Charset serverEncoding, long destLen) {
        return new SequenceInputStream(new InputStreamEnumerator(reader, serverEncoding, destLen));
    }

    public InputStream ReaderTo(Reader reader, Charset serverEncoding) {
        return new SequenceInputStream(new InputStreamEnumerator(reader, serverEncoding));
    }

    class InputStreamEnumerator
    implements Enumeration<ByteArrayInputStream> {
        private Reader m_reader = null;
        private long m_destLen = 0L;
        private long m_hasReadLen = 0L;
        private boolean m_hasDestLen = false;
        private Charset m_serverEncoding = null;
        private int m_Index = 0;
        private Map<Integer, ByteArrayInputStream> m_inputStream = new HashMap<Integer, ByteArrayInputStream>();

        public InputStreamEnumerator(Reader reader, Charset serverEncoding, long destLen) {
            this.m_reader = reader;
            this.m_serverEncoding = serverEncoding;
            this.m_destLen = destLen;
            this.m_hasDestLen = true;
            this.m_hasReadLen = 0L;
        }

        public InputStreamEnumerator(Reader reader, Charset serverEncoding) {
            this.m_reader = reader;
            this.m_serverEncoding = serverEncoding;
            this.m_destLen = 0L;
            this.m_hasDestLen = false;
            this.m_hasReadLen = 0L;
        }

        @Override
        public boolean hasMoreElements() {
            int bufLen = 32000;
            if (this.m_hasDestLen && (long)bufLen > this.m_destLen - this.m_hasReadLen) {
                bufLen = (int)(this.m_destLen - this.m_hasReadLen);
            }
            char[] charsTemp = new char[bufLen];
            byte[] bytesTemp = null;
            String strTemp = null;
            int len = 0;
            try {
                len = this.m_reader.read(charsTemp, 0, charsTemp.length);
                if (len > 0) {
                    strTemp = new String(charsTemp, 0, len);
                    bytesTemp = this.m_serverEncoding != null ? strTemp.getBytes(this.m_serverEncoding) : strTemp.getBytes();
                    this.m_inputStream.put(this.m_Index, new ByteArrayInputStream(bytesTemp, 0, bytesTemp.length));
                    if (this.m_hasDestLen) {
                        this.m_hasReadLen += (long)len;
                    }
                    return true;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return false;
        }

        @Override
        public ByteArrayInputStream nextElement() {
            ByteArrayInputStream ret = this.m_inputStream.get(this.m_Index);
            ++this.m_Index;
            return ret;
        }
    }
}

