/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.convert;

import dm.jdbc.driver.DBError;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ConvertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class OffRowStreamData
extends OffRowData {
    private int streamType;

    public OffRowStreamData(InputStream in, IDmdbConnection conn, long targetLength, int streamType) throws SQLException {
        super(in, conn, targetLength);
        this.streamType = streamType;
        this.init();
    }

    @Override
    public void read(ByteArrayQueue byteArray) throws SQLException {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArray);
        } else if (!this.readOver) {
            int readLen = this.READ_LEN;
            if (this.targetLength != -1L) {
                readLen = (int)(this.targetLength - this.position > (long)readLen ? (long)readLen : this.targetLength - this.position);
            }
            try {
                InputStream in = (InputStream)this.obj;
                byte[] readBytes = new byte[readLen];
                int iLen = 0;
                int off = 0;
                while (off < readLen) {
                    iLen = in.read(readBytes, off, readLen - off);
                    if (iLen <= 0) {
                        this.readOver = true;
                        break;
                    }
                    off += iLen;
                }
                readLen = off;
                this.position += (long)readLen;
                if (readLen < readBytes.length || this.targetLength != -1L && this.position == this.targetLength) {
                    this.readOver = true;
                }
                switch (this.streamType) {
                    case 2: {
                        char[] javaChars = ConvertUtil.ASCIIBytesToJavaChars(readBytes, 0, readLen);
                        byte[] bytes = J2DB.toVarchar(String.valueOf(javaChars), this.encoding);
                        byteArray.putBytes(bytes, 0, bytes.length);
                        break;
                    }
                    case 3: {
                        String javaChars = ConvertUtil.UnicodeBytesToString(readBytes, readLen);
                        byte[] bytes = J2DB.toVarchar(javaChars, this.encoding);
                        byteArray.putBytes(bytes, 0, bytes.length);
                        break;
                    }
                    default: {
                        byteArray.putBytes(readBytes, 0, readLen);
                        break;
                    }
                }
            }
            catch (IOException e2) {
                DBError.throwException(e2.getMessage(), e2);
            }
        }
    }

    @Override
    public byte[] readAll() throws SQLException {
        ByteArrayQueue byteArray = new ByteArrayQueue();
        this.read(byteArray);
        while (!this.readOver) {
            this.read(byteArray);
        }
        return byteArray.toBytes();
    }
}

