/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.reconnect;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.internal.conf.EPGroup;
import dm.jdbc.internal.processor.BaseThread;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ReconnectController
extends BaseThread {
    private static ILogger log = LogFactory.getLog(ReconnectController.class);
    public static final CacheQueue<DmdbConnection> connQueue = new CacheQueue<DmdbConnection>(Integer.MAX_VALUE, false){

        @Override
        protected boolean needRemove(DmdbConnection conn) {
            return conn.do_isClosed();
        }
    };
    boolean stop = false;

    public ReconnectController() {
        super("Reconnect-Controller");
    }

    @Override
    public void run() {
        HashMap<String, EPGroup> map = new HashMap<String, EPGroup>();
        while (!this.stop) {
            try {
                map.clear();
                DmSvcConf.GLOBAL.reload();
                int count = connQueue.size();
                int i2 = 0;
                while (i2 < count) {
                    DmdbConnection conn = connQueue.get();
                    if (conn != null) {
                        connQueue.put(conn);
                        if (conn.epGroup != null && !map.containsKey(conn.epGroup.name)) {
                            map.put(conn.epGroup.name, conn.epGroup);
                            if (conn.epGroup.checkTime <= 0L || System.currentTimeMillis() - conn.epGroup.checkTime >= (long)conn.epGroup.checkFreq) {
                                conn.epGroup.user = conn.user;
                                conn.epGroup.password = conn.password;
                                if ((conn.epGroup.reconnect & 4) != 0) {
                                    this.loadBalance(conn.epGroup);
                                }
                                if ((conn.epGroup.reconnect & 2) != 0) {
                                    this.epSelector(conn.epGroup);
                                }
                                conn.epGroup.checkTime = System.currentTimeMillis();
                            }
                        }
                        ++i2;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable ignore) {
                log.warn(this, "run", ignore.getMessage());
            }
            MiscUtil.sleep(1000L);
        }
    }

    private void loadBalance(EPGroup epGroup) {
        EP[] eps = new EP[epGroup.epList.size()];
        int aliveCount = 0;
        for (EP ep : epGroup.epList) {
            if (!this.checkEp(epGroup, ep, true)) continue;
            eps[aliveCount++] = ep;
        }
        if (aliveCount == 0) {
            log.debug("LoadBalanceFilter no alive ep: EPGroup [" + epGroup.name + "]");
            return;
        }
        List<Switch> swiches = this.calcSwitches(eps.length == aliveCount ? eps : Arrays.copyOf(eps, aliveCount), epGroup.allowRange);
        block1: for (Switch sw : swiches) {
            int connCount = connQueue.size();
            int i2 = 0;
            while (i2 < connCount) {
                DmdbConnection conn = connQueue.get();
                if (conn == null) continue block1;
                connQueue.put(conn);
                if (StringUtil.equals(conn.epGroup.name, epGroup.name) && conn.ep.equals(sw.sourceSite)) {
                    conn.switchToEpSeqno = sw.destSite.epSeqno;
                    continue block1;
                }
                ++i2;
            }
        }
    }

    private void epSelector(EPGroup epGroup) {
        EP[] eps = new EP[epGroup.epList.size()];
        int aliveCount = 0;
        for (EP ep : epGroup.epList) {
            if (!this.checkEp(epGroup, ep, false)) continue;
            eps[aliveCount++] = ep;
        }
        int connCount = connQueue.size();
        int i2 = 0;
        while (i2 < connCount) {
            DmdbConnection conn = connQueue.get();
            if (conn == null) break;
            connQueue.put(conn);
            if (StringUtil.equals(conn.epGroup.name, epGroup.name)) {
                int j2 = epGroup.epSelector.startPos;
                while (j2 < conn.ep.epSeqno) {
                    if (epGroup.epList.get((int)j2).alive) {
                        log.debug("ep selector mark :" + conn.switchToEpSeqno + " -> " + j2);
                        conn.switchToEpSeqno = j2;
                        break;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
    }

    public boolean checkEp(EPGroup epGroup, EP ep, boolean checkServerMode) {
        block7: {
            DmdbConnection conn;
            block6: {
                block5: {
                    conn = null;
                    conn = new DmdbConnection(epGroup.props);
                    conn.epGroup = epGroup;
                    conn.user = epGroup.user;
                    conn.password = epGroup.password;
                    ep.connect(conn);
                    if (!checkServerMode || this.checkServerMode(conn)) break block5;
                    MiscUtil.close(conn);
                    return false;
                }
                try {
                    DmdbResultSet rs = DriverUtil.executeQuery(conn, "select count(*) from v$sessions");
                    if (!rs.next()) break block6;
                    ep.sessions = rs.getLong(1);
                }
                catch (Exception ignore) {
                    try {
                        log.debug("LoadBalanceFilter get sessions failed: EP [" + ep + "]", ignore);
                    }
                    catch (Throwable throwable) {
                        MiscUtil.close(conn);
                        throw throwable;
                    }
                    MiscUtil.close(conn);
                    break block7;
                }
                MiscUtil.close(conn);
                return true;
            }
            MiscUtil.close(conn);
        }
        return false;
    }

    public boolean checkServerMode(DmdbConnection conn) throws SQLException {
        EPGroup group = conn.epGroup;
        if (group.loginDscCtrl && !conn.dscControl) {
            return false;
        }
        if (group.loginStatus > 0 && conn.svrStat != group.loginStatus) {
            return false;
        }
        switch (group.loginMode) {
            case 1: {
                return conn.svrMode == 1;
            }
            case 2: {
                return conn.svrMode == 2;
            }
        }
        return true;
    }

    public List<Switch> calcSwitches(EP[] sites, int allowRange) {
        ArrayList<Switch> switchList = new ArrayList<Switch>();
        int sum = 0;
        EP[] ePArray = sites;
        int n2 = sites.length;
        int n3 = 0;
        while (n3 < n2) {
            EP site = ePArray[n3];
            sum = (int)((long)sum + site.sessions);
            ++n3;
        }
        int average = (int)((double)(sum / sites.length) * (1.0 - (double)allowRange / 100.0));
        block1: while (true) {
            Arrays.sort(sites, EP.sessionComparator);
            EP minSite = sites[0];
            EP maxSite = sites[sites.length - 1];
            long minSessions = minSite.sessions;
            long maxSessions = maxSite.sessions;
            long switchSessions = Math.min((long)average - minSessions, maxSessions - (long)average);
            if (switchSessions <= 0L) break;
            int i2 = 0;
            while (true) {
                if ((long)i2 >= switchSessions) continue block1;
                --maxSite.sessions;
                ++minSite.sessions;
                switchList.add(new Switch((EP)maxSite.clone(), (EP)minSite.clone()));
                ++i2;
            }
            break;
        }
        log.debug("load balance mark :" + Arrays.toString(switchList.toArray()));
        return switchList;
    }

    public class Switch {
        public EP sourceSite;
        public EP destSite;

        public Switch(EP sourceSite, EP destSite) {
            this.sourceSite = sourceSite;
            this.destSite = destSite;
        }

        public String toString() {
            return this.sourceSite + " -> " + this.destSite;
        }
    }
}

