/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.sql.SQLException;

public class DmdbReader
extends Reader {
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    public static final int IS_CHAR = 3;
    private int typeFlag;
    private Object obj = null;
    private int objPos;
    private long objLength = -1L;
    private boolean cut = false;
    private char[] buf;
    private int bufPos = 0;
    private boolean closed;

    public DmdbReader(Object o2) throws SQLException {
        this.obj = o2;
        this.objPos = 0;
        this.closed = false;
        if (o2 instanceof DmdbClob) {
            this.typeFlag = 2;
            this.objLength = (int)((DmdbClob)o2).do_length();
        } else if (o2 instanceof DmdbBlob) {
            this.typeFlag = 1;
            this.objLength = (int)((DmdbBlob)o2).do_length();
        } else if (o2 instanceof String) {
            this.typeFlag = 3;
            this.obj = ((String)o2).toCharArray();
            this.objLength = ((char[])this.obj).length;
        } else if (o2 instanceof byte[]) {
            this.typeFlag = 3;
            this.obj = ConvertUtil.ASCIIBytesToJavaChars((byte[])o2, 0, ((byte[])o2).length);
            this.objLength = ((char[])this.obj).length;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    protected DmdbReader(DmdbClob clob, long pos, long length) throws SQLException {
        this(clob);
        this.objPos = (int)(pos - 1L);
        this.objLength = clob.do_length();
        this.objLength = Math.min(this.objLength, (long)this.objPos + length);
        this.cut = this.objPos > 0 || this.objLength < clob.do_length();
    }

    public Object useRealObject(long targetLength) {
        switch (this.typeFlag) {
            case 1: 
            case 2: {
                if (this.objPos != 0 || this.cut || -1L != targetLength && targetLength < this.objLength) break;
                return this.obj;
            }
        }
        return this;
    }

    @Override
    public int read(char[] dest, int destOff, int len) throws IOException {
        if (this.closed) {
            DBError.throwIOException(DBError.ECJDBC_STREAM_CLOSED.reason);
        }
        if (destOff < 0 || len < 0 || destOff + len > dest.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        } else if (this.avaliable() == 0) {
            return -1;
        }
        int readLen = 0;
        while (readLen < len) {
            int bufLeaveLen = this.bufLeaveLen();
            if (bufLeaveLen == 0 && (bufLeaveLen = this.fillBuffer()) <= 0) break;
            int needLen = len - readLen;
            int iLen = Math.min(needLen, bufLeaveLen);
            System.arraycopy(this.buf, this.bufPos, dest, destOff, iLen);
            this.bufPos += iLen;
            destOff += iLen;
            readLen += iLen;
        }
        return readLen;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        super.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return super.read(cbuf);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return super.read(target);
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public long skip(long n2) throws IOException {
        if (this.typeFlag == 1) {
            return super.skip(n2);
        }
        int skip = (int)Math.min((long)this.avaliable(), n2);
        if (skip <= 0) {
            return 0L;
        }
        int bufLeaveLen = this.bufLeaveLen();
        if (skip < bufLeaveLen) {
            this.bufPos += skip;
        } else {
            this.objPos += skip - bufLeaveLen;
            this.fillBuffer();
        }
        return skip;
    }

    private int avaliable() {
        return (int)((long)this.bufLeaveLen() + this.objLength - (long)this.objPos);
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private int fillBuffer() throws IOException {
        switch (this.typeFlag) {
            case 1: {
                return this.readFromBlob(32640);
            }
            case 2: {
                return this.readFromClob(16320);
            }
            case 3: {
                return this.readFromChars();
            }
        }
        DBError.throwIOException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
        return 0;
    }

    private int readFromChars() {
        int leaveLen = (int)(this.objLength - (long)this.objPos);
        int readLen = 0;
        if (leaveLen <= 0) {
            return -1;
        }
        this.buf = (char[])this.obj;
        readLen = this.buf == null ? 0 : this.buf.length;
        this.objPos += readLen;
        this.bufPos = 0;
        return readLen;
    }

    private int readFromBlob(int destLen) throws IOException {
        int readLen;
        int leaveLen;
        DmdbBlob blob;
        block3: {
            blob = (DmdbBlob)this.obj;
            leaveLen = (int)(this.objLength - (long)this.objPos);
            readLen = 0;
            if (leaveLen > 0) break block3;
            return -1;
        }
        try {
            destLen = Math.min(leaveLen, destLen);
            byte[] bytes = blob.do_getBytes(this.objPos + 1, destLen);
            this.buf = bytes == null ? new char[]{} : ByteUtil.getString(bytes, 0, bytes.length, blob.connection.getServerEncoding()).toCharArray();
            readLen = this.buf == null ? 0 : this.buf.length;
            this.objPos += readLen;
            this.bufPos = 0;
        }
        catch (SQLException sqle) {
            DBError.throwIOException(sqle.getMessage());
        }
        return readLen;
    }

    private int readFromClob(int destLen) throws IOException {
        int readLen;
        int leaveLen;
        DmdbClob clob;
        block3: {
            clob = (DmdbClob)this.obj;
            leaveLen = (int)(this.objLength - (long)this.objPos);
            readLen = 0;
            if (leaveLen > 0) break block3;
            return -1;
        }
        try {
            destLen = Math.min(leaveLen, destLen);
            String str = clob.do_getSubString(this.objPos + 1, destLen);
            this.buf = str == null ? new char[]{} : str.toCharArray();
            readLen = this.buf == null ? 0 : this.buf.length;
            this.objPos += destLen;
            this.bufPos = 0;
        }
        catch (SQLException sqle) {
            DBError.throwIOException(sqle.getMessage());
        }
        return readLen;
    }
}

