/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;

public class DmdbIntervalYM
implements Serializable {
    private static final long serialVersionUID = 1952079341353118308L;
    public static final byte QUA_Y = 0;
    public static final byte QUA_YM = 1;
    public static final byte QUA_MO = 2;
    private int leadScale = 0;
    private boolean isLeadScaleSet = false;
    public byte type = 0;
    public int years = 0;
    public int months = 0;
    private int scaleForSvr = 0;

    private DmdbIntervalYM(byte type, int year, int month, int scaleForSvr) {
        this.type = type;
        this.years = year;
        this.months = month;
        this.scaleForSvr = scaleForSvr;
        this.leadScale = scaleForSvr >> 4 & 0xF;
    }

    public DmdbIntervalYM(String str) throws SQLException {
        this.isLeadScaleSet = false;
        this.parseIntervYMString(str);
    }

    public DmdbIntervalYM(byte[] bs) {
        this.reset(bs);
    }

    private void reset(byte[] ym) {
        this.scaleForSvr = ByteUtil.getInt(ym, 8);
        this.leadScale = this.scaleForSvr >> 4 & 0xF;
        this.type = ym[9];
        switch (this.type) {
            case 0: {
                this.years = ByteUtil.getInt(ym, 0);
                break;
            }
            case 1: {
                this.years = ByteUtil.getInt(ym, 0);
                this.months = ByteUtil.getInt(ym, 4);
                break;
            }
            case 2: {
                this.months = ByteUtil.getInt(ym, 4);
            }
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof DmdbIntervalYM) {
            DmdbIntervalYM tm = (DmdbIntervalYM)o2;
            if (tm.type == this.type) {
                switch (this.type) {
                    case 0: {
                        if (this.years != tm.years) break;
                        return true;
                    }
                    case 1: {
                        if (this.years != tm.years || this.months != tm.months) break;
                        return true;
                    }
                    case 2: {
                        if (this.months != tm.months) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final int getYear() {
        return this.years;
    }

    public final int getMonth() {
        return this.months;
    }

    public final byte getYMType() {
        return this.type;
    }

    public final int getLeadScale() {
        return this.leadScale;
    }

    public final String toString() {
        String str = "INTERVAL ";
        switch (this.type) {
            case 0: {
                String year = String.valueOf(Math.abs(this.years));
                if (this.years < 0) {
                    str = String.valueOf(str) + "-";
                }
                if (this.leadScale > year.length()) {
                    int len = year.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        year = "0" + year;
                    }
                }
                str = String.valueOf(str) + "'" + year + "' YEAR(" + this.leadScale + ")";
                break;
            }
            case 1: {
                String year = String.valueOf(Math.abs(this.years));
                String month = String.valueOf(Math.abs(this.months));
                if (this.years < 0 || this.months < 0) {
                    str = String.valueOf(str) + "-";
                }
                if (this.leadScale > year.length()) {
                    int len = year.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        year = "0" + year;
                    }
                }
                if (month.length() < 2) {
                    month = "0" + month;
                }
                str = String.valueOf(str) + "'" + year + "-" + month + "' YEAR(" + this.leadScale + ") TO MONTH";
                break;
            }
            case 2: {
                String month = String.valueOf(Math.abs(this.months));
                if (this.months < 0) {
                    str = String.valueOf(str) + "-";
                }
                if (this.leadScale > month.length()) {
                    int len = month.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        month = "0" + month;
                    }
                }
                str = String.valueOf(str) + "'" + month + "' MONTH(" + this.leadScale + ")";
            }
        }
        return str;
    }

    public byte[] encode(int scale) throws SQLException {
        if (scale == 0) {
            scale = this.scaleForSvr;
        }
        int year = this.years;
        int month = this.months;
        this.checkScale(this.leadScale);
        if (scale != this.scaleForSvr) {
            DmdbIntervalYM convertYM = this.convertTo(scale);
            year = convertYM.years;
            month = convertYM.months;
        } else {
            this.checkScale(this.leadScale);
        }
        byte[] ym = new byte[12];
        ByteUtil.setInt(ym, 0, year);
        ByteUtil.setInt(ym, 4, month);
        ByteUtil.setInt(ym, 8, scale);
        return ym;
    }

    public DmdbIntervalYM convertTo(int scale) throws SQLException {
        int destType = (scale & 0xFF00) >> 8;
        int leadPrec = scale >> 4 & 0xF;
        long totalMonths = this.years * 12 + this.months;
        long year = 0L;
        long month = 0L;
        switch (destType) {
            case 0: {
                year = totalMonths / 12L;
                if (totalMonths % 12L >= 6L) {
                    ++year;
                } else if (totalMonths % 12L <= -6L) {
                    --year;
                }
                if (leadPrec >= String.valueOf(Math.abs(year)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 1: {
                year = this.years;
                month = this.months;
                if (leadPrec >= String.valueOf(Math.abs(year)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 2: {
                month = totalMonths;
                if (leadPrec >= String.valueOf(Math.abs(month)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
            }
        }
        return new DmdbIntervalYM((byte)destType, (int)year, (int)month, scale);
    }

    private int getLeadPrec(String str, int startIndex) throws SQLException {
        if (this.isLeadScaleSet) {
            return this.leadScale;
        }
        int leftBtId = str.indexOf("(", startIndex);
        int rightBtId = str.indexOf(")", startIndex);
        int leadPrec = 0;
        if (rightBtId == -1 && leftBtId == -1) {
            String dataStr;
            int l2 = str.indexOf("'");
            int r2 = l2 != -1 ? str.indexOf("'", l2 + 1) : -1;
            String string = dataStr = r2 != -1 ? str.substring(l2 + 1, r2).trim() : null;
            if (StringUtil.isNotEmpty(dataStr)) {
                int end;
                char sign = dataStr.charAt(0);
                if (sign == '+' || sign == '-') {
                    dataStr = dataStr.substring(1).trim();
                }
                dataStr = (end = dataStr.indexOf("-")) != -1 ? dataStr.substring(0, end) : dataStr;
                leadPrec = dataStr.length();
            } else {
                leadPrec = 2;
            }
        } else if (rightBtId != -1 && leftBtId != -1 && rightBtId > leftBtId + 1) {
            String strPrec = str.substring(leftBtId + 1, rightBtId).trim();
            leadPrec = Integer.parseInt(strPrec);
        } else {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        return leadPrec;
    }

    private int[] getTimeValue(String subStr, int type) throws SQLException {
        int monthVal;
        int yearVal;
        boolean hasQuate = false;
        if (subStr.charAt(0) == '\'' && subStr.charAt(subStr.length() - 1) == '\'') {
            hasQuate = true;
            subStr = subStr.substring(1, subStr.length() - 1).trim();
        }
        boolean negative = false;
        if (subStr.startsWith("-")) {
            negative = true;
            subStr = subStr.substring(1);
        } else if (subStr.startsWith("+")) {
            negative = false;
            subStr = subStr.substring(1);
        }
        if (subStr.charAt(0) == '\'' && subStr.charAt(subStr.length() - 1) == '\'') {
            hasQuate = true;
            subStr = subStr.substring(1, subStr.length() - 1).trim();
        }
        if (!hasQuate) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        int lastSignIndex = subStr.lastIndexOf("-");
        String[] list = new String[2];
        if (lastSignIndex == -1 || lastSignIndex == 0) {
            list[0] = subStr;
            list[1] = "";
        } else {
            list[0] = subStr.substring(0, lastSignIndex);
            list[1] = subStr.substring(lastSignIndex + 1);
        }
        if (type == 1) {
            yearVal = Integer.parseInt(list[0]);
            monthVal = list[1].equalsIgnoreCase("") ? 0 : Integer.parseInt(list[1]);
            if (negative) {
                yearVal *= -1;
                monthVal *= -1;
            }
            if ((double)yearVal > Math.pow(10.0, this.leadScale) - 1.0 || (double)yearVal < 1.0 - Math.pow(10.0, this.leadScale)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        } else if (type == 0) {
            yearVal = Integer.parseInt(list[0]);
            monthVal = 0;
            if (negative) {
                yearVal *= -1;
            }
            if ((double)yearVal > Math.pow(10.0, this.leadScale) - 1.0 || (double)yearVal < 1.0 - Math.pow(10.0, this.leadScale)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        } else {
            yearVal = 0;
            monthVal = Integer.parseInt(list[0]);
            if (negative) {
                monthVal *= -1;
            }
            if ((double)monthVal > Math.pow(10.0, this.leadScale) - 1.0 || (double)monthVal < 1.0 - Math.pow(10.0, this.leadScale)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        }
        int[] ret = new int[]{yearVal, monthVal};
        return ret;
    }

    private void parseIntervYMString(String str) throws SQLException {
        String[] ret;
        int length;
        if (str == null) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        if ((length = (ret = (str = str.toUpperCase()).split(" ")).length) < 3 || !ret[0].equalsIgnoreCase("INTERVAL") || !ret[2].startsWith("YEAR") && !ret[2].startsWith("MONTH")) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = 1;
        int yearId = str.indexOf("YEAR");
        int monthId = str.indexOf("MONTH");
        int toId = str.indexOf("TO");
        if (toId == -1) {
            if (yearId != -1 && monthId == -1) {
                this.type = 0;
                this.leadScale = this.getLeadPrec(str, yearId);
            } else if (monthId != -1 && yearId == -1) {
                this.type = (byte)2;
                this.leadScale = this.getLeadPrec(str, monthId);
            } else {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        } else {
            if (yearId == -1 || monthId == -1) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
            this.type = 1;
            this.leadScale = this.getLeadPrec(str, yearId);
        }
        this.scaleForSvr = (this.type << 8) + (this.leadScale << 4);
        int[] timeVals = this.getTimeValue(ret[1], this.type);
        this.years = timeVals[0];
        this.months = timeVals[1];
        this.checkScale(this.leadScale);
    }

    private void checkScale(int prec) throws SQLException {
        switch (this.type) {
            case 0: {
                if (prec >= String.valueOf(Math.abs(this.years)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 1: {
                if (prec < String.valueOf(Math.abs(this.years)).length()) {
                    DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                }
                if (Math.abs(this.months) <= 11) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 2: {
                if (prec >= String.valueOf(Math.abs(this.months)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
            }
        }
    }

    public int getScaleForSvr() {
        return this.scaleForSvr;
    }
}

