/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.Filterable;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.internal.conf.EPGroup;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class DmDriver
extends Filterable
implements Driver {
    public static final String VERSION = "8.1.3.140";
    public static final String BUILD_DATE = "2024.03.20";
    public static final String SVN = "23562";
    public static final String BRANCH = "";
    public static final String VERSION_JDBC = "4.0";
    private static final String URL_PREFIX = "jdbc:dm://";
    private static final String URL_PREFIX_COMPATIBALE_ORACLE_2 = "jdbc:oracle:@";
    private static final String URL_PREFIX_COMPATIBALE_ORACLE = "jdbc:oracle:thin:@";
    public static final long STARTUP_TIME = System.currentTimeMillis();
    public static DmDriver driver = new DmDriver();
    private static final Map<String, EPGroup> epGroupMap = new ConcurrentHashMap<String, EPGroup>();
    public static AtomicLong IDGenerator;

    static {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (Exception exception) {
            DBError.throwRuntimeException("Can not load Driver class dm.jdbc.driver.DmDriver");
        }
        IDGenerator = new AtomicLong(0L);
    }

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmDriver() {
        super(null, null);
    }

    public static void main(String[] args) {
        String option;
        if (args != null && args.length > 0 && (StringUtil.equalsIgnoreCase("-e", option = args[0]) || StringUtil.equalsIgnoreCase("-d", option)) && args.length > 1) {
            String text = args[1];
            String engine = null;
            if (args.length > 2) {
                engine = args[2];
            }
            System.out.println(StringUtil.equalsIgnoreCase("-e", option) ? StringUtil.encrypt(text, engine) : StringUtil.decrypt(text, engine));
            return;
        }
        StringBuilder buff = new StringBuilder();
        buff.append("Dameng JDBC Driver V8.1.3.140-Build(2024.03.20-23562-)");
        buff.append(String.valueOf(StringUtil.LINE_SEPARATOR) + "usage: [options]");
        buff.append(StringUtil.LINE_SEPARATOR);
        buff.append(String.valueOf(StringUtil.LINE_SEPARATOR) + "options:");
        String format = String.valueOf(StringUtil.LINE_SEPARATOR) + "  | %-30s%s";
        buff.append(String.format(format, "-e text [engine]", "encrypt text, use the engine or dameng jdbc default"));
        buff.append(String.format(format, "-d text [engine]", "decrypt text, use the engine or dameng jdbc default"));
        System.out.println(buff.toString());
    }

    public DmdbConnection do_connect(DmProperties props) throws SQLException {
        if (props == null) {
            return null;
        }
        DmdbConnection conn = null;
        EPGroup dbGroup = (EPGroup)props.getObject(Configuration.epGroup.getName());
        if (dbGroup != null) {
            dbGroup.setAttributes(props);
            conn = new DmdbConnection(props);
            dbGroup.connect(conn);
        } else {
            String host = props.getTrimString(Configuration.host);
            int port = props.getInt(Configuration.port);
            ArrayList<EP> epList = new ArrayList<EP>(1);
            epList.add(new EP(host, port));
            dbGroup = new EPGroup(String.valueOf(host) + ":" + port, epList);
            dbGroup.props = props;
            dbGroup.setAttributes(props);
            props.setObject(Configuration.epGroup.getName(), dbGroup);
            conn = new DmdbConnection(props);
            dbGroup.connect(conn);
        }
        return conn;
    }

    private int oraclePrefix(String url) {
        int ret = -1;
        if (url.startsWith(URL_PREFIX_COMPATIBALE_ORACLE)) {
            ret = URL_PREFIX_COMPATIBALE_ORACLE.length();
        } else if (url.startsWith(URL_PREFIX_COMPATIBALE_ORACLE_2)) {
            ret = URL_PREFIX_COMPATIBALE_ORACLE_2.length();
        }
        return ret;
    }

    private DmProperties parseURL(String url, Properties info) throws SQLException {
        String configPath;
        url = StringUtil.trimToEmpty(url);
        int iprop = url.indexOf("?");
        String connUrl = url;
        String propUrl = BRANCH;
        if (iprop != -1) {
            connUrl = url.substring(0, iprop);
            propUrl = StringUtil.trimToEmpty(url.substring(iprop + 1));
        }
        connUrl = StringUtil.trimDeep(connUrl);
        String lowerConnUrl = connUrl.toLowerCase();
        int oraclePrefix = -1;
        if (lowerConnUrl.startsWith(URL_PREFIX)) {
            connUrl = connUrl.substring(URL_PREFIX.length());
        } else {
            oraclePrefix = this.oraclePrefix(lowerConnUrl);
            if (oraclePrefix > 0) {
                connUrl = connUrl.substring(oraclePrefix);
            } else {
                return null;
            }
        }
        DmProperties urlProps = new DmProperties();
        urlProps.setProperties(info);
        if (StringUtil.isNotEmpty(propUrl)) {
            String[] keyValues;
            String[] stringArray = keyValues = propUrl.split("&");
            int n2 = keyValues.length;
            int n3 = 0;
            while (n3 < n2) {
                String keyValue = stringArray[n3];
                int isep = keyValue.indexOf("=");
                if (isep != -1) {
                    String param = StringUtil.trimToEmpty(keyValue.substring(0, isep));
                    String value = StringUtil.trimToEmpty(keyValue.substring(isep + 1));
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = StringUtil.trimToEmpty(value.substring(1, value.length() - 1));
                    } else if (value.startsWith("(") && value.endsWith(")")) {
                        value = StringUtil.trimToEmpty(value.substring(1, value.length() - 1));
                    }
                    Configuration prop = Configuration.valueOf(param);
                    if (prop == null) {
                        urlProps.setProperty(param, value);
                    } else {
                        if (prop == Configuration.addressRemap || prop == Configuration.userRemap) {
                            String has = urlProps.getProperty(prop.getName());
                            value = StringUtil.isNotEmpty(has) ? String.valueOf(has) + "&(" + value.trim() + ")" : "(" + value.trim() + ")";
                        }
                        urlProps.setProperty(prop.getName(), value.trim());
                    }
                }
                ++n3;
            }
        }
        DmSvcConf dmsvcconf = StringUtil.isNotEmpty(configPath = urlProps.getProperty(Configuration.dmSvcConf.getName(), Configuration.dmSvcConf.getDefault())) ? DmSvcConf.load(configPath) : null;
        dmsvcconf = dmsvcconf == null ? DmSvcConf.GLOBAL : dmsvcconf;
        connUrl = this.addressRemap(connUrl, urlProps, dmsvcconf == null ? null : dmsvcconf.props);
        urlProps.setProperty(Configuration.url.getName(), url);
        Configuration.parseHostPort(connUrl, urlProps);
        this.userRemap(urlProps);
        EPGroup dbGroup = this.parseEpGroup(urlProps, dmsvcconf);
        urlProps.setNonExistProperties(dbGroup != null ? dbGroup.props : dmsvcconf.props);
        if (oraclePrefix > 0 && !Configuration.parseCompatibleUrl(urlProps)) {
            return null;
        }
        return urlProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EPGroup parseEpGroup(DmProperties urlProps, DmSvcConf dmsvcconf) {
        String groupName = urlProps.getString(Configuration.host);
        EPGroup dbGroup = null;
        String groupUrl = urlProps.getProperty(groupName);
        if (StringUtil.isNotEmpty(groupUrl)) {
            String value = StringUtil.trimToEmpty(groupUrl);
            Map<String, EPGroup> map = epGroupMap;
            synchronized (map) {
                String key = String.valueOf(groupName) + "=" + value;
                dbGroup = epGroupMap.get(key);
                if (dbGroup == null) {
                    if (value.startsWith("(") && value.endsWith(")")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if ((dbGroup = Configuration.parseEpGroup(groupName, value)) != null) {
                        dbGroup.props = new DmProperties(dmsvcconf.props);
                        dbGroup.setAttributes(dbGroup.props);
                        epGroupMap.put(key, dbGroup);
                    }
                }
            }
        }
        if (dbGroup == null) {
            dbGroup = dmsvcconf.getDBGroup(groupName);
        }
        if (dbGroup != null && dbGroup.epList.size() > 0) {
            urlProps.setObject(Configuration.epGroup.getName(), dbGroup);
        }
        return dbGroup;
    }

    private String addressRemap(String remapName, DmProperties urlProps, DmProperties dmsvcProps) {
        String[] remaps;
        String configStr;
        String configStr2;
        if (StringUtil.isEmpty(remapName)) {
            return remapName;
        }
        String configStr1 = urlProps == null ? BRANCH : urlProps.getProperty(Configuration.addressRemap.getName());
        String string = configStr2 = dmsvcProps == null ? BRANCH : dmsvcProps.getProperty(Configuration.addressRemap.getName());
        String string2 = StringUtil.isNotEmpty(configStr1) && StringUtil.isNotEmpty(configStr2) ? String.valueOf(configStr1) + "&" + configStr2 : (configStr = StringUtil.isNotEmpty(configStr1) ? configStr1 : configStr2);
        if (StringUtil.isEmpty(configStr)) {
            return remapName;
        }
        StringUtil.trimDeep(configStr);
        String[] stringArray = remaps = configStr.split("&");
        int n2 = remaps.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] addressRemap;
            String address1 = stringArray[n3];
            int start = address1.indexOf("(");
            int end = address1.indexOf(")");
            if (start >= 0 && end >= 0 && start <= end && StringUtil.equalsIgnoreCase((addressRemap = StringUtil.trimToEmpty(address1.substring(start + 1, end)).split(","))[0], remapName)) {
                remapName = addressRemap[1];
                break;
            }
            ++n3;
        }
        return remapName;
    }

    private void userRemap(DmProperties props) {
        String[] remaps;
        String user = props.getProperty(Configuration.user.getName());
        if (StringUtil.isEmpty(user)) {
            return;
        }
        String configStr = props.getProperty(Configuration.userRemap.getName());
        if (StringUtil.isEmpty(configStr)) {
            return;
        }
        StringUtil.trimDeep(configStr);
        String[] stringArray = remaps = configStr.split("&");
        int n2 = remaps.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] addressRemap;
            String address1 = stringArray[n3];
            int start = address1.indexOf("(");
            int end = address1.indexOf(")");
            if (start >= 0 && end >= 0 && start <= end && StringUtil.equals((addressRemap = StringUtil.trimToEmpty(address1.substring(start + 1, end)).split(","))[0], user)) {
                props.setProperty(Configuration.user.getName(), addressRemap[1]);
                break;
            }
            ++n3;
        }
    }

    @Override
    @Deprecated
    public Connection connect(String url, Properties info) throws SQLException {
        DmProperties props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        DmSvcConf.GLOBAL.setAttributes(props);
        this.createFilterChain(null, props);
        if (this.filterHead == null) {
            return this.do_connect(props);
        }
        return this.filterHead.Driver_connect(this, props);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DmProperties curProps = this.parseURL(url, info);
        ArrayList<DriverPropertyInfo> list = new ArrayList<DriverPropertyInfo>();
        for (Map.Entry<String, Configuration> item : Configuration.map.entrySet()) {
            Configuration propEnum = item.getValue();
            if (propEnum == null || !propEnum.isPublic()) continue;
            String value = curProps == null ? StringUtil.trimToEmpty(propEnum.getDefault()) : curProps.getProperty(propEnum.getName(), propEnum.getDefault() == null ? BRANCH : propEnum.getDefault().toString());
            DriverPropertyInfo propInfo = new DriverPropertyInfo(propEnum.getName(), value);
            propInfo.description = propEnum.getDescription();
            propInfo.required = propEnum.isRequired();
            propInfo.choices = propEnum.getChoices();
            list.add(propInfo);
        }
        return list.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        if (DmSvcConf.GLOBAL.compatibleOracle()) {
            return 11;
        }
        int pointIndex = VERSION.indexOf(".");
        String ver = "7";
        if (pointIndex != -1) {
            ver = VERSION.substring(0, pointIndex);
        }
        return Integer.parseInt(ver);
    }

    @Override
    public int getMinorVersion() {
        if (DmSvcConf.GLOBAL.compatibleOracle()) {
            return 1;
        }
        String fulVersion = VERSION;
        int pointIndex1 = fulVersion.indexOf(".");
        int pointIndex2 = -1;
        if (pointIndex1 != -1) {
            pointIndex2 = fulVersion.indexOf(".", pointIndex1 + 1);
        }
        String ver = "0";
        if (pointIndex1 != -1 && pointIndex2 != -1) {
            ver = fulVersion.substring(pointIndex1 + 1, pointIndex2);
        }
        return Integer.parseInt(ver);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

