/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.materializer;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AENull;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AERename;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEUnaryValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.conversions.ConversionUtil;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlBigIntDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlCharDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlDateDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlDoubleDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlExactNumDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlIntegerDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlRealDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlSmallIntDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlTimeDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlTimestampDataWrapper;
import com.cloudera.sqlengine.executor.datawrapper.SqlTinyIntDataWrapper;
import com.cloudera.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.sqlengine.executor.etree.value.ArithmeticExprType;
import com.cloudera.sqlengine.executor.etree.value.ETBinaryArithValueExpr;
import com.cloudera.sqlengine.executor.etree.value.ETColumnRef;
import com.cloudera.sqlengine.executor.etree.value.ETConstant;
import com.cloudera.sqlengine.executor.etree.value.ETError;
import com.cloudera.sqlengine.executor.etree.value.ETParameter;
import com.cloudera.sqlengine.executor.etree.value.ETUnaryArithValueExpr;
import com.cloudera.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.sqlengine.executor.etree.value.functor.arithmetic.ArithmeticFunctorFactory;
import com.cloudera.sqlengine.executor.etree.value.functor.arithmetic.BinaryArithmeticOperator;
import com.cloudera.sqlengine.executor.etree.value.functor.arithmetic.IUnaryArithmeticFunctor;
import com.cloudera.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.cloudera.sqlengine.executor.materializer.MaterializerBase;
import com.cloudera.sqlengine.executor.materializer.MaterializerContext;
import com.cloudera.sqlengine.executor.queryplan.IQueryPlan;
import com.cloudera.support.conv.CharConverter;
import com.cloudera.support.conv.ConversionResult;
import com.cloudera.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETValueExprMaterializer
extends MaterializerBase<ETValueExpr> {
    public ETValueExprMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public ETValueExpr visit(AEAdd aEAdd) throws ErrorException {
        return this.materializeBinArithExpr(aEAdd, ArithmeticExprType.ADDITION);
    }

    @Override
    public ETValueExpr visit(AEColumnReference aEColumnReference) throws ErrorException {
        MaterializerContext materializerContext = this.getContext();
        ETColumnRef eTColumnRef = materializerContext.getMaterializedValue(aEColumnReference);
        if (null == eTColumnRef) {
            ETRelationalExpr eTRelationalExpr = materializerContext.getMaterializedRelation(aEColumnReference.getNamedRelationalExpr());
            eTColumnRef = new ETColumnRef(eTRelationalExpr, aEColumnReference.getColumnNum(), aEColumnReference.isOuterReference());
            materializerContext.setMaterializedValue(aEColumnReference, eTColumnRef);
        }
        return eTColumnRef;
    }

    @Override
    public ETValueExpr visit(AEConcat aEConcat) throws ErrorException {
        return this.materializeBinArithExpr(aEConcat, ArithmeticExprType.ADDITION);
    }

    @Override
    public ETValueExpr visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Aggregate function");
    }

    @Override
    public ETValueExpr visit(AEDefault aEDefault) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("DEFAULT");
    }

    @Override
    public ETValueExpr visit(AEDivide aEDivide) throws ErrorException {
        return this.materializeBinArithExpr(aEDivide, ArithmeticExprType.DIVISION);
    }

    @Override
    public ETValueExpr visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Aggregate function");
    }

    @Override
    public ETValueExpr visit(AELiteral aELiteral) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        ETConstant eTConstant = this.doLiteralConversion(aELiteral.getStringValue(), aELiteral.getTypeMetadata(), conversionResult);
        if (conversionResult.getState() != null) {
            try {
                ConversionUtil.checkResult(conversionResult, this.getContext().getWarningListener(), -1, -1);
            }
            catch (ErrorException errorException) {
                return new ETError(errorException);
            }
        }
        return eTConstant;
    }

    @Override
    public ETValueExpr visit(AEMultiply aEMultiply) throws ErrorException {
        return this.materializeBinArithExpr(aEMultiply, ArithmeticExprType.MULTIPLICATION);
    }

    @Override
    public ETValueExpr visit(AENegate aENegate) throws ErrorException {
        return this.materializeUnaryArithExpr(aENegate, ArithmeticExprType.NEGATION);
    }

    @Override
    public ETValueExpr visit(AENull aENull) throws ErrorException {
        SqlCharDataWrapper sqlCharDataWrapper = new SqlCharDataWrapper(1);
        sqlCharDataWrapper.setNull();
        return new ETConstant(sqlCharDataWrapper);
    }

    @Override
    public ETValueExpr visit(AEParameter aEParameter) throws ErrorException {
        return new ETParameter(aEParameter.getInputData());
    }

    @Override
    public ETValueExpr visit(AEProxyColumn aEProxyColumn) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Aggregate");
    }

    @Override
    public ETValueExpr visit(AERename aERename) throws ErrorException {
        return aERename.getOperand().acceptVisitor(this);
    }

    @Override
    public ETValueExpr visit(AEScalarFn aEScalarFn) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Scalar function");
    }

    @Override
    public ETValueExpr visit(AESearchedCase aESearchedCase) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Searched case");
    }

    @Override
    public ETValueExpr visit(AESearchedWhenClause aESearchedWhenClause) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Case");
    }

    @Override
    public ETValueExpr visit(AESimpleCase aESimpleCase) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Simple case");
    }

    @Override
    public ETValueExpr visit(AESimpleWhenClause aESimpleWhenClause) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Simple when case");
    }

    @Override
    public ETValueExpr visit(AESubtract aESubtract) throws ErrorException {
        return this.materializeBinArithExpr(aESubtract, ArithmeticExprType.SUBTRACTION);
    }

    @Override
    public ETValueExpr visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Value subquery");
    }

    private ETConstant doLiteralConversion(String string, TypeMetadata typeMetadata, ConversionResult conversionResult) throws ErrorException {
        DefaultSqlDataWrapper defaultSqlDataWrapper = null;
        short s = typeMetadata.getType();
        switch (s) {
            case -5: {
                defaultSqlDataWrapper = new SqlBigIntDataWrapper();
                defaultSqlDataWrapper.setBigInt(CharConverter.toBigInt(string, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case 2: 
            case 3: {
                defaultSqlDataWrapper = new SqlExactNumDataWrapper(s);
                defaultSqlDataWrapper.setExactNumber(CharConverter.toExactNum(string, conversionResult, typeMetadata.getPrecision(), typeMetadata.getScale()));
                break;
            }
            case 6: 
            case 8: {
                defaultSqlDataWrapper = new SqlDoubleDataWrapper(s);
                defaultSqlDataWrapper.setDouble(CharConverter.toDouble(string, conversionResult));
                break;
            }
            case 7: {
                defaultSqlDataWrapper = new SqlRealDataWrapper();
                defaultSqlDataWrapper.setReal(CharConverter.toReal(string, conversionResult));
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                defaultSqlDataWrapper = new SqlCharDataWrapper(s);
                defaultSqlDataWrapper.setChar(string);
                break;
            }
            case 91: {
                defaultSqlDataWrapper = new SqlDateDataWrapper();
                defaultSqlDataWrapper.setDate(CharConverter.toDate(string, conversionResult, null));
                break;
            }
            case 92: {
                defaultSqlDataWrapper = new SqlTimeDataWrapper();
                defaultSqlDataWrapper.setTime(CharConverter.toTime(string, conversionResult, typeMetadata.getPrecision(), null));
                break;
            }
            case 93: {
                defaultSqlDataWrapper = new SqlTimestampDataWrapper();
                defaultSqlDataWrapper.setTimestamp(CharConverter.toTimestamp(string, conversionResult, typeMetadata.getPrecision(), null));
                break;
            }
            case 4: {
                defaultSqlDataWrapper = new SqlIntegerDataWrapper();
                defaultSqlDataWrapper.setInteger(CharConverter.toInteger(string, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case 5: {
                defaultSqlDataWrapper = new SqlSmallIntDataWrapper();
                defaultSqlDataWrapper.setSmallInt(CharConverter.toSmallint(string, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case -6: {
                defaultSqlDataWrapper = new SqlTinyIntDataWrapper();
                defaultSqlDataWrapper.setTinyInt(CharConverter.toTinyint(string, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case -11: 
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 16: {
                throw SQLEngineExceptionFactory.featureNotImplementedException(typeMetadata.getTypeName() + " literal.");
            }
            default: {
                throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + typeMetadata.getTypeName());
            }
        }
        return new ETConstant(defaultSqlDataWrapper);
    }

    private ETValueExpr materializeBinArithExpr(AEBinaryValueExpr aEBinaryValueExpr, ArithmeticExprType arithmeticExprType) throws ErrorException {
        AEValueExpr aEValueExpr = aEBinaryValueExpr.getLeftOperand();
        AEValueExpr aEValueExpr2 = aEBinaryValueExpr.getRightOperand();
        IColumn iColumn = aEValueExpr.getColumn();
        IColumn iColumn2 = aEValueExpr2.getColumn();
        ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(this);
        ETValueExpr eTValueExpr2 = aEValueExpr2.acceptVisitor(this);
        BinaryArithmeticOperator binaryArithmeticOperator = ArithmeticFunctorFactory.getBinaryArithFunctor(arithmeticExprType, aEBinaryValueExpr.getColumn(), iColumn, iColumn2);
        eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeed(eTValueExpr, iColumn, binaryArithmeticOperator.getLeftMetadata(), this.getContext());
        eTValueExpr2 = ConvMaterializeUtil.addConversionNodeWhenNeed(eTValueExpr2, iColumn2, binaryArithmeticOperator.getRightMetadata(), this.getContext());
        return new ETBinaryArithValueExpr(iColumn, eTValueExpr, iColumn2, eTValueExpr2, binaryArithmeticOperator.getFunctor());
    }

    private ETValueExpr materializeUnaryArithExpr(AEUnaryValueExpr aEUnaryValueExpr, ArithmeticExprType arithmeticExprType) throws ErrorException {
        AEValueExpr aEValueExpr = aEUnaryValueExpr.getOperand();
        IColumn iColumn = aEValueExpr.getColumn();
        IColumn iColumn2 = aEUnaryValueExpr.getColumn();
        ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(this);
        eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeed(eTValueExpr, iColumn, iColumn2, this.getContext());
        IUnaryArithmeticFunctor iUnaryArithmeticFunctor = ArithmeticFunctorFactory.getUnaryArithFunctor(arithmeticExprType, aEUnaryValueExpr.getTypeMetadata(), iColumn.getTypeMetadata());
        return new ETUnaryArithValueExpr(iColumn, eTValueExpr, iUnaryArithmeticFunctor);
    }
}

