/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree.relation;

import com.cloudera.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEAggregate
extends AEUnaryRelationalExpr {
    private AEValueExprList m_groupingList = null;
    private Map<Integer, Integer> m_groupingListOrdinals;
    private AEValueExprList m_aggregateList;
    private AEQueryScope m_queryScope;

    public AEAggregate(AERelationalExpr aERelationalExpr, AEValueExprList aEValueExprList, Map<Integer, Integer> map, AEValueExprList aEValueExprList2, AEQueryScope aEQueryScope) {
        super(aERelationalExpr);
        assert (aEValueExprList2 != null);
        if (aEValueExprList != null) {
            this.m_groupingList = aEValueExprList;
            this.m_groupingList.setParent(this);
        }
        this.m_aggregateList = aEValueExprList2;
        this.m_aggregateList.setParent(this);
        this.m_groupingListOrdinals = map;
        this.m_queryScope = aEQueryScope;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (iAENode == this) {
            return true;
        }
        if (!(iAENode instanceof AEAggregate)) {
            return false;
        }
        AEAggregate aEAggregate = (AEAggregate)iAENode;
        if (this.hasGroupingList() && !aEAggregate.hasGroupingList() || aEAggregate.hasGroupingList() && !this.hasGroupingList()) {
            return false;
        }
        return this.getOperand().isEquivalent(aEAggregate.getOperand()) && this.m_aggregateList.isEquivalent(aEAggregate.m_aggregateList) && (!this.hasGroupingList() && !aEAggregate.hasGroupingList() || this.m_groupingList.isEquivalent(aEAggregate.m_groupingList));
    }

    @Override
    public int getNumChildren() {
        if (this.hasGroupingList()) {
            return 3;
        }
        return 2;
    }

    @Override
    public AEAggregate copy() {
        if (this.hasGroupingList()) {
            return new AEAggregate(this.getOperand().copy(), this.m_groupingList.copy(), new HashMap<Integer, Integer>(this.m_groupingListOrdinals), this.m_aggregateList.copy(), this.m_queryScope);
        }
        return new AEAggregate(this.getOperand().copy(), null, new HashMap<Integer, Integer>(this.m_groupingListOrdinals), this.m_aggregateList.copy(), this.m_queryScope);
    }

    public boolean hasGroupingList() {
        return this.m_groupingList != null;
    }

    @Override
    protected IAENode getChild(int n) {
        switch (n) {
            case 0: {
                return this.getOperand();
            }
            case 1: {
                return this.m_aggregateList;
            }
            case 2: {
                if (this.hasGroupingList()) {
                    return this.m_groupingList;
                }
                throw new IndexOutOfBoundsException();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public AEValueExprList getGroupingList() {
        return this.m_groupingList;
    }

    public AEValueExprList getAggregationList() {
        return this.m_aggregateList;
    }

    public AEQueryScope getQueryScope() {
        return this.m_queryScope;
    }

    public Map<Integer, Integer> getGroupingListOrdinalMap() {
        return this.m_groupingListOrdinals;
    }
}

