/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.kerberos;

import com.cloudera.jdbc.kerberos.IBMKerberosAuthenticationHelper;
import com.cloudera.jdbc.kerberos.KerberosAuthenticationHelper;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogUtilities;
import java.security.AccessController;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Kerberos {
    public static Subject getSubjectViaJAASConfig(ILogger iLogger) throws LoginException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String string = System.getProperty("java.security.auth.login.config");
        if (null != string) {
            LogUtilities.logDebug("System.getProperty(java.security.auth.login.config): " + string, iLogger);
            if (null != System.getenv("KRB5_CONFIG")) {
                System.setProperty("java.security.krb5.conf", System.getenv("KRB5_CONFIG"));
            }
            Configuration configuration = Configuration.getConfiguration();
            LoginContext loginContext = new LoginContext("Client", null, null, configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        return null;
    }

    public static Subject getSubjectViaAccessControlContext(ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        return Subject.getSubject(AccessController.getContext());
    }

    public static Subject getSubjectViaTicketCache(ILogger iLogger) throws LoginException {
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        if (null != System.getenv("KRB5_CONFIG")) {
            System.setProperty("java.security.krb5.conf", System.getenv("KRB5_CONFIG"));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Configuration configuration = null;
        if ("IBM Corporation".equals(System.getProperty("java.vendor"))) {
            hashMap.put("refreshKrb5Config", "true");
            hashMap.put("useDefaultCcache", "true");
            hashMap.put("renewTGT", "true");
            hashMap.put("credsType", "initiator");
            configuration = new IBMKerberosAuthenticationHelper(hashMap);
        } else {
            object = System.getenv("KRB5CCNAME");
            if (null != object) {
                hashMap.put("ticketCache", (String)object);
            }
            hashMap.put("doNotPrompt", "true");
            hashMap.put("renewTGT", "true");
            hashMap.put("useTicketCache", "true");
            configuration = new KerberosAuthenticationHelper(hashMap);
        }
        object = new LoginContext("Client", null, null, configuration);
        ((LoginContext)object).login();
        return ((LoginContext)object).getSubject();
    }
}

