/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.core;

import com.cloudera.hivecommon.api.HiveExecutionContext;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogUtilities;
import java.util.HashMap;
import java.util.Map;

public class BackgroundFetcherExecutionContextMap {
    private static Map<Long, HiveExecutionContext> s_backgroundThreadToContext = new HashMap<Long, HiveExecutionContext>(65535);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HiveExecutionContext getContext(Long l) {
        Map<Long, HiveExecutionContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            ILogger iLogger;
            HiveExecutionContext hiveExecutionContext = s_backgroundThreadToContext.get(l);
            if (null != hiveExecutionContext && null != (iLogger = hiveExecutionContext.getLogger())) {
                LogUtilities.logDebug("Retrieving context from map, Foreground ID: " + String.valueOf(hiveExecutionContext.m_foregroundThreadID) + ", Background ID: " + String.valueOf(l), iLogger);
            }
            return hiveExecutionContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putContext(Long l, HiveExecutionContext hiveExecutionContext) {
        ILogger iLogger = hiveExecutionContext.getLogger();
        if (null != iLogger) {
            LogUtilities.logFunctionEntrance(iLogger, hiveExecutionContext);
        }
        Map<Long, HiveExecutionContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            s_backgroundThreadToContext.put(l, hiveExecutionContext);
            if (null != iLogger) {
                LogUtilities.logDebug("Adding context to map, Foreground ID: " + String.valueOf(hiveExecutionContext.m_foregroundThreadID) + ", Background ID: " + String.valueOf(l), iLogger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContext(Long l) {
        Map<Long, HiveExecutionContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            s_backgroundThreadToContext.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContext(HiveExecutionContext hiveExecutionContext) {
        ILogger iLogger = hiveExecutionContext.getLogger();
        if (null != iLogger) {
            LogUtilities.logFunctionEntrance(iLogger, hiveExecutionContext);
        }
        Map<Long, HiveExecutionContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            Long l = hiveExecutionContext.m_backgroundThreadID;
            HiveExecutionContext hiveExecutionContext2 = s_backgroundThreadToContext.get(l);
            if (null != hiveExecutionContext2 && hiveExecutionContext2.equals(hiveExecutionContext)) {
                s_backgroundThreadToContext.remove(l);
                if (null != iLogger) {
                    LogUtilities.logDebug("Removing context from map, Foreground ID: " + String.valueOf(hiveExecutionContext.m_foregroundThreadID) + ", Background ID: " + String.valueOf(l), iLogger);
                }
            }
        }
    }
}

