/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.datawrapper;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.sql.Date;

public final class SqlDateDataWrapper
extends DefaultSqlDataWrapper {
    private Date m_data;
    private boolean m_isSet = false;

    public Date getDate() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    public int getType() {
        return 91;
    }

    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setDate(Date date) {
        this.m_isSet = true;
        this.m_data = date;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            switch (dataWrapper.getType()) {
                case 91: {
                    this.setDate(dataWrapper.getDate());
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setDate(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

