/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.hivecommon.AuthMech;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.api.ExtendedHS2Client;
import com.cloudera.hivecommon.api.HiveServer2ClientFactory;
import com.cloudera.hivecommon.api.IHiveClient;
import com.cloudera.hivecommon.api.ZookeeperDynamicDiscovery;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.support.ILogger;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class ZooKeeperEnabledExtendedHS2Factory
extends HiveServer2ClientFactory {
    public static final String PARSEING_REGEX = "(.+):(\\d+)(.*)";
    public static final int IP_INDEX = 1;
    public static final int PORT_INDEX = 2;
    public static final int NAMESPACE_INDEX = 3;

    @Override
    public IHiveClient createClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        ZookeeperDynamicDiscovery zookeeperDynamicDiscovery = new ZookeeperDynamicDiscovery();
        TTransport tTransport = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (hiveJDBCSettings.m_dynamicServerDiscovery) {
            try {
                for (String string : hiveJDBCSettings.m_zooKeeperServers) {
                    ArrayList<String> arrayList;
                    Pattern pattern = Pattern.compile(PARSEING_REGEX);
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    String string2 = matcher.group(1);
                    int n = Integer.parseInt(matcher.group(2));
                    String string3 = matcher.group(3);
                    try {
                        arrayList = zookeeperDynamicDiscovery.retrieveInfoFromZooKeeper(string2, n, string3, hiveJDBCSettings.m_timeout);
                        bl = true;
                    }
                    catch (Exception exception) {
                        iLogger.logWarning(this.getClass().getPackage().toString(), this.getClass().getName(), "createClient", exception.getMessage());
                        stringBuilder.append(ExceptionConverter.getInstance().toSQLException(HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ZOOKEEPER_CONNECTION_ERROR.name(), new String[]{string, exception.getMessage()}), iWarningListener).getMessage());
                        continue;
                    }
                    if (null == arrayList) continue;
                    for (String string4 : arrayList) {
                        String[] stringArray = string4.split(":");
                        if (2 != stringArray.length) continue;
                        hiveJDBCSettings.m_host = stringArray[0];
                        if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech && hiveJDBCSettings.m_krbHostFQDN.equals("_HOST")) {
                            hiveJDBCSettings.m_krbHostFQDN = hiveJDBCSettings.m_host;
                        }
                        hiveJDBCSettings.m_port = Integer.parseInt(stringArray[1]);
                        try {
                            tTransport = ZooKeeperEnabledExtendedHS2Factory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
                        }
                        catch (ErrorException errorException) {
                            iLogger.logWarning(this.getClass().getPackage().toString(), this.getClass().getName(), "createClient", errorException.getMessage());
                            stringBuilder.append(ExceptionConverter.getInstance().toSQLException(HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_HIVESERVER_CONNECTION_ERROR.name(), new String[]{string4, errorException.getMessage()}), iWarningListener).getMessage());
                        }
                        if (null == tTransport) continue;
                        break;
                    }
                    if (null == tTransport && !bl) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), exception.getMessage() + stringBuilder.toString());
                errorException.initCause(exception);
                throw errorException;
            }
            if (null == tTransport) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), stringBuilder.toString());
                throw errorException;
            }
        } else {
            tTransport = ZooKeeperEnabledExtendedHS2Factory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
        }
        return new ExtendedHS2Client(hiveJDBCSettings, (TProtocol)new TBinaryProtocol(tTransport), iLogger, iWarningListener);
    }
}

