/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.parser.parsetree;

import com.cloudera.sqlengine.SQLEngineGenericContext;
import com.cloudera.sqlengine.parser.parsetree.AbstractPTNonterminalNode;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.parser.parsetree.IPTVisitor;
import com.cloudera.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.sqlengine.parser.type.PTPositionalType;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import com.cloudera.support.exceptions.ExceptionType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTNonterminalNode
extends AbstractPTNonterminalNode {
    private EnumMap<PTPositionalType, IPTNode> m_children;
    private final PTNonterminalType m_nonterminalType;

    public PTNonterminalNode(PTNonterminalType pTNonterminalType) {
        if (null == pTNonterminalType) {
            throw new NullPointerException("Type cannot be null.");
        }
        this.m_children = new EnumMap(PTPositionalType.class);
        this.m_nonterminalType = pTNonterminalType;
    }

    @Override
    public <T> T acceptVisitor(IPTVisitor<T> iPTVisitor) throws ErrorException {
        if (null == iPTVisitor) {
            throw new NullPointerException("Visitor cannot be null.");
        }
        return iPTVisitor.visit(this);
    }

    public PTNonterminalNode addChild(PTPositionalType pTPositionalType, IPTNode iPTNode) throws ErrorException {
        if (null == pTPositionalType || null == iPTNode) {
            throw new NullPointerException("Invalid arguments.");
        }
        if (this.m_children.containsKey((Object)pTPositionalType)) {
            throw SQLEngineGenericContext.s_SQLEngineMessages.createGeneralException(SQLEngineMessageKey.INVALID_ARGUMENT.name(), ExceptionType.DEFAULT);
        }
        this.m_children.put(pTPositionalType, iPTNode);
        return this;
    }

    public Set<PTPositionalType> getAllPositionalTypes() {
        return Collections.unmodifiableSet(this.m_children.keySet());
    }

    public IPTNode getChild(PTPositionalType pTPositionalType) {
        return this.m_children.get((Object)pTPositionalType);
    }

    @Override
    public Iterator<IPTNode> getChildItr() {
        return this.m_children.values().iterator();
    }

    public PTNonterminalType getNonterminalType() {
        return this.m_nonterminalType;
    }

    @Override
    public int numChildren() {
        return this.m_children.size();
    }

    public IPTNode removeChild(PTPositionalType pTPositionalType) {
        return this.m_children.remove((Object)pTPositionalType);
    }

    public IPTNode replaceChild(PTPositionalType pTPositionalType, IPTNode iPTNode) {
        if (null == iPTNode) {
            throw new NullPointerException("Child cannot be null.");
        }
        return this.m_children.put(pTPositionalType, iPTNode);
    }

    @Override
    public String toString() {
        return this.m_nonterminalType.name();
    }
}

