/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.common4;

import com.cloudera.dsi.core.interfaces.IStatement;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.exceptions.JDBCMessageKey;
import com.cloudera.jdbc.common.SCallableStatement;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common4.utilities.WrapperUtilities;
import com.cloudera.streams.IStream;
import com.cloudera.streams.parameters.AsciiParameterStream;
import com.cloudera.streams.parameters.BinaryParameterStream;
import com.cloudera.streams.parameters.CharacterParameterStream;
import com.cloudera.streams.parametersoutput.CharacterParameterDataStream;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ExceptionType;
import com.cloudera.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;

public abstract class C4SCallableStatement
extends SCallableStatement {
    private IStream m_currentStream = null;

    protected C4SCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                if (dataWrapper.isNull()) {
                    return null;
                }
                CharacterParameterDataStream characterParameterDataStream = new CharacterParameterDataStream(dataWrapper.getLongVarChar().getBytes("UTF-16"));
                this.m_currentStream = characterParameterDataStream;
                return characterParameterDataStream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), "CharacterStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public NClob getNClob(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNClob(this.getParameterIndex(string));
    }

    @Override
    public String getNString(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public String getNString(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNString(this.getParameterIndex(string));
    }

    @Override
    public RowId getRowId(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public RowId getRowId(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getRowId(this.getParameterIndex(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getSQLXML(this.getParameterIndex(string));
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setAsciiStream(n, inputStream, -1);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(((TypeMetadata)this.m_setMetadata.get(n - 1)).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == inputStream) {
                this.setNull(n, -1);
            } else {
                AsciiParameterStream asciiParameterStream = new AsciiParameterStream(inputStream, l);
                this.setParameterInputStream(n, asciiParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setBinaryStream(n, inputStream, -1);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            } else if (TypeConverter.canConvertStreamTo(((TypeMetadata)this.m_setMetadata.get(n - 1)).getType(), -4)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            }
            if (null == inputStream) {
                this.setNull(n, -4);
            } else {
                BinaryParameterStream binaryParameterStream = new BinaryParameterStream(inputStream, l);
                this.setParameterInputStream(n, binaryParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBinaryStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBinaryStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, blob);
        this.setBlob(this.getParameterIndex(string), blob);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBlob(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, l);
        this.setBlob(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.setCharacterStream(n, reader, -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(((TypeMetadata)this.m_setMetadata.get(n - 1)).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == reader) {
                this.setNull(n, -1);
            } else {
                CharacterParameterStream characterParameterStream = new CharacterParameterStream(reader, l);
                this.setParameterInputStream(n, characterParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clob);
        this.checkIfOpen();
        this.getParameterIndex(string);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setClob(this.getParameterIndex(string), reader);
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setNCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setNCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, nClob);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, nClob);
        this.setNClob(this.getParameterIndex(string), nClob);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setNClob(this.getParameterIndex(string), reader);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setNClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNString(int n, String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, string);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNString(String string, String string2) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, string2);
        this.setNString(this.getParameterIndex(string), string2);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), bl);
        this.checkIfOpen();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, rowId);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, rowId);
        this.setRowId(this.getParameterIndex(string), rowId);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, sQLXML);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLXML);
        this.setSQLXML(this.getParameterIndex(string), sQLXML);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    private void closeCurrentStream() throws SQLException {
        if (null == this.m_currentStream) {
            return;
        }
        try {
            this.m_currentStream.close();
            this.m_currentStream = null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }
}

