/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.jdbc41;

import com.cloudera.dsi.core.interfaces.IStatement;
import com.cloudera.dsi.dataengine.impl.DSIEmptyResultSet;
import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.dsi.dataengine.utilities.ExecutionResultType;
import com.cloudera.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.exceptions.JDBCMessageKey;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SForwardResultSet;
import com.cloudera.jdbc.common4.C4SPreparedStatement;
import com.cloudera.jdbc.jdbc41.S41ForwardResultSet;
import com.cloudera.jdbc.jdbc41.S41ParameterMetaData;
import com.cloudera.jdbc.jdbc41.S41ResultSetMetaData;
import com.cloudera.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ExceptionType;
import com.cloudera.utilities.JDBCVersion;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class S41PreparedStatement
extends C4SPreparedStatement {
    public S41PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        SForwardResultSet sForwardResultSet = null;
        sForwardResultSet = this.createsUpdatableResults() ? new S41UpdatableForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger()) : new S41ForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger());
        sForwardResultSet.setFetchSize(this.getFetchSize());
        return sForwardResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            S41ForwardResultSet s41ForwardResultSet = null;
            s41ForwardResultSet = new S41ForwardResultSet(this, new DSIEmptyResultSet(), this.getLogger());
            return s41ForwardResultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                ExecutionResults executionResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> iterator = executionResults.getResultItr();
                if (!iterator.hasNext()) {
                    return null;
                }
                ExecutionResult executionResult = iterator.next();
                if (iterator.hasNext()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
                }
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    ArrayList<? extends IColumn> arrayList = iResultSet.getSelectColumns();
                    if (null == arrayList) {
                        return null;
                    }
                    S41ResultSetMetaData s41ResultSetMetaData = null;
                    s41ResultSetMetaData = new S41ResultSetMetaData(arrayList, this.getLogger(), this.getWarningListener());
                    this.setResultSetMetadata(s41ResultSetMetaData);
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S41ParameterMetaData s41ParameterMetaData = null;
                s41ParameterMetaData = new S41ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s41ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

