/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.XAReturnValue;
import com.microsoft.sqlserver.jdbc.XidImpl;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class SQLServerXAResource
implements XAResource {
    private int timeoutSeconds;
    static final int XA_START = 0;
    static final int XA_END = 1;
    static final int XA_PREPARE = 2;
    static final int XA_COMMIT = 3;
    static final int XA_ROLLBACK = 4;
    static final int XA_FORGET = 5;
    static final int XA_RECOVER = 6;
    static final int XA_PREPARE_EX = 7;
    static final int XA_ROLLBACK_EX = 8;
    static final int XA_FORGET_EX = 9;
    static final int XA_INIT = 10;
    private SQLServerConnection controlConnection;
    private SQLServerConnection con;
    private static boolean xaInitDone;
    private static Integer xaInitLock;
    private String sResourceManagerId;
    private int enlistedTransactionCount;
    private final Logger xaLogger;
    private static int baseResourceID;
    private int tightlyCoupled = 0;
    public static final int SSTRANSTIGHTLYCPLD = 32768;
    private SQLServerCallableStatement[] xaStatements = new SQLServerCallableStatement[]{null, null, null, null, null, null, null, null, null, null};
    private final String traceID = " XAResourceID:" + SQLServerXAResource.nextResourceID();

    public String toString() {
        return this.traceID;
    }

    SQLServerXAResource(SQLServerConnection sQLServerConnection, SQLServerConnection sQLServerConnection2, String string) {
        this.xaLogger = SQLServerXADataSource.xaLogger;
        this.controlConnection = sQLServerConnection2;
        this.con = sQLServerConnection;
        Properties properties = sQLServerConnection.activeConnectionProperties;
        this.sResourceManagerId = properties == null ? "" : properties.getProperty(SQLServerDriverStringProperty.SERVER_NAME.toString()) + "." + properties.getProperty(SQLServerDriverStringProperty.DATABASE_NAME.toString()) + "." + properties.getProperty(SQLServerDriverIntProperty.PORT_NUMBER.toString());
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(this.toString() + " created by (" + string + ")");
        }
    }

    private synchronized SQLServerCallableStatement getXACallableStatementHandle(int n) throws SQLServerException {
        assert (n >= 0 && n <= 9);
        assert (n < this.xaStatements.length);
        if (null != this.xaStatements[n]) {
            return this.xaStatements[n];
        }
        CallableStatement callableStatement = null;
        switch (n) {
            case 0: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_start(?, ?, ?, ?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 1: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_end(?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 2: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare(?, ?, ?, ?, ?)}");
                break;
            }
            case 3: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_commit(?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 4: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback(?, ?, ?, ?, ?)}");
                break;
            }
            case 5: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget(?, ?, ?, ?, ?)}");
                break;
            }
            case 6: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_recover(?, ?, ?, ?)}");
                break;
            }
            case 7: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare_ex(?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 8: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback_ex(?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 9: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget_ex(?, ?, ?, ?, ?, ?)}");
                break;
            }
            default: {
                assert (false) : "Bad handle request:" + n;
                break;
            }
        }
        this.xaStatements[n] = (SQLServerCallableStatement)callableStatement;
        return this.xaStatements[n];
    }

    private synchronized void closeXAStatements() throws SQLServerException {
        for (int i = 0; i < this.xaStatements.length; ++i) {
            if (null == this.xaStatements[i]) continue;
            this.xaStatements[i].close();
            this.xaStatements[i] = null;
        }
    }

    final synchronized void close() throws SQLServerException {
        block3: {
            try {
                this.closeXAStatements();
            }
            catch (Exception exception) {
                if (!this.xaLogger.isLoggable(Level.WARNING)) break block3;
                this.xaLogger.warning(this.toString() + "Closing exception ignored: " + exception);
            }
        }
        if (null != this.controlConnection) {
            this.controlConnection.close();
        }
    }

    private String flagsDisplay(int n) {
        if (0 == n) {
            return "TMNOFLAGS";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        if (0 != (0x800000 & n)) {
            stringBuilder.append("TMENDRSCAN");
        }
        if (0 != (0x20000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMFAIL");
        }
        if (0 != (0x200000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMJOIN");
        }
        if (0 != (0x40000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMONEPHASE");
        }
        if (0 != (0x8000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMRESUME");
        }
        if (0 != (0x1000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSTARTRSCAN");
        }
        if (0 != (0x4000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSUCCESS");
        }
        if (0 != (0x2000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSUSPEND");
        }
        if (0 != (0x8000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("SSTRANSTIGHTLYCPLD");
        }
        return stringBuilder.toString();
    }

    private String cookieDisplay(byte[] byArray) {
        return Util.byteToHexDisplayString(byArray);
    }

    private String typeDisplay(int n) {
        switch (n) {
            case 0: {
                return "XA_START";
            }
            case 1: {
                return "XA_END";
            }
            case 2: {
                return "XA_PREPARE";
            }
            case 3: {
                return "XA_COMMIT";
            }
            case 4: {
                return "XA_ROLLBACK";
            }
            case 5: {
                return "XA_FORGET";
            }
            case 6: {
                return "XA_RECOVER";
            }
        }
        return "UNKNOWN" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XAReturnValue DTC_XA_Interface(int n, Xid xid, int n2) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " Calling XA function for type:" + this.typeDisplay(n) + " flags:" + this.flagsDisplay(n2) + " xid:" + XidImpl.xidDisplay(xid));
        }
        int n3 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (xid != null) {
            n3 = xid.getFormatId();
            byArray = xid.getGlobalTransactionId();
            byArray2 = xid.getBranchQualifier();
        }
        String string = "DTC_XA_";
        int n4 = 1;
        int n5 = 0;
        XAReturnValue xAReturnValue = new XAReturnValue();
        SQLServerPreparedStatement sQLServerPreparedStatement = null;
        try {
            Object[] objectArray;
            Object[] objectArray2;
            Object object;
            Object object2 = this;
            synchronized (object2) {
                if (this.controlConnection == null) {
                    try {
                        object = xaInitLock;
                        synchronized (object) {
                            if (!xaInitDone) {
                                objectArray2 = null;
                                objectArray2 = (SQLServerCallableStatement)this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_init_ex(?, ?,?)}");
                                objectArray2.registerOutParameter(1, 4);
                                objectArray2.registerOutParameter(2, 1);
                                objectArray2.registerOutParameter(3, 1);
                                try {
                                    objectArray2.execute();
                                }
                                catch (SQLServerException sQLServerException) {
                                    block63: {
                                        try {
                                            objectArray2.close();
                                            this.controlConnection.close();
                                        }
                                        catch (SQLException sQLException) {
                                            if (!this.xaLogger.isLoggable(Level.FINER)) break block63;
                                            this.xaLogger.finer(this.toString() + " Ignoring exception when closing failed execution. exception:" + sQLException);
                                        }
                                    }
                                    if (this.xaLogger.isLoggable(Level.FINER)) {
                                        this.xaLogger.finer(this.toString() + " exception:" + sQLServerException);
                                    }
                                    throw sQLServerException;
                                }
                                int n6 = objectArray2.getInt(1);
                                objectArray = objectArray2.getString(2);
                                String string2 = objectArray2.getString(3);
                                if (this.xaLogger.isLoggable(Level.FINE)) {
                                    this.xaLogger.fine(this.toString() + " Server XA DLL version:" + string2);
                                }
                                objectArray2.close();
                                if (0 != n6) {
                                    assert (null != objectArray && objectArray.length() > 1);
                                    this.controlConnection.close();
                                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_failedToInitializeXA"));
                                    Object[] objectArray3 = new Object[]{String.valueOf(n6), objectArray};
                                    XAException xAException = new XAException(messageFormat.format(objectArray3));
                                    xAException.errorCode = n6;
                                    if (this.xaLogger.isLoggable(Level.FINER)) {
                                        this.xaLogger.finer(this.toString() + " exception:" + xAException);
                                    }
                                    throw xAException;
                                }
                                xaInitDone = true;
                            }
                        }
                    }
                    catch (SQLServerException sQLServerException) {
                        objectArray2 = new MessageFormat(SQLServerException.getErrString("R_failedToCreateXAConnection"));
                        Object[] objectArray4 = new Object[]{new String(sQLServerException.getMessage())};
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " exception:" + objectArray2.format(objectArray4));
                        }
                        SQLServerException.makeFromDriverError(null, null, objectArray2.format(objectArray4), null, true);
                    }
                }
            }
            switch (n) {
                case 0: {
                    string = "START:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(0);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    sQLServerPreparedStatement.setInt(n4++, n2);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, -2);
                    sQLServerPreparedStatement.setInt(n4++, this.timeoutSeconds);
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    break;
                }
                case 1: {
                    string = "END:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(1);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    sQLServerPreparedStatement.setInt(n4++, n2);
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 2: {
                    string = "PREPARE:";
                    sQLServerPreparedStatement = (0x8000 & n2) == 32768 ? this.getXACallableStatementHandle(7) : this.getXACallableStatementHandle(2);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    if ((0x8000 & n2) == 32768) {
                        sQLServerPreparedStatement.setInt(n4++, n2);
                    }
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 3: {
                    string = "COMMIT:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(3);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    sQLServerPreparedStatement.setInt(n4++, n2);
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 4: {
                    string = "ROLLBACK:";
                    sQLServerPreparedStatement = (0x8000 & n2) == 32768 ? this.getXACallableStatementHandle(8) : this.getXACallableStatementHandle(4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    if ((0x8000 & n2) == 32768) {
                        sQLServerPreparedStatement.setInt(n4++, n2);
                    }
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 5: {
                    string = "FORGET:";
                    sQLServerPreparedStatement = (0x8000 & n2) == 32768 ? this.getXACallableStatementHandle(9) : this.getXACallableStatementHandle(5);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setBytes(n4++, byArray);
                    sQLServerPreparedStatement.setBytes(n4++, byArray2);
                    if ((0x8000 & n2) == 32768) {
                        sQLServerPreparedStatement.setInt(n4++, n2);
                    }
                    sQLServerPreparedStatement.setInt(n4++, n3);
                    break;
                }
                case 6: {
                    string = "RECOVER:";
                    sQLServerPreparedStatement = this.getXACallableStatementHandle(6);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                    sQLServerPreparedStatement.setInt(n4++, n2);
                    ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, -2);
                    break;
                }
                default: {
                    assert (false) : "Unknown execution type:" + n;
                    break;
                }
            }
            sQLServerPreparedStatement.execute();
            n5 = ((SQLServerCallableStatement)sQLServerPreparedStatement).getInt(1);
            object2 = ((SQLServerCallableStatement)sQLServerPreparedStatement).getString(2);
            if (n == 0) {
                object = ((SQLServerCallableStatement)sQLServerPreparedStatement).getString(9);
                if (this.xaLogger.isLoggable(Level.FINE)) {
                    this.xaLogger.fine(this.toString() + " Server XA DLL version:" + (String)object);
                }
            }
            if (3 == n5 && 1 != n && 2 != n || 0 != n5 && 3 != n5) {
                XAException xAException;
                block65: {
                    assert (null != object2 && ((String)object2).length() > 1);
                    object = new MessageFormat(SQLServerException.getErrString("R_failedFunctionXA"));
                    objectArray2 = new Object[]{string, String.valueOf(n5), object2};
                    xAException = new XAException(((Format)object).format(objectArray2));
                    xAException.errorCode = n5;
                    if (n == 1 && -7 == n5) {
                        try {
                            if (this.xaLogger.isLoggable(Level.FINER)) {
                                this.xaLogger.finer(this.toString() + " Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                            }
                            this.con.JTAUnenlistConnection();
                            --this.enlistedTransactionCount;
                            if (this.xaLogger.isLoggable(Level.FINER)) {
                                this.xaLogger.finer(this.toString() + " End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                            }
                        }
                        catch (SQLServerException sQLServerException) {
                            if (!this.xaLogger.isLoggable(Level.FINER)) break block65;
                            this.xaLogger.finer(this.toString() + " Ignoring exception:" + sQLServerException);
                        }
                    }
                }
                throw xAException;
            }
            if (n == 0) {
                object = ((SQLServerCallableStatement)sQLServerPreparedStatement).getBytes(6);
                if (object == null) {
                    objectArray2 = new MessageFormat(SQLServerException.getErrString("R_noTransactionCookie"));
                    Object[] objectArray5 = new Object[]{string};
                    SQLServerException.makeFromDriverError(null, null, objectArray2.format(objectArray5), null, true);
                } else {
                    try {
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " Begin enlisting, cookie:" + this.cookieDisplay((byte[])object) + " enlisted count:" + this.enlistedTransactionCount);
                        }
                        this.con.JTAEnlistConnection((byte[])object);
                        ++this.enlistedTransactionCount;
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " End enlisting, cookie:" + this.cookieDisplay((byte[])object) + " enlisted count:" + this.enlistedTransactionCount);
                        }
                    }
                    catch (SQLServerException sQLServerException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_failedToEnlist"));
                        objectArray = new Object[]{sQLServerException.getMessage()};
                        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
                    }
                }
            }
            if (n == 1) {
                try {
                    if (this.xaLogger.isLoggable(Level.FINER)) {
                        this.xaLogger.finer(this.toString() + " Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                    }
                    this.con.JTAUnenlistConnection();
                    --this.enlistedTransactionCount;
                    if (this.xaLogger.isLoggable(Level.FINER)) {
                        this.xaLogger.finer(this.toString() + " End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                    }
                }
                catch (SQLServerException sQLServerException) {
                    objectArray2 = new MessageFormat(SQLServerException.getErrString("R_failedToUnEnlist"));
                    Object[] objectArray6 = new Object[]{sQLServerException.getMessage()};
                    SQLServerException.makeFromDriverError(null, null, objectArray2.format(objectArray6), null, true);
                }
            }
            if (n == 6) {
                try {
                    xAReturnValue.bData = ((SQLServerCallableStatement)sQLServerPreparedStatement).getBytes(4);
                }
                catch (SQLServerException sQLServerException) {
                    objectArray2 = new MessageFormat(SQLServerException.getErrString("R_failedToReadRecoveryXIDs"));
                    Object[] objectArray7 = new Object[]{sQLServerException.getMessage()};
                    SQLServerException.makeFromDriverError(null, null, objectArray2.format(objectArray7), null, true);
                }
            }
        }
        catch (SQLServerException sQLServerException) {
            if (this.xaLogger.isLoggable(Level.FINER)) {
                this.xaLogger.finer(this.toString() + " exception:" + sQLServerException);
            }
            XAException xAException = new XAException(sQLServerException.toString());
            xAException.errorCode = -3;
            throw xAException;
        }
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " Status:" + n5);
        }
        xAReturnValue.nStatus = n5;
        return xAReturnValue;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        this.tightlyCoupled = n & 0x8000;
        this.DTC_XA_Interface(0, xid, n);
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        this.DTC_XA_Interface(1, xid, n | this.tightlyCoupled);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int n = 0;
        XAReturnValue xAReturnValue = this.DTC_XA_Interface(2, xid, this.tightlyCoupled);
        n = xAReturnValue.nStatus;
        return n;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        this.DTC_XA_Interface(3, xid, (bl ? 0x40000000 : 0) | this.tightlyCoupled);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.DTC_XA_Interface(4, xid, this.tightlyCoupled);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.DTC_XA_Interface(5, xid, this.tightlyCoupled);
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        int n2;
        int n3;
        XAReturnValue xAReturnValue = this.DTC_XA_Interface(6, null, n | this.tightlyCoupled);
        Vector<XidImpl> vector = new Vector<XidImpl>();
        if (null == xAReturnValue.bData) {
            return new XidImpl[0];
        }
        for (int i = 0; i < xAReturnValue.bData.length; i += n3) {
            int n4;
            int n5 = 1;
            n2 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                n3 = xAReturnValue.bData[i + n4] & 0xFF;
                n2 += (n3 *= n5);
                n5 *= 256;
            }
            i += 4;
            n4 = xAReturnValue.bData[i++] & 0xFF;
            n3 = xAReturnValue.bData[i++] & 0xFF;
            byte[] byArray = new byte[n4];
            byte[] byArray2 = new byte[n3];
            System.arraycopy(xAReturnValue.bData, i, byArray, 0, n4);
            System.arraycopy(xAReturnValue.bData, i += n4, byArray2, 0, n3);
            XidImpl xidImpl = new XidImpl(n2, byArray, byArray2);
            vector.add(xidImpl);
        }
        Xid[] xidArray = new XidImpl[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            xidArray[n2] = (XidImpl)vector.elementAt(n2);
            if (!this.xaLogger.isLoggable(Level.FINER)) continue;
            this.xaLogger.finer(this.toString() + ((XidImpl)xidArray[n2]).toString());
        }
        return xidArray;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " xares:" + xAResource);
        }
        if (!(xAResource instanceof SQLServerXAResource)) {
            return false;
        }
        SQLServerXAResource sQLServerXAResource = (SQLServerXAResource)xAResource;
        return sQLServerXAResource.sResourceManagerId.equals(this.sResourceManagerId);
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        this.timeoutSeconds = n;
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " TransactionTimeout:" + n);
        }
        return true;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeoutSeconds;
    }

    private static synchronized int nextResourceID() {
        return ++baseResourceID;
    }

    static {
        baseResourceID = 0;
        xaInitLock = new Integer(0);
    }
}

