/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.parser;

import com.cloudera.dsi.core.interfaces.IConnection;
import com.cloudera.dsi.exceptions.BadPropertyKeyException;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.dsi.exceptions.NumericOverflowException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.parser.IPTLimitChecker;
import com.cloudera.sqlengine.parser.type.PTCountLimit;
import com.cloudera.sqlengine.parser.type.PTStringConstraint;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.util.HashSet;

public class DefaultLimitChecker
implements IPTLimitChecker {
    private static final short DEFAULT_COUNT_VALUE = 0;
    private ParserLimits m_pLimits = new ParserLimits();

    public void checkString(PTStringConstraint pTStringConstraint, String string) throws SQLEngineException {
        switch (pTStringConstraint) {
            case BINARY_LITERAL_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxBinaryLiteralLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_BINARY_LITERAL_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxBinaryLiteralLen)});
            }
            case CATALOG_NAME_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxCatalogNameLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_CATALOG_NAME_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxCatalogNameLen)});
            }
            case CHAR_LITERAL_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxCharLiteralLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_CHAR_LITERAL_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxCharLiteralLen)});
            }
            case COLUMN_NAME_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxColumnNameLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_COLUMN_NAME_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxColumnNameLen)});
            }
            case CURSOR_NAME_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxCursorNameLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_CURSOR_NAME_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxCursorNameLen)});
            }
            case IDENTIFIER_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxIdentifierLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_IDENTIFIER_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxIdentifierLen)});
            }
            case PROCEDURE_NAME_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxProcedureNameLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_PROCEDURE_NAME_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxProcedureNameLen)});
            }
            case RESERVED_KEYWORD: {
                if (!this.m_pLimits.m_reservedKeywords.contains(string.toLowerCase())) break;
                throw this.createException(SQLEngineMessageKey.RESERVED_KEYWORD_USED.name(), new String[]{string});
            }
            case SCHEMA_NAME_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxSchemaNameLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_SCHEMA_NAME_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxSchemaNameLen)});
            }
            case STATEMENT_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxStatementLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_STATEMENT_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxStatementLen)});
            }
            case TABLE_NAME_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxTableNameLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_TABLE_NAME_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxTableNameLen)});
            }
            case USER_NAME_LEN: {
                if (this.check(string.length(), this.m_pLimits.m_maxUsernameLen)) break;
                throw this.createException(SQLEngineMessageKey.MAX_USERNAME_LEN_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxUsernameLen)});
            }
        }
    }

    public void checkCount(PTCountLimit pTCountLimit, int n) throws SQLEngineException {
        switch (pTCountLimit) {
            case COLUMNS_IN_GROUP_BY: {
                if (this.check(n, this.m_pLimits.m_maxColumnsInGroupBy)) break;
                throw this.createException(SQLEngineMessageKey.MAX_COLUMNS_IN_GROUP_BY_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxColumnsInGroupBy)});
            }
            case COLUMNS_IN_INDEX: {
                if (this.check(n, this.m_pLimits.m_maxColumnsInIndex)) break;
                throw this.createException(SQLEngineMessageKey.MAX_COLUMNS_IN_INDEX_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxColumnsInIndex)});
            }
            case COLUMNS_IN_ORDER_BY: {
                if (this.check(n, this.m_pLimits.m_maxColumnsInOrderBy)) break;
                throw this.createException(SQLEngineMessageKey.MAX_COLUMNS_IN_ORDER_BY_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxColumnsInOrderBy)});
            }
            case COLUMNS_IN_SELECT: {
                if (this.check(n, this.m_pLimits.m_maxColumnsInSelect)) break;
                throw this.createException(SQLEngineMessageKey.MAX_COLUMNS_IN_SELECT_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxColumnsInSelect)});
            }
            case COLUMNS_IN_TABLE: {
                if (this.check(n, this.m_pLimits.m_maxColumnsInTable)) break;
                throw this.createException(SQLEngineMessageKey.MAX_COLUMNS_IN_TABLE_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxColumnsInTable)});
            }
            case INDEX_SIZE: {
                if (this.check(n, this.m_pLimits.m_maxIndexSize)) break;
                throw this.createException(SQLEngineMessageKey.MAX_INDEX_SIZE_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxIndexSize)});
            }
            case ROW_SIZE: {
                if (this.check(n, this.m_pLimits.m_maxRowSize)) break;
                throw this.createException(SQLEngineMessageKey.MAX_ROW_SIZE_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxRowSize)});
            }
            case TABLES_IN_SELECT: {
                if (this.check(n, this.m_pLimits.m_maxTablesInSelect)) break;
                throw this.createException(SQLEngineMessageKey.MAX_TABLES_IN_SELECT_EXCEEDED.name(), new String[]{String.valueOf(this.m_pLimits.m_maxTablesInSelect)});
            }
        }
    }

    public DefaultLimitChecker initLimitCheckValues(IConnection iConnection) throws SQLEngineException {
        try {
            String[] stringArray;
            for (String string : stringArray = iConnection.getProperty(62).getString().split(",")) {
                this.m_pLimits.m_reservedKeywords.add(string.toLowerCase());
            }
            this.m_pLimits.m_maxBinaryLiteralLen = iConnection.getProperty(65).getLong();
            this.m_pLimits.m_maxCharLiteralLen = iConnection.getProperty(67).getLong();
            this.m_pLimits.m_maxIndexSize = iConnection.getProperty(77).getLong();
            this.m_pLimits.m_maxRowSize = iConnection.getProperty(79).getLong();
            this.m_pLimits.m_maxStatementLen = iConnection.getProperty(82).getLong();
            this.m_pLimits.m_maxCatalogNameLen = iConnection.getProperty(66).getInt();
            this.m_pLimits.m_maxColumnNameLen = iConnection.getProperty(68).getInt();
            this.m_pLimits.m_maxColumnsInGroupBy = iConnection.getProperty(69).getInt();
            this.m_pLimits.m_maxColumnsInIndex = iConnection.getProperty(70).getInt();
            this.m_pLimits.m_maxColumnsInOrderBy = iConnection.getProperty(71).getInt();
            this.m_pLimits.m_maxColumnsInSelect = iConnection.getProperty(72).getInt();
            this.m_pLimits.m_maxColumnsInTable = iConnection.getProperty(73).getInt();
            this.m_pLimits.m_maxCursorNameLen = iConnection.getProperty(75).getInt();
            this.m_pLimits.m_maxIdentifierLen = iConnection.getProperty(76).getInt();
            this.m_pLimits.m_maxProcedureNameLen = iConnection.getProperty(78).getInt();
            this.m_pLimits.m_maxSchemaNameLen = iConnection.getProperty(81).getInt();
            this.m_pLimits.m_maxTableNameLen = iConnection.getProperty(83).getInt();
            this.m_pLimits.m_maxTablesInSelect = iConnection.getProperty(84).getInt();
            this.m_pLimits.m_maxUsernameLen = iConnection.getProperty(85).getInt();
            return this;
        }
        catch (BadPropertyKeyException badPropertyKeyException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), badPropertyKeyException);
        }
        catch (ErrorException errorException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), errorException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    private boolean check(int n, long l) throws SQLEngineException {
        return 0L == l || (long)n <= l;
    }

    private SQLEngineException createException(String string, String[] stringArray) {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, string, stringArray);
    }

    private static class ParserLimits {
        HashSet<String> m_reservedKeywords = new HashSet();
        long m_maxBinaryLiteralLen;
        long m_maxCharLiteralLen;
        long m_maxIndexSize;
        long m_maxRowSize;
        long m_maxStatementLen;
        int m_maxCatalogNameLen;
        int m_maxColumnNameLen;
        int m_maxColumnsInGroupBy;
        int m_maxColumnsInIndex;
        int m_maxColumnsInOrderBy;
        int m_maxColumnsInSelect;
        int m_maxColumnsInTable;
        int m_maxCursorNameLen;
        int m_maxIdentifierLen;
        int m_maxProcedureNameLen;
        int m_maxSchemaNameLen;
        int m_maxTableNameLen;
        int m_maxTablesInSelect;
        int m_maxUsernameLen;

        private ParserLimits() {
        }
    }
}

