/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.conversions;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.support.conv.ConversionResult;
import com.cloudera.support.conv.ExactNumConverter;
import com.cloudera.support.exceptions.ErrorException;
import java.math.BigDecimal;

public class SqlExactNumberConverter
implements ISqlConverter {
    private final short m_tgtPrecision;
    private final short m_tgtScale;
    private final long m_targetColLen;

    public SqlExactNumberConverter(IColumn iColumn, IColumn iColumn2) {
        assert (iColumn.getTypeMetadata().isExactNumericType());
        this.m_tgtPrecision = iColumn2.getTypeMetadata().getPrecision();
        this.m_tgtScale = iColumn2.getTypeMetadata().getScale();
        this.m_targetColLen = iColumn2.getColumnLength();
    }

    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        BigDecimal bigDecimal = iSqlDataWrapper.getExactNumber();
        if (null == bigDecimal) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return conversionResult;
        }
        switch (iSqlDataWrapper2.getType()) {
            case 2: 
            case 3: {
                BigDecimal bigDecimal2 = ExactNumConverter.setPrecScale(bigDecimal, this.m_tgtPrecision, this.m_tgtScale, conversionResult);
                iSqlDataWrapper2.setExactNumber(bigDecimal2);
                break;
            }
            case 8: {
                double d = ExactNumConverter.toDouble(bigDecimal, conversionResult);
                iSqlDataWrapper2.setDouble(d);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = ExactNumConverter.toChar(iSqlDataWrapper.getExactNumber(), this.m_targetColLen, conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString((short)iSqlDataWrapper2.getType()));
            }
        }
        return conversionResult;
    }
}

