/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.jdbc.utils.DSTrustManager;
import com.cloudera.support.exceptions.ErrorException;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.thrift.transport.TSocket;

public class TETSSLTransportFactory {
    private static final String PROTOCOL_SSL = "SSL";

    public static TSocket getClientSocket(String string, int n, int n2, TETSSLTransportParameters tETSSLTransportParameters) throws ErrorException {
        if (null == tETSSLTransportParameters) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = TETSSLTransportFactory.createSSLContext(tETSSLTransportParameters, string);
        return TETSSLTransportFactory.createClient(sSLContext.getSocketFactory(), string, n, n2);
    }

    public static HttpClient getHttpClient(String string, int n, int n2, TETSSLTransportParameters tETSSLTransportParameters) throws ErrorException {
        if (null == tETSSLTransportParameters) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = TETSSLTransportFactory.createSSLContext(tETSSLTransportParameters, string);
        org.apache.http.conn.ssl.SSLSocketFactory sSLSocketFactory = tETSSLTransportParameters.certNamesMismatch || tETSSLTransportParameters.allowSelfSigned ? new org.apache.http.conn.ssl.SSLSocketFactory(sSLContext, org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER) : new org.apache.http.conn.ssl.SSLSocketFactory(sSLContext);
        return TETSSLTransportFactory.createHttpClient(sSLSocketFactory, string, n, n2);
    }

    private static String[] removeSSLProtocols(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input protocols = '");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(",");
            if (null == string || string.toUpperCase().contains(PROTOCOL_SSL)) continue;
            arrayList.add(string);
        }
        stringBuffer.append("', enabled protocols = '");
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append("'");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static SSLContext createSSLContext(TETSSLTransportParameters tETSSLTransportParameters, String string) throws ErrorException {
        SSLContext sSLContext;
        try {
            Object object;
            TrustManager[] trustManagerArray;
            sSLContext = SSLContext.getInstance(tETSSLTransportParameters.protocol);
            KeyManager[] keyManagerArray = null;
            if (tETSSLTransportParameters.isKeyStoreSet) {
                trustManagerArray = KeyManagerFactory.getInstance(tETSSLTransportParameters.keyManagerType);
                object = KeyStore.getInstance(tETSSLTransportParameters.keyStoreType);
                char[] cArray = null;
                if (null != tETSSLTransportParameters.keyPass) {
                    cArray = tETSSLTransportParameters.keyPass.toCharArray();
                }
                ((KeyStore)object).load(new FileInputStream(tETSSLTransportParameters.keyStore), cArray);
                trustManagerArray.init((KeyStore)object, cArray);
                keyManagerArray = trustManagerArray.getKeyManagers();
            }
            trustManagerArray = new TrustManager[]{new DSTrustManager(tETSSLTransportParameters, string)};
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            object = sSLContext.createSSLEngine();
            ((SSLEngine)object).setEnabledProtocols(TETSSLTransportFactory.removeSSLProtocols(((SSLEngine)object).getEnabledProtocols()));
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return sSLContext;
    }

    private static TSocket createClient(SSLSocketFactory sSLSocketFactory, String string, int n, int n2) throws ErrorException {
        try {
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            sSLSocket.setSoTimeout(n2);
            sSLSocket.setEnabledProtocols(TETSSLTransportFactory.removeSSLProtocols(sSLSocket.getEnabledProtocols()));
            TSocket tSocket = new TSocket((Socket)sSLSocket);
            tSocket.setTimeout(n2);
            return tSocket;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_THRIFT_COULD_NOT_CONNECT.name(), new String[]{string, String.valueOf(n)});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private static HttpClient createHttpClient(org.apache.http.conn.ssl.SSLSocketFactory sSLSocketFactory, String string, int n, int n2) throws ErrorException {
        try {
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
            defaultHttpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)sSLSocketFactory));
            return defaultHttpClient;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_THRIFT_COULD_NOT_CONNECT.name(), new String[]{string, String.valueOf(n)}, (Throwable)exception);
            throw errorException;
        }
    }

    public static class TETSSLTransportParameters {
        protected String protocol = "TLS";
        protected String keyStore;
        protected String keyPass;
        protected String keyManagerType = KeyManagerFactory.getDefaultAlgorithm();
        protected String keyStoreType = "JKS";
        private String trustStore;
        private String trustPass;
        private String trustManagerType = TrustManagerFactory.getDefaultAlgorithm();
        private String trustStoreType = "JKS";
        protected String[] cipherSuites;
        protected boolean clientAuth = false;
        protected boolean isKeyStoreSet = false;
        private boolean isTrustStoreSet = false;
        private boolean allowSelfSigned = false;
        private boolean certNamesMismatch = false;
        protected boolean hostNameInSAN = true;

        public TETSSLTransportParameters() {
        }

        public TETSSLTransportParameters(String string, String[] stringArray) {
            this(string, stringArray, false);
        }

        public TETSSLTransportParameters(String string, String[] stringArray, boolean bl) {
            if (string != null) {
                this.protocol = string;
            }
            this.cipherSuites = stringArray;
            this.clientAuth = bl;
        }

        public void setKeyStore(String string, String string2, String string3, String string4) {
            this.keyStore = string;
            this.keyPass = string2;
            if (string3 != null) {
                this.keyManagerType = string3;
            }
            if (string4 != null) {
                this.keyStoreType = string4;
            }
            this.isKeyStoreSet = true;
        }

        public void setKeyStore(String string, String string2) {
            this.setKeyStore(string, string2, null, null);
        }

        public void setTrustStore(String string, String string2, String string3, String string4) {
            this.trustStore = string;
            this.trustPass = string2;
            if (string3 != null) {
                this.trustManagerType = string3;
            }
            if (string4 != null) {
                this.trustStoreType = string4;
            }
            this.isTrustStoreSet = true;
        }

        public void setTrustStore(String string, String string2) {
            this.setTrustStore(string, string2, null, null);
        }

        public void requireClientAuth(boolean bl) {
            this.clientAuth = bl;
        }

        public void allowSelfSigned(boolean bl) {
            this.allowSelfSigned = bl;
        }

        public void certNamesMismatch(boolean bl) {
            this.certNamesMismatch = bl;
        }

        public void hostNameInSAN(boolean bl) {
            this.hostNameInSAN = bl;
        }

        public boolean isAllowSelfSigned() {
            return this.allowSelfSigned;
        }

        public boolean isCertNamesMismatch() {
            return this.certNamesMismatch;
        }

        public boolean isHostNameInSAN() {
            return this.hostNameInSAN;
        }

        public String getTrustManagerType() {
            return this.trustManagerType;
        }

        public String getTrustPass() {
            return this.trustPass;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public boolean isTrustStoreSet() {
            return this.isTrustStoreSet;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }
    }
}

