/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.gss;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ietf.jgss.GSSCredential;
import org.postgresql.core.PGStream;
import org.postgresql.gss.GSSCallbackHandler;
import org.postgresql.gss.GssAction;
import org.postgresql.gss.GssEncAction;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class MakeGSS {
    private static final Logger LOGGER = Logger.getLogger(MakeGSS.class.getName());

    public static void authenticate(boolean encrypted, PGStream pgStream, String host, String user, @Nullable String password, @Nullable String jaasApplicationName, @Nullable String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail) throws IOException, PSQLException {
        Exception result;
        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS");
        if (jaasApplicationName == null) {
            jaasApplicationName = "pgjdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            PrivilegedAction<Exception> action;
            Set<GSSCredential> gssCreds;
            boolean performAuthentication = jaasLogin;
            GSSCredential gssCredential = null;
            Subject sub = Subject.getSubject(AccessController.getContext());
            if (sub != null && (gssCreds = sub.getPrivateCredentials(GSSCredential.class)) != null && !gssCreds.isEmpty()) {
                gssCredential = gssCreds.iterator().next();
                performAuthentication = false;
            }
            if (performAuthentication) {
                LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
                lc.login();
                sub = lc.getSubject();
            }
            if (encrypted) {
                action = new GssEncAction(pgStream, gssCredential, host, user, kerberosServerName, useSpnego, logServerErrorDetail);
                result = Subject.doAs(sub, action);
            } else {
                action = new GssAction(pgStream, gssCredential, host, user, kerberosServerName, useSpnego, logServerErrorDetail);
                result = Subject.doAs(sub, action);
            }
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof PSQLException) {
            throw (PSQLException)result;
        }
        if (result != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

