/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.a.a.i;
import dm.jdbc.a.a.o;
import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DMException;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.fldr.FldrTask;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.plugin.fldr.ColumnData;
import dm.jdbc.plugin.fldr.ColumnInfo;
import dm.jdbc.plugin.fldr.Fldr;
import dm.jdbc.plugin.fldr.FldrBuffer;
import dm.jdbc.plugin.fldr.FldrClusterInfo;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrUtil;
import dm.jdbc.plugin.fldr.LobData;
import dm.jdbc.plugin.fldr.SetEnvInfo;
import dm.jdbc.plugin.fldr.TableInfo;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.buffer.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class FldrStatement
extends DmdbPreparedStatement {
    private String schemaName;
    private String tableName;
    private boolean firstFlag = true;
    private byte lockFlag = 0;
    private static final String SQL_SAMPLE = "SELECT 1 FROM DUAL";
    private TableInfo tableInfo;
    private Fldr primaryFldr;
    private boolean clusterFlag = false;
    private SetEnvInfo setEnvInfo;
    private int rows;
    private Map<Short, String> setIdMap = new HashMap<Short, String>();
    private FldrClusterInfo clusterInfo;
    private ExecutorService clusterExecutor = Executors.newFixedThreadPool(5);
    private ExecutorService bindExecutor = Executors.newFixedThreadPool(5);
    private ConcurrentHashMap<Integer, Fldr> fldrsMap;
    private List<DmdbConnection> connections;
    private HashSet<Fldr> usedFldr = new HashSet();
    private ConcurrentHashMap<Integer, Map<Short, String>> lastBpIdTabName = new ConcurrentHashMap();
    public Map<Integer, int[]> columnIdScale = new HashMap<Integer, int[]>();
    private static final String DECIMAL_PRECISION_SCALE_SQL = "/*DMJDBC*/ SELECT * FROM %s.%s LIMIT 1";
    private static final String INVALID_PARAM_FORMAT = "the %s column %s row data cannot match to Type {%s}";
    private static final String CAST_ERROR_FORMAT = "could not cast to target type, targetSqlType: %s, serverSqlType: %s";
    private static final String EXCEED_MAX_ROWS_FORMAT = "Binding parameter exceeds maxRows: {maxRows: %s, currentRow: %s, data: %s}";
    private final String TIMESTAMP_FORMAT = "%s-%s-%s %s:%s:%s.%s";
    private boolean insertFlag = false;
    private boolean usedAsyncPrep = false;
    private boolean usedAsyncInsert = false;
    private boolean stopFlag = false;
    private int realSeqNo = 1;
    public volatile Exception asyncErr;
    private Map<Integer, FldrBuffer> batchMap = new HashMap<Integer, FldrBuffer>();
    private volatile boolean asyncStopFlag = false;
    private LinkedBlockingQueue<FldrBuffer> batchQueue = new LinkedBlockingQueue(60);
    private int maxSeqNo = Integer.MIN_VALUE;
    public static int maxError = 1;
    private int committedRows = 0;

    public int getCommittedRows() {
        return this.committedRows;
    }

    protected FldrStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    protected FldrStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, String sql, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        super(connection, sql, autoGeneratedKeys, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, FldrConfig config) throws SQLException {
        super(connection, SQL_SAMPLE, 0, false);
        this.setFldrTableInfo(config.schemaName, config.tableName);
        this.setFldrProperties(config);
    }

    public FldrStatement(DmdbConnection connection, Map<String, String> configMap) throws SQLException {
        super(connection, SQL_SAMPLE, 0, false);
        this.setFldrTableInfo(configMap.get("schemaName"), configMap.get("tableName"));
        this.setFldrProperties(configMap);
    }

    public FldrStatement(DmdbConnection connection, String sql, int[] columnIndexes, boolean fromPool) throws SQLException {
        super(connection, sql, columnIndexes, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, String sql, String[] columnNames, boolean fromPool) throws SQLException {
        super(connection, sql, columnNames, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public DmdbResultSet do_executeQuery() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return -1;
    }

    public void setBindExecutor(int bindThreadNum) throws SQLException {
        if (bindThreadNum <= 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.bindExecutor = Executors.newFixedThreadPool(bindThreadNum);
        this.clusterExecutor = Executors.newFixedThreadPool(bindThreadNum);
    }

    @Override
    public void do_setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.do_setObject(parameterIndex, null);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    private void shutdownExecutor() {
        while (!this.clusterExecutor.isShutdown()) {
            this.clusterExecutor.shutdownNow();
        }
        while (!this.bindExecutor.isShutdown()) {
            this.bindExecutor.shutdownNow();
        }
    }

    public void setBatchQueue(LinkedBlockingQueue<FldrBuffer> batchQueue) {
        this.batchQueue = batchQueue;
    }

    @Override
    public void do_setBoolean(int parameterIndex, boolean x2) throws SQLException {
        try {
            int result = x2 ? 1 : 0;
            this.do_setObject(parameterIndex, result);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setByte(int parameterIndex, byte x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 5) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setShort(int parameterIndex, short x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 6 && columnInfo.getColumnType() != 5) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setInt(int parameterIndex, int x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 7) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setINTERVALDT(int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 21) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setINTERVALYM(int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 20) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setLong(int parameterIndex, long x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 8) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setFloat(int parameterIndex, float x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 10) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = Float.valueOf(x2);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setDouble(int parameterIndex, double x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 11) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        try {
            int[] ints;
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 9) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            if ((ints = this.columnIdScale.get(parameterIndex - 1)) == null) {
                DBError.ECJDBC_INVALID_SCALE.throwz("Server could not provide valid precision and scale");
            }
            this.curRowDatas[parameterIndex - 1] = FldrStatement.roundHalfUp(x2, ints[0], ints[1]);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    public static BigDecimal roundHalfUp(BigDecimal dec, int prec, int scale) {
        if (dec == null) {
            return null;
        }
        if (dec.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if (scale == 0 && prec == 0 && (dec.precision() == 0 || dec.scale() != 0)) {
            if (dec.precision() + dec.scale() < 38) {
                return dec;
            }
            int precision = dec.precision() - dec.scale();
            precision = precision % 2 == 0 ? precision : precision + 1;
            scale = 38 - precision > 0 ? 38 - precision : scale;
            dec = dec.setScale(scale, RoundingMode.HALF_UP);
        }
        if (scale > 0 && dec.scale() > scale) {
            dec = dec.setScale(scale, RoundingMode.HALF_UP);
        }
        return dec;
    }

    @Override
    public void do_setString(int parameterIndex, String x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() == 2 || columnInfo.getColumnType() == 1 || columnInfo.getColumnType() == 0) {
                this.curRowDatas[parameterIndex - 1] = x2;
            } else if (columnInfo.getColumnType() == 6 || columnInfo.getColumnType() == 5) {
                this.curRowDatas[parameterIndex - 1] = Short.parseShort(x2);
            } else if (columnInfo.getColumnType() == 11) {
                this.curRowDatas[parameterIndex - 1] = Double.parseDouble(x2);
            } else if (columnInfo.getColumnType() == 10) {
                this.curRowDatas[parameterIndex - 1] = Float.valueOf(Float.parseFloat(x2));
            } else if (columnInfo.getColumnType() == 9) {
                this.curRowDatas[parameterIndex - 1] = new BigDecimal(x2);
            } else if (columnInfo.getColumnType() == 14 || columnInfo.getColumnType() == 15 || columnInfo.getColumnType() == 22 || columnInfo.getColumnType() == 16 || columnInfo.getColumnType() == 26 || columnInfo.getColumnType() == 23 || columnInfo.getColumnType() == 27) {
                this.curRowDatas[parameterIndex - 1] = DmdbTimestamp.valueOf(x2);
            } else if (columnInfo.getColumnType() == 19) {
                this.curRowDatas[parameterIndex - 1] = DmdbClob.newInstance(x2, this.connection);
            } else if (columnInfo.getColumnType() == 12) {
                this.curRowDatas[parameterIndex - 1] = DmdbBlob.newInstanceOfLocal(x2.getBytes(), this.connection);
            } else if (columnInfo.getColumnType() == 20) {
                this.curRowDatas[parameterIndex - 1] = new DmdbIntervalYM(x2);
            } else if (columnInfo.getColumnType() == 21) {
                this.curRowDatas[parameterIndex - 1] = new DmdbIntervalDT(x2);
            } else {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
        }
        catch (Exception exception) {
            this.shutdownExecutor();
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    @Override
    public void do_setBytes(int parameterIndex, byte[] x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 18 && columnInfo.getColumnType() != 17) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    private <T extends java.util.Date> void setFldrDate(int parameterIndex, T x2) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setDate(int parameterIndex, Date x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTime(int parameterIndex, Time x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTIMESTAMP(int parameterIndex, DmdbTimestamp x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setAsciiStream(parameterIndex, x2, (long)length);
    }

    @Override
    public void do_setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            boolean notNull = this.beforeStreamProcess(parameterIndex, x2, length < 0, columnInfo.getColumnType());
            if (notNull) {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromUnicodeStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setBinaryStream(parameterIndex, x2, (long)length);
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        ColumnInfo columnInfo;
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != targetSqlType) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(CAST_ERROR_FORMAT, targetSqlType, columnInfo.getColumnType());
        }
        this.do_setObject(parameterIndex, x2);
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        if (x2 instanceof InputStream) {
            this.do_setBinaryStream(parameterIndex, (InputStream)x2);
        } else if (x2 instanceof Reader) {
            this.do_setCharacterStream(parameterIndex, (Reader)x2);
        } else if (x2 instanceof String) {
            this.do_setString(parameterIndex, (String)x2);
        } else if (9 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType()) {
            this.ObjectToDecimal(parameterIndex, x2);
        } else if (12 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType()) {
            this.ObjectToBlob(parameterIndex, x2);
        } else {
            this.curRowDatas[parameterIndex - 1] = 19 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType() ? DmdbClob.newInstance(String.valueOf(x2), this.connection) : (20 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType() ? new DmdbIntervalYM(String.valueOf(x2)) : (21 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType() ? new DmdbIntervalDT(String.valueOf(x2)) : x2));
        }
    }

    public void setBatchData(Object[][] dataArr, int seqNo) throws SQLException {
        if (this.asyncErr != null) {
            this.shutdownExecutor();
            throw new SQLException(this.asyncErr.getMessage());
        }
        if ((dataArr == null || dataArr.length == 0) && seqNo != -1) {
            this.stopFlag = true;
            this.do_close();
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.usedAsyncPrep = true;
        Calendar cal = Calendar.getInstance();
        if (seqNo == -1) {
            this.asyncColumnDataList(dataArr, seqNo, cal);
            return;
        }
        int times = dataArr.length / this.rows + (dataArr.length % this.rows > 0 ? 1 : 0);
        if (times == 1) {
            this.setMaxSeqNo();
            this.asyncColumnDataList(dataArr, this.realSeqNo++, cal);
            return;
        }
        int i2 = 0;
        while (i2 < times) {
            Object[][] data = null;
            if (i2 == times - 1) {
                data = new Object[dataArr.length - i2 * this.rows][dataArr[0].length];
                System.arraycopy(dataArr, i2 * this.rows, data, 0, data.length);
            } else {
                data = new Object[this.rows][dataArr[0].length];
                System.arraycopy(dataArr, i2 * this.rows, data, 0, this.rows);
            }
            this.setMaxSeqNo();
            this.asyncColumnDataList(data, this.realSeqNo++, cal);
            ++i2;
        }
    }

    private void setMaxSeqNo() {
        this.maxSeqNo = this.realSeqNo;
    }

    private void ObjectToBlob(int parameterIndex, Object x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 12);
            return;
        }
        if (x2 instanceof byte[]) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal((byte[])x2, this.connection));
        } else if (x2 instanceof String) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromString((String)x2, this.connection.getServerEncoding()), this.connection));
        } else if (x2 instanceof Integer) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromInt((Integer)x2), this.connection));
        } else if (x2 instanceof Long) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromLong((Long)x2), this.connection));
        } else if (x2 instanceof Short) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromShort((Short)x2), this.connection));
        } else if (x2 instanceof Float) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromFloat(((Float)x2).floatValue()), this.connection));
        } else if (x2 instanceof Double) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromDouble((Double)x2), this.connection));
        } else if (x2 instanceof BigDecimal) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(((BigDecimal)x2).toPlainString().getBytes(this.connection.getServerEncoding()), this.connection));
        } else if (x2 instanceof Blob) {
            this.do_setBlob(parameterIndex, (Blob)x2);
        } else if (x2 instanceof Clob) {
            Clob clob = (Clob)x2;
            String str = clob.getSubString(0L, (int)clob.length());
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(str.getBytes(), this.connection));
        } else {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(String.valueOf(x2).getBytes(this.connection.getServerEncoding()), this.connection));
        }
    }

    private void ObjectToDecimal(int parameterIndex, Object x2) throws SQLException {
        if (x2 instanceof BigDecimal) {
            this.do_setBigDecimal(parameterIndex, (BigDecimal)x2);
        } else if (x2 instanceof Byte) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Byte)x2).byteValue()));
        } else if (x2 instanceof Short) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Short)x2).shortValue()));
        } else if (x2 instanceof Integer) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Integer)x2).intValue()));
        } else if (x2 instanceof Long) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf((Long)x2));
        } else if (x2 instanceof Double) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf((Double)x2));
        } else if (x2 instanceof Float) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Float)x2).floatValue()));
        } else {
            this.do_setBigDecimal(parameterIndex, x2 == null ? null : new BigDecimal(x2.toString()));
        }
    }

    @Override
    public boolean do_execute() throws SQLException {
        this.do_addBatch();
        int[] ints = this.do_executeBatch();
        return ints != null && ints.length > 0;
    }

    @Override
    public void do_addBatch() throws SQLException {
        this.multiRowDatas.add(this.curRowDatas);
        ++this.irow;
        if (this.irow > this.rows) {
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = this.curRowDatas;
            int n2 = this.curRowDatas.length;
            int n3 = 0;
            while (n3 < n2) {
                Object data = objectArray[n3];
                sb.append(data).append(";");
                ++n3;
            }
            this.shutdownExecutor();
            DBError.ECJDBC_UNBINDED_PARAMETER.throwz(String.format(EXCEED_MAX_ROWS_FORMAT, this.rows, this.irow, sb));
        }
        Object[] tmp = new Object[this.paramCount];
        System.arraycopy(this.curRowDatas, 0, tmp, 0, tmp.length);
        this.curRowDatas = tmp;
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void do_setRef(int parameterIndex, Ref x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_setBlob(int parameterIndex, Blob blob) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = blob;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setClob(int parameterIndex, Clob clob) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = clob;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setArray(int parameterIndex, Array x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public DmdbResultSetMetaData do_getMetaData() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void do_setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        this.setFldrDate(parameterIndex, cal.getTime());
    }

    @Override
    public void do_setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        this.setFldrDate(parameterIndex, cal.getTime());
    }

    @Override
    public void do_setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        String format = String.format("%s-%s-%s %s:%s:%s.%s", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), x2.getNanos() / 1000);
        Timestamp timestamp = Timestamp.valueOf(format);
        this.setFldrDate(parameterIndex, timestamp);
    }

    @Override
    public void do_setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.do_setNull(parameterIndex, sqlType);
    }

    @Override
    public void do_setURL(int parameterIndex, URL x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 12);
            return;
        }
        this.do_setString(parameterIndex, x2.toString());
    }

    @Override
    public DmdbParameterMetaData do_getParameterMetaData() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void do_setRowId(int parameterIndex, RowId x2) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            if (x2 == null) {
                this.do_setNull(parameterIndex, -8);
            }
            if (8 == columnInfo.getColumnType()) {
                this.do_setLong(parameterIndex, Long.parseLong(x2.toString()));
            } else if (28 == columnInfo.getColumnType()) {
                this.curRowDatas[parameterIndex - 1] = x2;
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setNString(int parameterIndex, String value) throws SQLException {
        this.do_setString(parameterIndex, value);
    }

    @Override
    public void do_setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void do_setNClob(int parameterIndex, NClob value) throws SQLException {
        this.do_setClob(parameterIndex, value);
    }

    @Override
    public void do_setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void do_setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void do_setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setClob(parameterIndex, reader, length);
    }

    @Override
    public void do_setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            this.do_setNull(parameterIndex, 2009);
        } else {
            this.do_setCharacterStream(parameterIndex, ((DmdbSQLXML)xmlObject).serializeAsCharacterStream());
        }
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        this.do_setObject(parameterIndex, x2, targetSqlType);
    }

    private boolean beforeStreamProcess(int parameterIndex, Object x2, boolean vaildFlag, int colType) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if (vaildFlag) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length could not less than 0");
            }
            if (x2 == null) {
                this.do_setNull(parameterIndex, colType);
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
            return false;
        }
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        ColumnInfo columnInfo;
        boolean notNull;
        try {
            int available = x2.available();
            if (length > (long)available) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length exceeds the max length");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.shutdownExecutor();
        }
        if (notNull = this.beforeStreamProcess(parameterIndex, x2, length < -1L, (columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType())) {
            try {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromAsciiStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
            catch (Exception e3) {
                this.shutdownExecutor();
                DBError.ECJDBC_COMMUNITION_ERROR.throwz(e3);
            }
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        ColumnInfo columnInfo;
        boolean notNull;
        try {
            int available = x2.available();
            if (length > (long)available) {
                this.shutdownExecutor();
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length exceeds the max length");
            }
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            e2.printStackTrace();
        }
        if (notNull = this.beforeStreamProcess(parameterIndex, x2, length < 0L, (columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType())) {
            try {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromBinaryStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
            catch (Exception e3) {
                this.shutdownExecutor();
                DBError.ECJDBC_COMMUNITION_ERROR.throwz(e3);
            }
        }
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            boolean notNull = this.beforeStreamProcess(parameterIndex, reader, length < -1L, columnInfo.getColumnType());
            if (notNull) {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromReader(reader, parameter, this.connection, length, parameterIndex - 1);
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        try {
            this.do_setAsciiStream(parameterIndex, x2, x2.available());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        try {
            this.do_setBinaryStream(parameterIndex, x2, x2.available());
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            e2.printStackTrace();
        }
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, -1L);
    }

    @Override
    public void do_setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value);
    }

    @Override
    public void do_setClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void do_setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void do_setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public DmdbResultSet do_executeQuery(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void do_close() throws SQLException {
        block29: {
            try {
                if (this.do_closeAsync()) {
                    while (!this.asyncStopFlag && this.asyncErr == null) {
                    }
                }
            }
            catch (Exception v0) {}
            try {
                try {
                    this.do_clearParameters();
                    if (this.serverParameters != null) {
                        var4_1 = this.serverParameters;
                        var3_2 = this.serverParameters.length;
                        var2_3 = 0;
                        while (var2_3 < var3_2) {
                            param = var4_1[var2_3];
                            MiscUtil.close(param);
                            ++var2_3;
                        }
                    }
                    if (this.bindParameters != null) {
                        var4_1 = this.bindParameters;
                        var3_2 = this.bindParameters.length;
                        var2_3 = 0;
                        while (var2_3 < var3_2) {
                            param = var4_1[var2_3];
                            MiscUtil.close(param);
                            ++var2_3;
                        }
                    }
                    while (!this.bindExecutor.isTerminated() || !this.bindExecutor.isShutdown()) {
                        this.bindExecutor.shutdownNow();
                    }
                    while (this.clusterExecutor != null && !this.clusterExecutor.isShutdown()) {
                        this.clusterExecutor.shutdownNow();
                    }
                    if (this.insertFlag) {
                        if (!this.clusterFlag) {
                            this.primaryFldr.clearEnvironment(1);
                        } else {
                            for (Fldr fldr : this.usedFldr) {
                                fldr.clearEnvironment(1);
                            }
                        }
                    }
                    if (this.asyncErr != null) {
                        throw this.asyncErr;
                    }
                    ** GOTO lbl75
                }
                catch (Exception e) {
                    if (e instanceof DMException) {
                        throw (DMException)e;
                    }
                    if (this.asyncErr != null) {
                        throw (SQLException)this.asyncErr;
                    }
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(new Object[]{e});
                    ** while (!this.clusterExecutor.isTerminated() || !this.clusterExecutor.isShutdown())
                }
            }
            catch (Throwable var5_13) {
                ** while (!this.clusterExecutor.isTerminated() || !this.clusterExecutor.isShutdown())
            }
lbl-1000:
            // 1 sources

            {
                this.clusterExecutor.shutdownNow();
                continue;
            }
lbl58:
            // 1 sources

            if (!this.clusterFlag) break block29;
            for (DmdbConnection connection : this.connections) {
                connection.do_close();
            }
            break block29;
lbl-1000:
            // 1 sources

            {
                this.clusterExecutor.shutdownNow();
                continue;
            }
lbl68:
            // 1 sources

            if (this.clusterFlag) {
                for (DmdbConnection connection : this.connections) {
                    connection.do_close();
                }
            }
            throw var5_13;
lbl-1000:
            // 1 sources

            {
                this.clusterExecutor.shutdownNow();
lbl75:
                // 2 sources

                ** while (!this.clusterExecutor.isTerminated() || !this.clusterExecutor.isShutdown())
            }
lbl76:
            // 1 sources

            if (this.clusterFlag) {
                for (DmdbConnection connection : this.connections) {
                    connection.do_close();
                }
            }
        }
    }

    @Override
    public int do_getMaxFieldSize() {
        return this.tableInfo.getColumnInfos().size();
    }

    @Override
    public void do_setMaxFieldSize(int max) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getMaxRows() {
        return this.setEnvInfo.getBldrNumber();
    }

    @Override
    public void do_setMaxRows(int max) throws SQLException {
        if (max > 0 && max <= 10000) {
            this.setEnvInfo.setBdtaSize(max);
        }
        DBError.EC_INVALID_DB_OBJECT.throwz(new Object[0]);
    }

    @Override
    public void do_setEscapeProcessing(boolean enable) {
    }

    @Override
    public void do_setQueryTimeout(int seconds) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_cancel() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_setCursorName(String name) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public boolean do_execute(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public DmdbResultSet do_getResultSet() {
        return null;
    }

    @Override
    public int do_getUpdateCount() {
        return -1;
    }

    @Override
    public boolean do_getMoreResults() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public void do_setFetchDirection(int direction) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getFetchDirection() {
        return 0;
    }

    @Override
    public void do_setFetchSize(int rows) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getFetchSize() {
        return -1;
    }

    @Override
    public int do_getResultSetConcurrency() {
        return -1;
    }

    @Override
    public int do_getResultSetType() {
        return -1;
    }

    @Override
    public void do_addBatch(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int[] do_executeBatch() throws SQLException {
        if (this.curRowDatas.length > 0 && this.multiRowDatas.size() == 0) {
            this.do_addBatch();
        }
        if (this.tableInfo.gethTableHead() == null) {
            this.tableInfo.hTableNameData.put(this.tableName, this.multiRowDatas);
        } else {
            int i2 = 0;
            while (i2 < this.multiRowDatas.size()) {
                try {
                    this.tableInfo.getHTabPartition((Object[])this.multiRowDatas.get(i2));
                }
                catch (Exception exception) {
                    this.shutdownExecutor();
                    DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("Partition mismatched: {currentRow: %s}", i2 + 1));
                }
                ++i2;
            }
        }
        if (this.clusterFlag) {
            this.clusterProcess();
        } else {
            this.noClusterProcess();
        }
        this.tableInfo.clearData();
        this.do_clearBatch();
        return null;
    }

    private void noClusterProcess() throws SQLException {
        for (Map.Entry<String, List<Object[]>> entry : this.tableInfo.hTableNameData.entrySet()) {
            this.insertFlag = true;
            String subTableName = entry.getKey();
            List<Object[]> rowData = entry.getValue();
            if (rowData == null || rowData.size() <= 0) continue;
            this.usedFldr.add(this.primaryFldr);
            short setId = this.primaryFldr.getSetId(String.valueOf(this.schemaName) + ":" + subTableName, this.setEnvInfo.getBldrNumber());
            this.setFldrEnv(this.primaryFldr, subTableName, setId);
            List<ColumnData> columnData = this.getColumnDataList(rowData);
            this.primaryFldr.insert(columnData, this.tableInfo, rowData.size(), setId, this.bindExecutor);
        }
    }

    private void clusterProcess() throws SQLException {
        Map<Integer, List<Map.Entry<String, List<Object[]>>>> map = this.getBpInfo(this.tableInfo.hTableNameData);
        FldrStatement.doTaskOnEverySite(this.clusterExecutor, map.entrySet(), map.entrySet().size(), new Callback<Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>>>(){

            @Override
            void run(Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>> entry) throws SQLException {
                try {
                    Integer bpId = entry.getKey();
                    Fldr fldr = (Fldr)FldrStatement.this.fldrsMap.get(bpId);
                    Map tableMaps = (Map)FldrStatement.this.lastBpIdTabName.get(bpId);
                    List<Map.Entry<String, List<Object[]>>> entryList = entry.getValue();
                    FldrStatement.this.usedFldr.add(fldr);
                    SetEnvInfo localSetEnv = (SetEnvInfo)FldrStatement.this.setEnvInfo.clone();
                    for (Map.Entry<String, List<Object[]>> subEntry : entryList) {
                        String subTableName = subEntry.getKey();
                        List<Object[]> rowData = subEntry.getValue();
                        short setId = fldr.getSetId(bpId + ":" + FldrStatement.this.schemaName + ":" + subTableName, FldrStatement.this.setEnvInfo.getBldrNumber());
                        String containedTab = (String)tableMaps.get(setId);
                        if (!subTableName.equals(containedTab)) {
                            localSetEnv.setSetId(setId);
                            localSetEnv.setTableName(subTableName);
                            String result = fldr.setEnvironment(localSetEnv);
                            if (!result.equals("SUCCESS")) {
                                FldrStatement.this.shutdownExecutor();
                                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("set Fldr Environment %s : %s", subTableName, result));
                            }
                            tableMaps.put(setId, subTableName);
                            FldrStatement.this.lastBpIdTabName.put(bpId, tableMaps);
                        }
                        List columnData = FldrStatement.this.getColumnDataList(rowData);
                        fldr.insert(columnData, FldrStatement.this.tableInfo, rowData.size(), setId, FldrStatement.this.bindExecutor);
                    }
                }
                catch (Exception e2) {
                    FldrStatement.this.shutdownExecutor();
                    e2.printStackTrace();
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
                }
            }
        });
    }

    private synchronized void clusterAsyncProcess(Map<Integer, List<Object[]>> map) throws SQLException {
        FldrStatement.doTaskOnEverySite(this.bindExecutor, map.entrySet(), map.entrySet().size(), new Callback<Map.Entry<Integer, List<Object[]>>>(){

            @Override
            void run(Map.Entry<Integer, List<Object[]>> entry) throws SQLException {
                try {
                    Integer bpId = entry.getKey();
                    Fldr fldr = (Fldr)FldrStatement.this.fldrsMap.get(bpId);
                    Map tableMaps = (Map)FldrStatement.this.lastBpIdTabName.get(bpId);
                    List<Object[]> list = entry.getValue();
                    FldrStatement.this.usedFldr.add(fldr);
                    FldrStatement.this.insertFlag = true;
                    SetEnvInfo localSetEnv = (SetEnvInfo)FldrStatement.this.setEnvInfo.clone();
                    for (Object[] objects : list) {
                        String subTableName = (String)objects[0];
                        Buffer buffer = (Buffer)objects[1];
                        List lobList = (List)objects[2];
                        short setId = fldr.getSetId(bpId + ":" + FldrStatement.this.schemaName + ":" + subTableName, FldrStatement.this.setEnvInfo.getBldrNumber());
                        String containedTab = (String)tableMaps.get(setId);
                        if (!subTableName.equals(containedTab)) {
                            localSetEnv.setSetId(setId);
                            localSetEnv.setTableName(subTableName);
                            String result = fldr.setEnvironment(localSetEnv);
                            if (!result.equals("SUCCESS")) {
                                FldrStatement.this.shutdownExecutor();
                                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("set Fldr Environment %s : %s", subTableName, result));
                            }
                            tableMaps.put(setId, subTableName);
                            FldrStatement.this.lastBpIdTabName.put(bpId, tableMaps);
                        }
                        buffer.setInt(20, setId);
                        fldr.insertBatch(buffer);
                        fldr.insertLob(setId, lobList);
                    }
                }
                catch (Exception e2) {
                    FldrStatement.this.shutdownExecutor();
                    e2.printStackTrace();
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
                }
            }
        });
    }

    private Map<Integer, List<Map.Entry<String, List<Object[]>>>> getBpInfo(Map<String, List<Object[]>> hTabData) throws SQLException {
        HashMap<Integer, List<Map.Entry<String, List<Object[]>>>> map = new HashMap<Integer, List<Map.Entry<String, List<Object[]>>>>();
        try {
            for (Map.Entry<String, List<Object[]>> entry : hTabData.entrySet()) {
                int bpId;
                this.insertFlag = true;
                if (this.tableInfo.subTableNameIdMap != null) {
                    int tableId = this.tableInfo.subTableNameIdMap.get(entry.getKey());
                    bpId = this.clusterInfo.tabIdToBpIdMap.get(tableId);
                } else {
                    bpId = this.clusterInfo.tabIdToBpIdMap.values().iterator().next();
                }
                List<Map.Entry<String, List<Object[]>>> list = map.get(bpId);
                if (list == null) {
                    list = new ArrayList<Map.Entry<String, List<Object[]>>>();
                }
                list.add(entry);
                map.put(bpId, list);
                if (this.lastBpIdTabName.get(bpId) != null) continue;
                this.lastBpIdTabName.put(bpId, new HashMap());
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
        return map;
    }

    private List<ColumnData> getColumnDataList(List<Object[]> rowDataList) throws SQLException {
        if (rowDataList == null || rowDataList.size() == 0) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz(new Object[0]);
        }
        final List<ColumnData> columnDataList = this.createColumn(rowDataList.get(0).length, rowDataList.size());
        FldrStatement.doTaskOnEverySite(this.bindExecutor, rowDataList, columnDataList.size(), new Callback2<List<Object[]>>(){

            @Override
            void run(List<Object[]> list, int colIndex) throws SQLException {
                ColumnData columnData = (ColumnData)columnDataList.get(colIndex);
                int rowIndex = 0;
                while (rowIndex < list.size()) {
                    Object o2 = list.get(rowIndex)[colIndex];
                    FldrStatement.this.autoIncreaseProcess(colIndex, columnData, rowIndex, o2);
                    ++rowIndex;
                }
            }
        });
        return columnDataList;
    }

    private void asyncColumnDataList(final Object[][] arr, final int seqNo, Calendar calendar) {
        final FldrStatement statement = this;
        final Calendar cal = calendar;
        FldrTask task = new FldrTask(this){

            @Override
            protected void doTask() throws SQLException {
                Callback<Object[][]> callback = new Callback<Object[][]>(){

                    @Override
                    void run(Object[][] siteObject) throws SQLException {
                        Map<String, List<Object[]>> hTabMap = null;
                        if (seqNo != -1) {
                            hTabMap = FldrStatement.this.tableInfo.getAsyncHTabPartition(arr, (this).FldrStatement.this.columnIdScale, cal);
                        }
                        FldrBuffer fldrBuffer = null;
                        if (FldrStatement.this.clusterFlag) {
                            if (seqNo == -1) {
                                fldrBuffer = FldrStatement.this.createFldrBuffer(seqNo, arr, cal);
                            } else {
                                Map bpInfo = statement.getBpInfo(hTabMap);
                                fldrBuffer = FldrStatement.this.createFldrBuffer(seqNo, bpInfo, cal);
                            }
                        } else if (hTabMap == null || hTabMap.size() == 0) {
                            fldrBuffer = FldrStatement.this.createFldrBuffer(seqNo, arr, cal);
                        } else {
                            for (Map.Entry<String, List<Object[]>> entry : hTabMap.entrySet()) {
                                String subTableName = entry.getKey();
                                List<Object[]> dataList = entry.getValue();
                                fldrBuffer = FldrStatement.this.createFldrBuffer(fldrBuffer, seqNo, subTableName, dataList, cal);
                            }
                        }
                        try {
                            FldrStatement.this.batchQueue.put(fldrBuffer);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                };
                callback.run(arr);
            }
        };
        this.bindExecutor.execute(task);
    }

    private FldrBuffer createFldrBuffer(int seqNo, Map<Integer, List<Map.Entry<String, List<Object[]>>>> bpInfo, Calendar cal) throws SQLException {
        if (seqNo == -1) {
            return new FldrBuffer(seqNo, null, null);
        }
        FldrBuffer fldrBuffer = new FldrBuffer();
        fldrBuffer.setSeqNo(seqNo);
        fldrBuffer.sethTabFlag(this.tableInfo.dpcFlag);
        for (Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>> entry : bpInfo.entrySet()) {
            Integer bpId = entry.getKey();
            List<Map.Entry<String, List<Object[]>>> subTabData = entry.getValue();
            for (Map.Entry<String, List<Object[]>> tabData : subTabData) {
                String subTabName = tabData.getKey();
                List<Object[]> dataList = tabData.getValue();
                Object[] objects = this.FBHelper(subTabName, dataList, cal);
                fldrBuffer.setBpData(bpId, objects);
            }
        }
        return fldrBuffer;
    }

    private FldrBuffer createFldrBuffer(FldrBuffer fldrBuffer, int seqNo, String subTableName, List<Object[]> dataList, Calendar cal) throws SQLException {
        Object[] objects = new Object[2];
        if (seqNo != -1) {
            objects = this.FBHelper(subTableName, dataList, cal);
        }
        return fldrBuffer == null ? new FldrBuffer(seqNo, subTableName, (Buffer)objects[0], (List)objects[1]) : fldrBuffer.setTabDetail(subTableName, objects);
    }

    private Object[] FBHelper(String tableName, List<Object[]> dataList, Calendar cal) throws SQLException {
        Object[] objectArray;
        List<ColumnData> columnDataList = this.createColumn(dataList.get(0).length, dataList.size());
        int columnIndex = 0;
        while (columnIndex < dataList.get(0).length) {
            ColumnData columnData = columnDataList.get(columnIndex);
            int rowIndex = 0;
            while (rowIndex < dataList.size()) {
                Object o2 = dataList.get(rowIndex)[columnIndex];
                this.autoIncreaseProcess(columnIndex, columnData, rowIndex, o2);
                ++rowIndex;
            }
            ++columnIndex;
        }
        Buffer buffer = Buffer.allocate(32640, true, this.connection.bufferType);
        o.a(buffer, this, dataList.size(), (short)columnDataList.size(), columnDataList, this.tableInfo, this.bindExecutor, cal);
        List<LobData> lobData = i.b(columnDataList, this.tableInfo);
        if (this.tableInfo.dpcFlag) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = tableName;
            objectArray2[1] = buffer;
            objectArray = objectArray2;
            objectArray2[2] = lobData;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = buffer;
            objectArray = objectArray3;
            objectArray3[1] = lobData;
        }
        return objectArray;
    }

    private FldrBuffer createFldrBuffer(int seqNo, Object[][] arr, Calendar cal) throws SQLException {
        Buffer buffer = null;
        List<LobData> lobData = null;
        if (seqNo != -1) {
            List<ColumnData> columnDataList = this.createColumn(arr[0].length, arr.length);
            int columnIndex = 0;
            while (columnIndex < arr[0].length) {
                ColumnData columnData = columnDataList.get(columnIndex);
                int rowIndex = 0;
                while (rowIndex < arr.length) {
                    Object o2 = arr[rowIndex][columnIndex];
                    this.autoIncreaseProcess(columnIndex, columnData, rowIndex, o2);
                    ++rowIndex;
                }
                ++columnIndex;
            }
            buffer = Buffer.allocate(32640, true, this.connection.bufferType);
            o.a(buffer, this, arr.length, (short)columnDataList.size(), columnDataList, this.tableInfo, this.bindExecutor, cal);
            lobData = i.b(columnDataList, this.tableInfo);
        }
        return new FldrBuffer(seqNo, buffer, lobData);
    }

    private boolean autoIncreaseProcess(int columnIndex, ColumnData columnData, int rowIndex, Object o2) throws SQLException {
        if (columnIndex == this.tableInfo.autoIncrementColId) {
            this.processAutoIncrementColumn(rowIndex, columnData, o2);
            return true;
        }
        if (o2 == null) {
            if (columnData.getSqlType() == 12 || columnData.getSqlType() == 19) {
                columnData.getData().add(null);
            }
            columnData.setIsAllNotNull(0);
            return true;
        }
        columnData.getData().add(o2);
        columnData.getNullArr()[rowIndex] = 1;
        return false;
    }

    public void asyncExecuteBatch() {
        if (this.usedAsyncInsert) {
            return;
        }
        final FldrStatement stmt = this;
        this.usedAsyncInsert = true;
        FldrTask task2 = new FldrTask(this){

            @Override
            protected void doTask() throws SQLException {
                int count = 1;
                while (true) {
                    FldrBuffer fldrBuffer;
                    block12: {
                        block11: {
                            block10: {
                                if ((fldrBuffer = (FldrBuffer)FldrStatement.this.batchMap.get(count)) != null) break block10;
                                if (FldrStatement.this.batchQueue.size() == 0 && FldrStatement.this.stopFlag && FldrStatement.this.maxSeqNo < count || FldrStatement.this.asyncErr != null) {
                                    FldrStatement.this.asyncStopFlag = true;
                                    this.setError((SQLException)FldrStatement.this.asyncErr);
                                    return;
                                }
                                fldrBuffer = (FldrBuffer)FldrStatement.this.batchQueue.poll();
                                if (fldrBuffer == null) break block11;
                                if (fldrBuffer.getSeqNo() == count) break block12;
                                if (fldrBuffer.getSeqNo() == -1) {
                                    FldrStatement.this.stopFlag = true;
                                }
                                FldrStatement.this.batchMap.put(fldrBuffer.getSeqNo(), fldrBuffer);
                                break block11;
                            }
                            FldrStatement.this.batchMap.remove(count);
                            break block12;
                        }
                        if (fldrBuffer == null || fldrBuffer.getSeqNo() != count) continue;
                    }
                    if (fldrBuffer.gethTabFlag()) {
                        if (((FldrStatement)FldrStatement.this).tableInfo.dpcFlag) {
                            HashMap<Integer, List<Object[]>> bpData = fldrBuffer.getBpData();
                            stmt.clusterAsyncProcess(bpData);
                        } else {
                            HashMap<String, Object[]> htabInfo = fldrBuffer.getHtabInfo();
                            for (Map.Entry<String, Object[]> entry : htabInfo.entrySet()) {
                                String subTableName = entry.getKey();
                                Object[] value = entry.getValue();
                                stmt.insertBatchHelper((Buffer)value[0], (List)value[1], FldrStatement.this.primaryFldr, subTableName);
                            }
                        }
                    } else {
                        Buffer buffer = fldrBuffer.getBuffer();
                        List<LobData> lobList = fldrBuffer.getLobList();
                        stmt.insertBatchHelper(buffer, lobList, FldrStatement.this.primaryFldr, FldrStatement.this.tableName);
                    }
                    if (count % 50 == 0) {
                        for (Fldr fldr : FldrStatement.this.usedFldr) {
                            fldr.dbAccess.commit();
                        }
                    }
                    if (fldrBuffer.getSeqNo() == -1) continue;
                    ++count;
                }
            }
        };
        this.clusterExecutor.execute(task2);
    }

    public void insertBatchHelper(Buffer buffer, List<LobData> lobList, Fldr fldr, String curTabName) throws SQLException {
        this.usedFldr.add(fldr);
        this.insertFlag = true;
        short setId = fldr.getSetId(String.valueOf(this.schemaName) + ":" + curTabName, this.setEnvInfo.getBldrNumber());
        this.setFldrEnv(fldr, curTabName, setId);
        buffer.setInt(20, setId);
        fldr.insertBatch(buffer);
        fldr.insertLob(setId, lobList);
    }

    private void setFldrEnv(Fldr fldr, String curTabName, short setId) throws SQLException {
        String containedTab = this.setIdMap.get(setId);
        if (!curTabName.equals(containedTab)) {
            this.setEnvInfo.setSetId(setId);
            this.setEnvInfo.setTableName(curTabName);
            String result = fldr.setEnvironment(this.setEnvInfo);
            if (!result.equals("SUCCESS")) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("set Fldr Environment %s : %s", curTabName, result));
            }
            this.setIdMap.put(setId, curTabName);
        }
    }

    private List<ColumnData> createColumn(int length, int rows) {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(length);
        int i2 = 0;
        while (i2 < length) {
            ColumnData columnData = new ColumnData();
            columnData.setColumnIndex(i2);
            columnData.setSqlType(this.tableInfo.getColumnInfos().get(i2).getColumnType());
            columnData.setIsAllNotNull(1);
            columnData.setNullArr(new byte[rows]);
            columnData.setData(new ArrayList<Object>());
            columnDataList.add(columnData);
            ++i2;
        }
        return columnDataList;
    }

    private void processAutoIncrementColumn(int index, ColumnData columnData, Object o2) throws SQLException {
        if (this.setEnvInfo.getSetIdentity() == 0) {
            columnData.setIsAllNotNull(0);
            return;
        }
        if (o2 == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("The auto-increasing number mismatched: {currentRow: %s}", index));
        }
        columnData.getNullArr()[index] = 1;
        columnData.getData().add(o2);
    }

    @Override
    public DmdbConnection do_getConnection() {
        return this.connection;
    }

    @Override
    public boolean do_getMoreResults(int current) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public DmdbResultSet do_getGeneratedKeys() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return -1;
    }

    @Override
    public int do_executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public int do_executeUpdate(String sql, String[] columnNames) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public boolean do_execute(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public boolean do_execute(String sql, int[] columnIndexes) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public boolean do_execute(String sql, String[] columnNames) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public int do_getResultSetHoldability() {
        return -1;
    }

    @Override
    public boolean do_isPoolable() {
        return false;
    }

    @Override
    public boolean do_isCloseOnCompletion() {
        return false;
    }

    public <T> T do_unwrap(Class<T> iface) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public boolean do_isWrapperFor(Class<?> iface) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    private void setFldrTableInfo(String schemaName, String tableName) throws SQLException {
        if (!this.firstFlag) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("FldrPreparedStatement could not set tableInfo again");
        }
        if (schemaName == null || schemaName.length() == 0) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("Schema name could not be empty");
        }
        if (tableName == null || tableName.length() == 0) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("Table name could not be empty");
        }
        this.firstFlag = false;
        assert (schemaName != null);
        this.schemaName = schemaName.toUpperCase();
        assert (tableName != null);
        this.tableName = tableName.toUpperCase();
        this.clusterFlag = false;
        this.primaryFldr = this.connection.getFldrInstance();
        this.tableInfo = this.primaryFldr.getTableInfo(this.schemaName, this.tableName, this.lockFlag);
        this.tableInfo.setConn(this.connection);
        if (this.tableInfo.containDecimal) {
            this.getDecimalPrecAndScale();
        }
        if (this.tableInfo.dpcFlag) {
            this.clusterFlag = true;
            this.clusterInfo = this.primaryFldr.getMppInfo(this.schemaName, this.tableName);
            this.clusterExecutor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), this.clusterInfo.ipInfoList.size()));
            this.fldrsMap = new ConcurrentHashMap();
            this.connections = new CopyOnWriteArrayList<DmdbConnection>();
            FldrStatement.doTaskOnEverySite(this.clusterExecutor, this.clusterInfo.ipInfoList, this.clusterInfo.ipInfoList.size(), new Callback<Object[]>(){

                @Override
                void run(Object[] ipInfo) throws SQLException {
                    try {
                        DmProperties props = (DmProperties)FldrStatement.this.connection.props.clone();
                        props.setProperty(Configuration.user.getName(), FldrStatement.this.connection.user);
                        props.setProperty(Configuration.password.getName(), FldrStatement.this.connection.password);
                        props.setProperty(Configuration.mppLocal.getName(), "true");
                        props.setProperty(Configuration.host.getName(), String.valueOf(ipInfo[1]));
                        props.setProperty(Configuration.port.getName(), String.valueOf(ipInfo[2]));
                        props.setProperty(Configuration.epGroup.getName(), null);
                        DmdbConnection conn = DmDriver.driver.do_connect(props);
                        FldrStatement.this.connections.add(conn);
                        FldrStatement.this.fldrsMap.put((Integer)ipInfo[0], conn.getFldrInstance());
                    }
                    catch (Exception e2) {
                        FldrStatement.this.shutdownExecutor();
                        DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
                    }
                }
            });
        }
        this.paramCount = this.tableInfo.getNameIdMap().size();
        this.curRowDatas = new Object[this.paramCount];
    }

    private void getDecimalPrecAndScale() throws SQLException {
        List<ColumnInfo> columnInfos = this.tableInfo.getColumnInfos();
        DmdbResultSet resultSet = DriverUtil.executeQuery(this.connection, String.format(DECIMAL_PRECISION_SCALE_SQL, this.schemaName, this.tableName));
        DmdbResultSetMetaData resultSetMetaData = resultSet.do_getMetaData();
        for (ColumnInfo info : columnInfos) {
            if (9 != info.getColumnType()) continue;
            int precision = resultSetMetaData.do_getPrecision(info.getColumnId() + 1);
            int scale = resultSetMetaData.do_getScale(info.getColumnId() + 1);
            this.columnIdScale.put(Integer.valueOf(info.getColumnId()), new int[]{precision, scale});
        }
        resultSet.do_close();
    }

    private boolean do_closeAsync() throws SQLException {
        if (this.usedAsyncPrep) {
            if (this.usedAsyncInsert) {
                this.setBatchData(null, -1);
                this.usedAsyncPrep = false;
                this.usedAsyncInsert = false;
                return true;
            }
            return false;
        }
        if (this.usedAsyncInsert) {
            this.setBatchData(null, -1);
            this.usedAsyncInsert = false;
            return true;
        }
        return false;
    }

    private void setFldrProperties(FldrConfig config) throws SQLException {
        if (config == null) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("FldrConfig could not be null");
        }
        this.setEnvInfo = new SetEnvInfo();
        this.setEnvInfo.setSetIdentity(config.setIdentity ? 1 : 0);
        this.setEnvInfo.setSorted(config.sorted ? 1 : 0);
        this.setEnvInfo.setBdtaSize(config.maxRows);
        this.setEnvInfo.setIndexOption(config.indexOption);
        this.setEnvInfo.setCharset(this.connection.getServerEncoding());
        this.setEnvInfo.setIgnoreConflict(0);
        this.setEnvInfo.setBldrNumber(config.bldrNum);
        this.setEnvInfo.setFlushFlag(config.flushFlag ? (byte)1 : 0);
        this.setEnvInfo.setSchemaName(this.schemaName);
        this.setEnvInfo.setTableName(this.tableName);
        this.setEnvInfo.setParallelFlag(config.parallelFlag ? (byte)1 : 0);
        this.rows = config.maxRows;
    }

    private void setFldrProperties(Map<String, String> configMap) throws SQLException {
        if (configMap == null || configMap.size() == 0) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("FldrConfigMap could not be null");
        }
        this.setEnvInfo = new SetEnvInfo();
        String schemaName = configMap.get("schemaName");
        if (schemaName == null || schemaName.length() == 0) {
            DBError.ECJDBC_SCHNAME_EMPTYSTRING.throwz(new Object[0]);
        } else {
            this.schemaName = schemaName.toUpperCase();
            this.setEnvInfo.setSchemaName(this.schemaName);
        }
        String tableName = configMap.get("tableName");
        if (tableName == null || tableName.length() == 0) {
            DBError.ECJDBC_TABNAME_NULL.throwz(new Object[0]);
        } else {
            this.tableName = tableName.toUpperCase();
            this.setEnvInfo.setTableName(this.tableName);
        }
        String setIdentity = configMap.get("setIdentity");
        if (setIdentity == null || setIdentity.length() == 0) {
            this.setEnvInfo.setSetIdentity(0);
        } else {
            this.setEnvInfo.setSetIdentity(setIdentity.equals("1") ? 1 : 0);
        }
        String sorted = configMap.get("sorted");
        if (sorted == null || sorted.length() == 0) {
            this.setEnvInfo.setSorted(0);
        } else {
            this.setEnvInfo.setSorted(sorted.equals("1") ? 1 : 0);
        }
        String maxRows = configMap.get("maxRows");
        if (maxRows == null || maxRows.length() == 0) {
            this.setEnvInfo.setBdtaSize(5000);
        } else {
            this.setEnvInfo.setBdtaSize(Integer.parseInt(maxRows));
        }
        String indexOption = configMap.get("indexOption");
        if (indexOption == null || indexOption.length() == 0) {
            this.setEnvInfo.setIndexOption(1);
        } else {
            this.setEnvInfo.setIndexOption(Integer.parseInt(indexOption));
        }
        this.setEnvInfo.setCharset(this.connection.getServerEncoding());
        this.setEnvInfo.setIgnoreConflict(0);
        String bldrNum = configMap.get("bldrNum");
        if (bldrNum == null || bldrNum.length() == 0) {
            this.setEnvInfo.setBldrNumber((short)64);
        } else {
            this.setEnvInfo.setBldrNumber(Short.parseShort(bldrNum));
        }
        String flushFlag = configMap.get("flushFlag");
        if (flushFlag == null || flushFlag.length() == 0) {
            this.setEnvInfo.setFlushFlag((byte)0);
        } else {
            this.setEnvInfo.setFlushFlag(flushFlag.equals("1") ? (byte)1 : 0);
        }
        String parallelFlag = configMap.get("parallelFlag");
        if (parallelFlag == null || parallelFlag.length() == 0) {
            this.setEnvInfo.setParallelFlag((byte)0);
        } else {
            this.setEnvInfo.setParallelFlag(parallelFlag.equals("1") ? (byte)1 : 0);
        }
        this.rows = this.setEnvInfo.getBdtaSize();
    }

    public static <T> void doTaskOnEverySite(ExecutorService executor, Collection<T> list, int siteCount, final Callback<T> callback) throws SQLException {
        if (siteCount == 0 || executor == null) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(siteCount);
        FldrTask[] tasks = new FldrTask[siteCount];
        int i2 = 0;
        for (final T siteObj : list) {
            tasks[i2] = new FldrTask(countDownLatch){

                @Override
                protected void doTask() throws SQLException {
                    callback.run(siteObj);
                }
            };
            executor.execute(tasks[i2]);
            ++i2;
        }
        FldrStatement.threadCountDownHelper(countDownLatch, tasks);
    }

    public static <T> void doTaskOnEverySite(ExecutorService executor, final T list, int columnSize, final Callback2<T> callback) throws SQLException {
        if (columnSize == 0 || executor == null) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(columnSize);
        FldrTask[] tasks = new FldrTask[columnSize];
        int i2 = 0;
        while (i2 < columnSize) {
            final int colIndex = i2;
            tasks[i2] = new FldrTask(countDownLatch){

                @Override
                protected void doTask() throws SQLException {
                    callback.run(list, colIndex);
                }
            };
            executor.execute(tasks[i2]);
            ++i2;
        }
        FldrStatement.threadCountDownHelper(countDownLatch, tasks);
    }

    public static void threadCountDownHelper(CountDownLatch countDownLatch, FldrTask[] tasks) throws SQLException {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {}
        FldrTask[] fldrTaskArray = tasks;
        int n2 = tasks.length;
        int n3 = 0;
        while (n3 < n2) {
            FldrTask task = fldrTaskArray[n3];
            if (!task.isSuccess()) {
                if (task.getError() == null) break;
                throw task.getError();
            }
            ++n3;
        }
    }

    static abstract class Callback<T> {
        Callback() {
        }

        abstract void run(T var1) throws SQLException;
    }

    static abstract class Callback2<T> {
        Callback2() {
        }

        abstract void run(T var1, int var2) throws SQLException;
    }
}

