/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.materializer;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.sqlengine.executor.conversions.SqlConverterGenerator;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.executor.etree.relation.ETRelationalConvert;
import com.cloudera.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.sqlengine.executor.etree.value.ETConvert;
import com.cloudera.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.sqlengine.executor.materializer.MaterializerContext;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvMaterializeUtil {
    public static ETRelationalConvert makeNewRelationConvertNode(List<IColumn> list, ETRelationalExpr eTRelationalExpr, boolean bl, MaterializerContext materializerContext) throws ErrorException {
        if (list.size() != eTRelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("column number mismatch");
        }
        ArrayList<ISqlConverter> arrayList = new ArrayList<ISqlConverter>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(ConvMaterializeUtil.createConverter(materializerContext.getSqlConverterGenerator(), eTRelationalExpr.getColumn(i), list.get(i)));
        }
        return new ETRelationalConvert(list, arrayList, bl, eTRelationalExpr);
    }

    public static ETValueExpr addConversionNodeWhenNeed(ETValueExpr eTValueExpr, IColumn iColumn, IColumn iColumn2, MaterializerContext materializerContext) throws ErrorException {
        SqlConverterGenerator sqlConverterGenerator = materializerContext.getSqlConverterGenerator();
        ISqlConverter iSqlConverter = ConvMaterializeUtil.createConverter(sqlConverterGenerator, iColumn, iColumn2);
        if (iSqlConverter == null) {
            return eTValueExpr;
        }
        return new ETConvert(eTValueExpr, iColumn, iSqlConverter);
    }

    private static ISqlConverter createConverter(SqlConverterGenerator sqlConverterGenerator, IColumn iColumn, IColumn iColumn2) throws ErrorException {
        ISqlConverter iSqlConverter = sqlConverterGenerator.createCustomConverter(iColumn, iColumn2);
        if (iSqlConverter != null) {
            return iSqlConverter;
        }
        if (DefaultSqlDataWrapper.isImplicitConvSupported(iColumn, iColumn2)) {
            return null;
        }
        return sqlConverterGenerator.createConverter(iColumn, iColumn2);
    }
}

