/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.value;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.sqlengine.executor.IWarningSource;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.IETBinaryNode;
import com.cloudera.sqlengine.executor.etree.IETNode;
import com.cloudera.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETBinaryArithValueExpr
extends ETValueExpr
implements IETBinaryNode<ETValueExpr, ETValueExpr>,
IWarningSource {
    private ETValueExpr m_leftOperand;
    private ETValueExpr m_rightOperand;
    private ETDataRequest m_leftData;
    private ETDataRequest m_rightData;
    private IBinaryArithmeticFunctor m_functor;
    private IWarningListener m_warningListener;

    public ETBinaryArithValueExpr(IColumn iColumn, ETValueExpr eTValueExpr, IColumn iColumn2, ETValueExpr eTValueExpr2, IBinaryArithmeticFunctor iBinaryArithmeticFunctor) throws ErrorException {
        if (eTValueExpr == null || iColumn == null || iColumn2 == null || eTValueExpr2 == null || iBinaryArithmeticFunctor == null) {
            throw new NullPointerException("ETBinaryArithValueExpr does not take null input.");
        }
        this.m_leftOperand = eTValueExpr;
        this.m_rightOperand = eTValueExpr2;
        this.m_leftData = new ETDataRequest(iColumn);
        this.m_rightData = new ETDataRequest(iColumn2);
        this.m_functor = iBinaryArithmeticFunctor;
    }

    @Override
    public void close() {
        this.m_leftOperand.close();
        this.m_rightOperand.close();
    }

    @Override
    public boolean isOpen() {
        return this.m_leftOperand.isOpen() && this.m_rightOperand.isOpen();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public void open() {
        this.m_leftOperand.open();
        this.m_rightOperand.open();
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.m_leftOperand;
        }
        if (n == 1) {
            return this.m_rightOperand;
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    @Override
    public ETValueExpr getLeftOperand() {
        return this.m_leftOperand;
    }

    @Override
    public ETValueExpr getRightOperand() {
        return this.m_rightOperand;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        this.m_leftOperand.retrieveData(this.m_leftData);
        this.m_rightOperand.retrieveData(this.m_rightData);
        return this.m_functor.execute(eTDataRequest, this.m_leftData.getData(), this.m_rightData.getData(), this.m_warningListener);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        if (iWarningListener == null) {
            throw new IllegalArgumentException("Warning listener can not be null.");
        }
        this.m_warningListener = iWarningListener;
    }
}

