/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.relation;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.dsi.dataengine.utilities.CursorType;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.cloudera.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.support.exceptions.ErrorException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETTop
extends ETUnaryRelationalExpr {
    private ETValueExpr m_selectLimit;
    private long m_rowCount;
    private long m_rowCountLimit;

    public ETTop(ETRelationalExpr eTRelationalExpr, ETValueExpr eTValueExpr, boolean bl) {
        super(eTRelationalExpr);
        if (bl) {
            throw new RuntimeException(SQLEngineExceptionFactory.featureNotImplementedException("TOP %"));
        }
        this.m_selectLimit = eTValueExpr;
        this.m_rowCount = 0L;
        this.m_rowCountLimit = 0L;
    }

    @Override
    public void close() {
        super.close();
        this.m_selectLimit.close();
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && this.m_selectLimit.isOpen();
    }

    @Override
    public void reset() throws ErrorException {
        super.reset();
        this.m_selectLimit.reset();
        this.m_rowCount = 0L;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.getOperand().getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.getOperand().getColumnCount();
    }

    @Override
    public long getRowCount() throws ErrorException {
        assert (this.isOpen()) : "getRowCount() called when ETTop node was not open.";
        long l = this.getOperand().getRowCount();
        if (-1L == l || l <= this.m_rowCountLimit) {
            return l;
        }
        return this.m_rowCountLimit;
    }

    public ETValueExpr getSelectLimit() {
        return this.m_selectLimit;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        super.open(cursorType);
        this.m_selectLimit.open();
        ETDataRequest eTDataRequest = new ETDataRequest(0L, -1L, new ColumnMetadata(TypeMetadata.createTypeMetadata(-5)));
        BigInteger bigInteger = null;
        try {
            this.m_selectLimit.retrieveData(eTDataRequest);
            bigInteger = eTDataRequest.getData().getBigInt();
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.incompatibleTypesException("TOP", "UNKNOWN");
        }
        if (bigInteger.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) > 0 || bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw SQLEngineExceptionFactory.invalidTopLimitValue(bigInteger.toString());
        }
        this.m_rowCountLimit = bigInteger.longValue();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.getOperand().retrieveData(n, eTDataRequest);
    }

    @Override
    protected boolean doMove() throws ErrorException {
        if (this.m_rowCount < this.m_rowCountLimit && this.getOperand().move()) {
            ++this.m_rowCount;
            return true;
        }
        return false;
    }
}

