/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.conversions;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.TimeTz;
import com.cloudera.dsi.dataengine.utilities.TimestampTz;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.support.conv.ConversionResult;
import com.cloudera.support.conv.DateTimeConverter;
import com.cloudera.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class SqlDateTimeConverter
implements ISqlConverter {
    private final IColumn m_targetMeta;
    private final IColumn m_sourceMeta;

    public SqlDateTimeConverter(IColumn iColumn, IColumn iColumn2) {
        this.m_targetMeta = iColumn2;
        this.m_sourceMeta = iColumn;
    }

    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            switch (iSqlDataWrapper.getType()) {
                case 91: {
                    this.convertFromDate(iSqlDataWrapper.getDate(), conversionResult, iSqlDataWrapper, iSqlDataWrapper2);
                    break;
                }
                case 92: {
                    this.convertFromTime(iSqlDataWrapper.getTime(), conversionResult, iSqlDataWrapper, iSqlDataWrapper2);
                    break;
                }
                case 93: {
                    this.convertFromTimestamp(iSqlDataWrapper.getTimestamp(), conversionResult, iSqlDataWrapper, iSqlDataWrapper2);
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString((short)iSqlDataWrapper2.getType()));
                }
            }
        }
        return conversionResult;
    }

    private void convertFromTime(Time time, ConversionResult conversionResult, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        Calendar calendar = null;
        TimeTz timeTz = null;
        if (time instanceof TimeTz) {
            timeTz = (TimeTz)time;
            calendar = timeTz.getTimezoneCalendar();
        } else {
            calendar = Calendar.getInstance();
        }
        switch (iSqlDataWrapper2.getType()) {
            case 92: {
                Time time2 = DateTimeConverter.toTime(time, conversionResult, this.m_targetMeta.getTypeMetadata().getPrecision(), calendar);
                if (null != timeTz) {
                    time2 = new TimeTz(time2, calendar);
                }
                iSqlDataWrapper2.setTime(time2);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = DateTimeConverter.toChar(time, this.m_targetMeta.getColumnLength(), (int)this.m_sourceMeta.getTypeMetadata().getPrecision(), calendar, conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString((short)iSqlDataWrapper2.getType()));
            }
        }
    }

    private void convertFromTimestamp(Timestamp timestamp, ConversionResult conversionResult, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        switch (iSqlDataWrapper2.getType()) {
            case 93: {
                Timestamp timestamp2 = DateTimeConverter.toTimestamp(timestamp, conversionResult, this.m_targetMeta.getTypeMetadata().getPrecision());
                if (timestamp instanceof TimestampTz) {
                    timestamp2 = new TimestampTz(timestamp2, ((TimestampTz)timestamp).getTimezoneCalendar());
                }
                iSqlDataWrapper2.setTimestamp(timestamp2);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                Timestamp timestamp3 = iSqlDataWrapper.getTimestamp();
                Calendar calendar = null;
                calendar = timestamp3 instanceof TimestampTz ? ((TimestampTz)timestamp3).getTimezoneCalendar() : Calendar.getInstance();
                String string = DateTimeConverter.toChar(timestamp3, this.m_targetMeta.getColumnLength(), (int)this.m_sourceMeta.getTypeMetadata().getPrecision(), calendar, conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString((short)iSqlDataWrapper2.getType()));
            }
        }
    }

    private void convertFromDate(Date date, ConversionResult conversionResult, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        switch (iSqlDataWrapper2.getType()) {
            case 93: {
                Timestamp timestamp = DateTimeConverter.toTimestamp(date, conversionResult, Calendar.getInstance());
                iSqlDataWrapper2.setTimestamp(timestamp);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = DateTimeConverter.toChar(iSqlDataWrapper.getDate(), this.m_targetMeta.getColumnLength(), Calendar.getInstance(), conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString((short)iSqlDataWrapper2.getType()));
            }
        }
    }
}

