/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.dsiext.dataengine;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.sqlengine.aeprocessor.AEUtils;
import com.cloudera.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AENull;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.cloudera.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.cloudera.sqlengine.aeprocessor.metadatautil.MetadataUtilities;
import com.cloudera.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.cloudera.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.sqlengine.dsiext.dataengine.IScalarFnMetadataHandler;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.sqlengine.dsiext.dataengine.utils.ScalarFunctionArgType;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlScalarFnMetadataHandler
implements IScalarFnMetadataHandler {
    private final ICoercionHandler m_coercionHandler;
    protected AECoercionProperties m_coercionProperties;

    public SqlScalarFnMetadataHandler() {
        this(new AEMetadataCoercionHandler());
    }

    public SqlScalarFnMetadataHandler(ICoercionHandler iCoercionHandler) {
        this(iCoercionHandler, new AECoercionProperties.Builder().build());
    }

    public SqlScalarFnMetadataHandler(ICoercionHandler iCoercionHandler, AECoercionProperties aECoercionProperties) {
        this.m_coercionHandler = iCoercionHandler;
        this.m_coercionProperties = aECoercionProperties;
    }

    @Override
    public IScalarFnMetadataHandler.ScalarFnMetadata createMetadata(SqlDataEngineContext sqlDataEngineContext, ScalarFunctionID scalarFunctionID, String string, List<? extends IColumnInfo> list) throws ErrorException {
        IScalarFnMetadataHandler.ScalarFnMetadata scalarFnMetadata;
        switch (scalarFunctionID) {
            case CUSTOM: {
                scalarFnMetadata = this.createCustomMetadata(sqlDataEngineContext, string, list);
                if (null != scalarFnMetadata) break;
                throw SQLEngineExceptionFactory.invalidScalarFnNameException(string);
            }
            case ASCII: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAsciiMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CHAR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCharMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CONCAT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConcatMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case INSERT: {
                if (4 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<? extends IColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createInsertMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case LCASE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLCaseMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LEFT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLeftMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case LENGTH: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLengthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LOCATE2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLocateMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case LOCATE3: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<? extends IColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createLocateMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case LTRIM: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLTrimMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case REPEAT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRepeatMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case REPLACE: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<? extends IColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createReplaceMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case RIGHT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRightMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case RTRIM: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRTrimMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SOUNDEX: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSoundexMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SPACE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSpaceMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SUBSTRING3: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<? extends IColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createSubstringMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case SUBSTRING2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSubstringMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case UCASE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUCaseMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CURDATE: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurDateMetadata(sqlDataEngineContext);
                break;
            }
            case CURTIME: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurTimeMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_DATE: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentDateMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_TIME: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimeMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_TIME1: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimeMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CURRENT_TIMESTAMP: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimestampMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_TIMESTAMP1: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimestampMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYNAME: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayNameMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYOFWEEK: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfWeekMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYOFMONTH: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfMonthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYOFYEAR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfYearMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case HOUR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createHourMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MINUTE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMinuteMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MONTH: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMonthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MONTHNAME: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMonthNameMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case NOW: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNowMetadata(sqlDataEngineContext);
                break;
            }
            case QUARTER: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createQuarterMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SECOND: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSecondMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case TIMESTAMPADD: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<? extends IColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createTimestampAddMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case TIMESTAMPDIFF: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<? extends IColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createTimestampDiffMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case WEEK: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createWeekMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case WEEK_ISO: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createWeekISOMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case YEAR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createYearMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ABS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAbsMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ACOS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createACosMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ASIN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createASinMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ATAN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createATanMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ATAN2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createATanMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case CEILING: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCeilingMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case COS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCosMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case COT: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCotMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DEGREES: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDegreesMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case EXP: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createExpMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case FLOOR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFloorMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LOG: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLogMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LOG10: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLog10Metadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MOD: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createModMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case PI: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPiMetadata(sqlDataEngineContext);
                break;
            }
            case POWER: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPowerMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case RADIANS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRadiansMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case RAND0: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRandMetadata(sqlDataEngineContext);
                break;
            }
            case RAND1: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRandMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ROUND: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRoundMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case SIGN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSignMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SIN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSinMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SQRT: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSqrtMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case TAN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTanMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case TRUNCATE: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTruncateMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case DATABASE: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDatabaseMetadata(sqlDataEngineContext);
                break;
            }
            case IFNULL: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIfNullMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case NULL: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNullMetadata(sqlDataEngineContext);
                break;
            }
            case USER: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUserMetadata(sqlDataEngineContext);
                break;
            }
            case CONVERT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConvertMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case CAST: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCastMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case LOWER: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLowerMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case UPPER: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUpperMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            default: {
                scalarFnMetadata = null;
            }
        }
        if (null == scalarFnMetadata) {
            throw SQLEngineExceptionFactory.featureNotImplementedException(scalarFunctionID.toString());
        }
        return scalarFnMetadata;
    }

    @Override
    public void validateMetadata(SqlDataEngineContext sqlDataEngineContext, ScalarFunctionID scalarFunctionID, String string, List<? extends IColumnInfo> list) throws ErrorException {
        switch (scalarFunctionID) {
            case CUSTOM: {
                this.validateCustomMetadata(sqlDataEngineContext, string, list);
                break;
            }
            default: {
                this.validateArgTypes(sqlDataEngineContext, scalarFunctionID.getName(), scalarFunctionID.getArguments(), list);
            }
        }
    }

    protected ICoercionHandler getCoercionHandler() {
        return this.m_coercionHandler;
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCustomMetadata(SqlDataEngineContext sqlDataEngineContext, String string, List<? extends IColumnInfo> list) throws ErrorException {
        return null;
    }

    protected void validateCustomMetadata(SqlDataEngineContext sqlDataEngineContext, String string, List<? extends IColumnInfo> list) throws ErrorException {
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createAsciiMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCharMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createConcatMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        TypeMetadata typeMetadata = this.createStringMetadata(iColumnInfo);
        TypeMetadata typeMetadata2 = this.createStringMetadata(iColumnInfo2);
        ICoercionHandler iCoercionHandler = this.getCoercionHandler();
        IColumn iColumn = iCoercionHandler.coerceConcatColumns(new MetadataColumnInfo(new ColumnMetadata(typeMetadata), iColumnInfo.getColumnType()), new MetadataColumnInfo(new ColumnMetadata(typeMetadata2), iColumnInfo2.getColumnType()));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(iColumn, Arrays.asList(typeMetadata, typeMetadata2));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createInsertMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3, IColumnInfo iColumnInfo4) throws ErrorException {
        TypeMetadata typeMetadata = this.createStringMetadata(iColumnInfo);
        TypeMetadata typeMetadata2 = this.createStringMetadata(iColumnInfo4);
        ICoercionHandler iCoercionHandler = this.getCoercionHandler();
        IColumn iColumn = iCoercionHandler.coerceConcatColumns(new MetadataColumnInfo(new ColumnMetadata(typeMetadata), iColumnInfo.getColumnType()), new MetadataColumnInfo(new ColumnMetadata(typeMetadata2), iColumnInfo4.getColumnType()));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(ColumnMetadata.copyOf(iColumn), Arrays.asList(typeMetadata, this.createIntMetadata(), this.createIntMetadata(), typeMetadata2));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLCaseMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLeftMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLengthMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLocateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        TypeMetadata typeMetadata = this.createStringMetadata(iColumnInfo);
        TypeMetadata typeMetadata2 = this.createStringMetadata(iColumnInfo2);
        ICoercionHandler iCoercionHandler = this.getCoercionHandler();
        IColumn iColumn = iCoercionHandler.coerceComparisonColumns(new MetadataColumnInfo(new ColumnMetadata(typeMetadata), iColumnInfo.getColumnType()), new MetadataColumnInfo(new ColumnMetadata(typeMetadata2), iColumnInfo2.getColumnType()));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createStringMetadata(iColumn.getTypeMetadata().getType(), iColumnInfo.getColumnLength()), this.createStringMetadata(iColumn.getTypeMetadata().getType(), iColumnInfo2.getColumnLength())));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLocateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        TypeMetadata typeMetadata = this.createStringMetadata(iColumnInfo);
        TypeMetadata typeMetadata2 = this.createStringMetadata(iColumnInfo2);
        ICoercionHandler iCoercionHandler = this.getCoercionHandler();
        IColumn iColumn = iCoercionHandler.coerceComparisonColumns(new MetadataColumnInfo(new ColumnMetadata(typeMetadata), iColumnInfo.getColumnType()), new MetadataColumnInfo(new ColumnMetadata(typeMetadata2), iColumnInfo2.getColumnType()));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(TypeMetadata.copyOf(iColumn.getTypeMetadata()), TypeMetadata.copyOf(iColumn.getTypeMetadata()), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLTrimMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createRepeatMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        TypeMetadata typeMetadata = this.createStringMetadata(iColumnInfo.getType(), Math.max(this.m_coercionProperties.getMaxVarcharlength(), iColumnInfo.getColumnLength()));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createReplaceMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        TypeMetadata typeMetadata = this.createStringMetadata(iColumnInfo);
        TypeMetadata typeMetadata2 = this.createStringMetadata(iColumnInfo2);
        TypeMetadata typeMetadata3 = this.createStringMetadata(iColumnInfo3);
        ICoercionHandler iCoercionHandler = this.getCoercionHandler();
        IColumn iColumn = iCoercionHandler.coerceComparisonColumns(new MetadataColumnInfo(new ColumnMetadata(typeMetadata), iColumnInfo.getColumnType()), new MetadataColumnInfo(new ColumnMetadata(typeMetadata2), iColumnInfo2.getColumnType()));
        iColumn = iCoercionHandler.coerceConcatColumns(new MetadataColumnInfo(ColumnMetadata.copyOf(iColumn), IColumnInfo.ColumnType.CONCATENATION), new MetadataColumnInfo(new ColumnMetadata(typeMetadata3), iColumnInfo3.getColumnType()));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(ColumnMetadata.copyOf(iColumn), Arrays.asList(TypeMetadata.copyOf(iColumn.getTypeMetadata()), TypeMetadata.copyOf(iColumn.getTypeMetadata()), TypeMetadata.copyOf(iColumn.getTypeMetadata())));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createRightMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createRTrimMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSoundexMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSpaceMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSubstringMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata(), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSubstringMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createUCaseMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCurDateMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDateMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCurTimeMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimeMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCurrentDateMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return this.createCurDateMetadata(sqlDataEngineContext);
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCurrentTimeMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return this.createCurTimeMetadata(sqlDataEngineContext);
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCurrentTimeMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimeMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCurrentTimestampMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCurrentTimestampMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimeMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createDayNameMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createDayOfMonthMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createDayOfWeekMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createDayOfYearMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createHourMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createTimeMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createMinuteMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createTimeMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createMonthMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createMonthNameMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createNowMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createQuarterMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSecondMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createTimeMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createTimestampAddMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        return null;
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createTimestampDiffMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        return null;
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createWeekMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createWeekISOMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createYearMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createDateMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createAbsMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createACosMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createASinMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createATanMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createATanMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata(), this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCeilingMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCosMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCotMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createDegreesMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createExpMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createFloorMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLogMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLog10Metadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createModMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ColumnMetadata columnMetadata;
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (IColumnInfo.ColumnType.PARAMETER_UNSET == iColumnInfo.getColumnType() && IColumnInfo.ColumnType.PARAMETER_UNSET == iColumnInfo2.getColumnType()) {
            columnMetadata = new ColumnMetadata(this.createBigIntMetadata());
            arrayList.add(this.createBigIntMetadata());
            arrayList.add(this.createBigIntMetadata());
        } else {
            TypeMetadata typeMetadata = this.createNumericMetadata(iColumnInfo);
            TypeMetadata typeMetadata2 = this.createNumericMetadata(iColumnInfo2);
            IColumn iColumn = this.getCoercionHandler().coerceUnionColumns(new MetadataColumnInfo(new ColumnMetadata(typeMetadata), iColumnInfo.getColumnType()), new MetadataColumnInfo(new ColumnMetadata(typeMetadata2), iColumnInfo2.getColumnType()));
            columnMetadata = ColumnMetadata.copyOf(iColumn);
            arrayList.add(TypeMetadata.copyOf(iColumn.getTypeMetadata()));
            arrayList.add(TypeMetadata.copyOf(iColumn.getTypeMetadata()));
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(columnMetadata, arrayList);
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createPiMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createPowerMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata(), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createRadiansMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createRandMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createRandMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createRoundMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSignMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSinMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createSqrtMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createTanMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createTruncateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createNumericMetadata(iColumnInfo), this.createIntMetadata()));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createDatabaseMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createIfNullMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        IColumn iColumn = this.getCoercionHandler().coerceUnionColumns(new MetadataColumnInfo(MetadataUtilities.createColumnMetadata(iColumnInfo), iColumnInfo.getColumnType()), new MetadataColumnInfo(MetadataUtilities.createColumnMetadata(iColumnInfo2), iColumnInfo2.getColumnType()));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(ColumnMetadata.copyOf(iColumn), Arrays.asList(TypeMetadata.copyOf(iColumn.getTypeMetadata()), TypeMetadata.copyOf(iColumn.getTypeMetadata())));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createNullMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new AENull().getColumn(), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createUserMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Collections.<TypeMetadata>emptyList());
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createConvertMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        int n;
        if (IColumnInfo.ColumnType.LITERAL != iColumnInfo2.getColumnType()) {
            throw SQLEngineExceptionFactory.invalidSecondArgumentToConvertException();
        }
        String string = iColumnInfo2.getLiteralString();
        try {
            n = SqlTypes.valueOf(string.toUpperCase()).getSqlType();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SQLEngineExceptionFactory.invalidSecondArgumentToConvertException();
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata), Arrays.asList(typeMetadata, this.createStringMetadata(iColumnInfo2)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createCastMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        if (IColumnInfo.ColumnType.LITERAL != iColumnInfo2.getColumnType()) {
            throw SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
        }
        String string = iColumnInfo2.getLiteralString();
        int n = sqlDataEngineContext.getSqlTypeForTypeName(string);
        if (0 == n) {
            try {
                n = SqlTypes.valueOf(string.toUpperCase()).getSqlType();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
            }
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata), Arrays.asList(typeMetadata, this.createStringMetadata(iColumnInfo2)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createLowerMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected IScalarFnMetadataHandler.ScalarFnMetadata createUpperMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata(iColumnInfo)), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    protected boolean isValidTypeMetadata(SqlDataEngineContext sqlDataEngineContext, ScalarFunctionArgType scalarFunctionArgType, short s) throws ErrorException {
        return MetadataUtilities.isConversionLegal(s, scalarFunctionArgType);
    }

    protected TypeMetadata createDoubleMetadata() {
        try {
            return TypeMetadata.createTypeMetadata(8);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createBigIntMetadata() {
        try {
            return TypeMetadata.createTypeMetadata(-5);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createIntMetadata() {
        try {
            return TypeMetadata.createTypeMetadata(4);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createStringMetadata() {
        try {
            return TypeMetadata.createTypeMetadata(12);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createStringMetadata(IColumnInfo iColumnInfo) {
        if (IColumnInfo.ColumnType.PARAMETER_UNSET == iColumnInfo.getColumnType() || !TypeUtilities.isCharacterType(iColumnInfo.getType())) {
            return this.createStringMetadata();
        }
        try {
            return MetadataUtilities.createTypeMetadata(iColumnInfo);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createStringMetadata(int n, long l) throws ErrorException {
        if (SqlTypes.getValueOf(n).isWChar()) {
            if (this.m_coercionProperties.getMaxWvarcharLength() < l) {
                return TypeMetadata.createTypeMetadata(-10);
            }
            if (this.m_coercionProperties.getMaxWcharlength() < l) {
                return TypeMetadata.createTypeMetadata(-9);
            }
            return TypeMetadata.createTypeMetadata(-8);
        }
        if (this.m_coercionProperties.getMaxVarcharlength() < l) {
            return TypeMetadata.createTypeMetadata(-1);
        }
        if (this.m_coercionProperties.getMaxCharLength() < l) {
            return TypeMetadata.createTypeMetadata(12);
        }
        return TypeMetadata.createTypeMetadata(1);
    }

    protected TypeMetadata createTimeMetadata() {
        try {
            return TypeMetadata.createTypeMetadata(92);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createTimestampMetadata() {
        try {
            return TypeMetadata.createTypeMetadata(93);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createDateMetadata() {
        try {
            return TypeMetadata.createTypeMetadata(91);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    protected TypeMetadata createNumericMetadata(IColumnInfo iColumnInfo) {
        if (IColumnInfo.ColumnType.PARAMETER_UNSET != iColumnInfo.getColumnType() && AEUtils.isTypeNumeric(iColumnInfo.getType())) {
            try {
                return MetadataUtilities.createTypeMetadata(iColumnInfo);
            }
            catch (ErrorException errorException) {
                throw new AssertionError((Object)errorException);
            }
        }
        return this.createDoubleMetadata();
    }

    private void validateTypeMetadata(SqlDataEngineContext sqlDataEngineContext, String string, int n, ScalarFunctionArgType scalarFunctionArgType, IColumnInfo iColumnInfo) throws ErrorException {
        if (!this.isValidTypeMetadata(sqlDataEngineContext, scalarFunctionArgType, iColumnInfo.getType())) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException(string, n, iColumnInfo.getType());
        }
    }

    private void validateArgTypes(SqlDataEngineContext sqlDataEngineContext, String string, List<ScalarFunctionArgType> list, List<? extends IColumnInfo> list2) throws ErrorException {
        if (list.size() != list2.size()) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.validateTypeMetadata(sqlDataEngineContext, string, i + 1, list.get(i), list2.get(i));
        }
    }
}

