/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree.statement;

import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEUpdate
extends AERowCountStatement {
    private static final int NUM_CHILDREN = 3;
    private AETable m_table;
    private AESetClauseList m_setClauses;
    private AEBooleanExpr m_updateCond;

    public AEUpdate(AETable aETable, AESetClauseList aESetClauseList, AEBooleanExpr aEBooleanExpr) throws ErrorException {
        if (null == aETable || null == aESetClauseList || null == aEBooleanExpr) {
            throw new NullPointerException();
        }
        this.m_table = aETable;
        this.m_table.setParent(this);
        this.m_setClauses = aESetClauseList;
        this.m_setClauses.setParent(this);
        this.m_updateCond = aEBooleanExpr;
        this.m_updateCond.setParent(this);
        this.updateDefaultMetadata();
        this.validate();
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AEUpdate copy() {
        try {
            return new AEUpdate(this.m_table.copy(), this.m_setClauses.copy(), this.m_updateCond.copy());
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                if (0 == n) {
                    return AEUpdate.this.m_table;
                }
                if (1 == n) {
                    return AEUpdate.this.m_setClauses;
                }
                if (2 == n) {
                    return AEUpdate.this.m_updateCond;
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 3;
            }
        }.iterator();
    }

    @Override
    public String getLogString() {
        return "AEUpdate";
    }

    @Override
    public int getNumChildren() {
        return 3;
    }

    public AETable getTable() {
        return this.m_table;
    }

    public AESetClauseList getSetClauses() {
        return this.m_setClauses;
    }

    public AEBooleanExpr getUpdateCondition() {
        return this.m_updateCond;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        return this == iAENode || iAENode instanceof AEUpdate && this.m_table.isEquivalent(((AEUpdate)iAENode).m_table) && this.m_setClauses.isEquivalent(((AEUpdate)iAENode).m_setClauses) && this.m_updateCond.isEquivalent(((AEUpdate)iAENode).m_updateCond);
    }

    @Override
    public void reprocessMetadata() throws ErrorException {
        AEUpdate.getMetadataProcessor().visit(this);
    }

    private void updateDefaultMetadata() throws ErrorException {
        Iterator iterator = this.m_setClauses.getChildItr();
        while (iterator.hasNext()) {
            AESetClause aESetClause = (AESetClause)iterator.next();
            AEValueExpr aEValueExpr = aESetClause.getRightOperand();
            if (!(aEValueExpr instanceof AEDefault)) continue;
            AEDefault aEDefault = (AEDefault)aEValueExpr;
            aEDefault.setMetadata(aESetClause.getLeftOperand().getColumn());
        }
    }

    private void validate() throws ErrorException {
        int n = this.m_setClauses.getNumChildren();
        for (int i = 0; i < n - 1; ++i) {
            AEColumnReference aEColumnReference = ((AESetClause)this.m_setClauses.getChild(i)).getLeftOperand();
            for (int j = i + 1; j < n; ++j) {
                if (!aEColumnReference.isEquivalent(((AESetClause)this.m_setClauses.getChild(j)).getLeftOperand())) continue;
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.DUPLICATE_UPDATE_COLUMN.name(), new String[]{aEColumnReference.getName()});
            }
        }
    }
}

