/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aebuilder;

import com.cloudera.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.sqlengine.aeprocessor.aebuilder.IAEBuilder;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.exceptions.SQLEngineMemoryException;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.parser.parsetree.PTDefaultVisitor;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import com.cloudera.support.exceptions.InvalidOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AEBuilderBase<T extends IAENode>
extends PTDefaultVisitor<T>
implements IAEBuilder {
    private AEQueryScope m_queryScope;

    protected AEBuilderBase(AEQueryScope aEQueryScope) {
        this.m_queryScope = aEQueryScope;
    }

    public T build(IPTNode iPTNode) throws ErrorException {
        try {
            return (T)((IAENode)iPTNode.acceptVisitor(this));
        }
        catch (StackOverflowError stackOverflowError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.STACK_OVERFLOW.name());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.OUT_OF_MEMORY.name());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{runtimeException.getLocalizedMessage()}, (Throwable)runtimeException);
        }
    }

    protected AEQueryScope getQueryScope() {
        return this.m_queryScope;
    }

    @Override
    protected final T defaultVisit(IPTNode iPTNode) {
        throw new UnsupportedOperationException("Logic Error: Default visit method is called with " + iPTNode + " from base AE tree builder class");
    }
}

