/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.core;

import com.cloudera.dsi.core.interfaces.IEnvironment;
import com.cloudera.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.dsi.core.utilities.Variant;
import com.cloudera.hivecommon.AuthMech;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.HiveServerType;
import com.cloudera.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.core.ImpalaJDBCEnvironment;
import com.cloudera.impala.core.ImpalaJDBCServerVersionUtils;
import com.cloudera.impala.dataengine.ImpalaScalarFnMetadataHandler;
import com.cloudera.jdbc.common.ProductInfoHandler;
import com.cloudera.sqlengine.dsiext.dataengine.IScalarFnMetadataHandler;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.Warning;
import com.cloudera.support.WarningCode;
import com.cloudera.support.exceptions.ErrorException;

public class ImpalaJDBCConnection
extends HiveJDBCCommonConnection {
    public ImpalaJDBCConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), iEnvironment);
    }

    @Override
    public void establishConnection(ConnSettingRequestMap connSettingRequestMap, int n) throws ErrorException {
        super.establishConnection(connSettingRequestMap, n);
        this.m_settings.m_optimizedInsert = true;
        Variant variant = this.getOptionalSetting("OptimizedInsert", connSettingRequestMap);
        if (null != variant) {
            try {
                if (variant.getInt() == 1) {
                    this.m_settings.m_optimizedInsert = true;
                } else if (variant.getInt() == 0) {
                    this.m_settings.m_optimizedInsert = false;
                } else {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_OPTIMIZED_INSERT_ERROR.name()));
                }
            }
            catch (Exception exception) {
                this.m_settings.m_optimizedInsert = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_OPTIMIZED_INSERT_ERROR.name()));
            }
        }
        this.m_settings.m_supportTimeOnlyTimestamp = true;
        variant = this.getOptionalSetting("SupportTimeOnlyTimestamp", connSettingRequestMap);
        if (null != variant) {
            try {
                if (0 == variant.getInt()) {
                    this.m_settings.m_supportTimeOnlyTimestamp = false;
                } else {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SUPPORT_TIME_ONLY_TIMESTAMP_TYPE_ERR.name()));
                }
            }
            catch (Exception exception) {
                this.m_settings.m_optimizedInsert = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SUPPORT_TIME_ONLY_TIMESTAMP_ERR.name()));
            }
        }
    }

    @Override
    protected void setImplementationDefaultSettings() {
        this.m_settings.m_platformVersionUtils = new ImpalaJDBCServerVersionUtils();
        this.m_settings.m_platformDefaultUID = "impala";
        this.m_settings.m_platformDelegationUIDPropertyKey = "impala.doas.user";
        this.m_settings.m_platformCatalog = "Impala";
        this.m_settings.m_dbmsName = "Impala";
    }

    @Override
    protected ProductInfoHandler getProductInfoHandler() {
        return new ProductInfoHandler("SimbaClouderaImpalaJDBCDriver.lic", "Simba Cloudera Impala JDBC Driver");
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            return ((ImpalaJDBCEnvironment)this.getParentEnvironment()).getLog();
        }
        return this.m_log;
    }

    @Override
    public IScalarFnMetadataHandler getScalarFnMetadataHandler() {
        return new ImpalaScalarFnMetadataHandler();
    }

    @Override
    protected void setDriverSpecificSettings() {
        this.m_settings.m_stringColumnSize = Short.MAX_VALUE;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        boolean bl = false;
        this.verifyOptionalSetting("LowerCaseResultSetColumnName", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("Host", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("Port", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("HiveServerType", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("OptimizedInsert", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseSasl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SupportTimeOnlyTimestamp", connSettingRequestMap, connSettingResponseMap);
        if (null == hiveJDBCSettings.m_authMech) {
            hiveJDBCSettings.m_authMech = AuthMech.NOAUTH;
        } else {
            bl = true;
        }
        if (HiveServerType.HiveServer2 == hiveJDBCSettings.m_hiveServerType) {
            if (AuthMech.NOAUTH_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_enableSSL = true;
            }
            if (AuthMech.SASL_PLAIN_UIDPWD_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_enableSSL = true;
                hiveJDBCSettings.m_authMech = AuthMech.UIDPWD;
            }
            if (AuthMech.UIDPWD == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyRequiredSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyOptionalSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech) {
                this.verifyOptionalSetting("KrbRealm", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbHostFQDN", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbServiceName", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("krbAuthType", connSettingRequestMap, connSettingResponseMap);
            }
            if (hiveJDBCSettings.m_enableSSL) {
                this.verifyOptionalSetting("SSLKeyStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLKeyStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("AllowSelfSignedCerts", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("CAIssuedCertNamesMismatch", connSettingRequestMap, connSettingResponseMap);
            }
        }
        return connSettingResponseMap;
    }

    @Override
    protected String getConnectionLogFileName() {
        return "Impala_connection_";
    }
}

