/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.dataengine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HiveJDBCQueryAnalyserUtils {
    private static final String WITH_CASE = "WITH";

    public static String queryAnalysis(String string) {
        String string2 = "DESCRIBE";
        String string3 = "SELECT";
        String[] stringArray = string.split(" ");
        if (stringArray[0].toUpperCase().equals(string2)) {
            return string2;
        }
        if (stringArray[0].toUpperCase().equals(string3)) {
            return string3;
        }
        return "Type not found";
    }

    public static String analyzeUseStatement(String string) {
        Matcher matcher = Pattern.compile("\\s*USE(?:(?=`)|\\s+)(.+)", 34).matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.startsWith("`")) {
            int n = 1;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if ('`' == c) {
                    if (string2.length() <= n + 1 || '`' != string2.charAt(n + 1)) break;
                    stringBuilder.append(c);
                    n += 2;
                    continue;
                }
                stringBuilder.append(c);
                ++n;
            }
            if (2 <= stringBuilder.length() && '`' == stringBuilder.charAt(0) && '`' == stringBuilder.charAt(stringBuilder.length() - 1)) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.deleteCharAt(0);
            }
        } else {
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (Character.isWhitespace(c)) {
                    assert (0 != i);
                    break;
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    public static String removeWithExpression(String string) {
        if (!string.startsWith(WITH_CASE)) {
            return string;
        }
        string = string.substring(WITH_CASE.length());
        int n = 0;
        ParseState parseState = ParseState.INITIAL;
        char c = '\u0000';
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (parseState) {
                case INITIAL: {
                    char c2 = string.charAt(i);
                    switch (c2) {
                        case '(': {
                            ++n;
                            continue block11;
                        }
                        case ')': {
                            if (0 != --n) continue block11;
                            parseState = ParseState.AFTER_SUBQ;
                            continue block11;
                        }
                        case '\"': 
                        case '\'': 
                        case '`': {
                            c = c2;
                            parseState = ParseState.QUOTE;
                            continue block11;
                        }
                        case '[': {
                            c = ']';
                            parseState = ParseState.QUOTE;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case QUOTE: {
                    char c2;
                    while (i < string.length()) {
                        c2 = string.charAt(i);
                        if ('\\' == c2) {
                            ++i;
                        } else if (c == c2) {
                            parseState = ParseState.INITIAL;
                            continue block11;
                        }
                        ++i;
                    }
                    continue block11;
                }
                case AFTER_SUBQ: {
                    char c2 = string.charAt(i);
                    if (',' == c2) {
                        parseState = ParseState.INITIAL;
                        continue block11;
                    }
                    if (Character.isWhitespace(c2)) {
                        parseState = ParseState.AFTER_SUBQ;
                        continue block11;
                    }
                    return string.substring(i);
                }
            }
        }
        return "";
    }

    private static enum ParseState {
        INITIAL,
        QUOTE,
        AFTER_SUBQ;

    }
}

