/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.core;

import com.cloudera.dsi.core.impl.DSIStatement;
import com.cloudera.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.dsi.dataengine.interfaces.IDataEngine;
import com.cloudera.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hivecommon.dataengine.HiveJDBCDataEngine;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ErrorException;

public class HiveJDBCStatement
extends DSIStatement {
    private ConnSettingRequestMap m_requestMap;
    private boolean m_isAsyncExecution = false;
    private boolean m_isCanceled = false;

    HiveJDBCStatement(HiveJDBCCommonConnection hiveJDBCCommonConnection, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super(hiveJDBCCommonConnection);
        this.m_requestMap = connSettingRequestMap;
    }

    public void cancel() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        this.m_isCanceled = true;
    }

    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        this.m_isCanceled = false;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
    }

    @Override
    public IDataEngine createDataEngine() throws ErrorException {
        this.clearCancel();
        return new HiveJDBCDataEngine(this, this.m_requestMap);
    }

    public boolean getAsyncExecution() {
        return this.m_isAsyncExecution;
    }

    public boolean isCanceled() {
        return this.m_isCanceled;
    }

    public void setAsyncExecution(boolean bl) {
        this.m_isAsyncExecution = bl;
    }
}

