/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import com.cloudera.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.utilities.StringConverter;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.IServerVersion;
import com.cloudera.hivecommon.IServerVersionUtils;
import com.cloudera.hivecommon.api.HS2Buffer;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.hive.service.cli.thrift.TBinaryColumn;
import org.apache.hive.service.cli.thrift.TBoolColumn;
import org.apache.hive.service.cli.thrift.TByteColumn;
import org.apache.hive.service.cli.thrift.TColumn;
import org.apache.hive.service.cli.thrift.TDoubleColumn;
import org.apache.hive.service.cli.thrift.TI16Column;
import org.apache.hive.service.cli.thrift.TI32Column;
import org.apache.hive.service.cli.thrift.TI64Column;
import org.apache.hive.service.cli.thrift.TStringColumn;

public class HS2v6Buffer
extends HS2Buffer {
    private static final byte[] BITMASK_TO_CELL_MAP = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    public int m_indexInNullArray = 0;
    public int m_bitIndexInCurrentNullByte = 0;
    public boolean m_hasParsedFirstRow = false;
    private static final java.util.Date today = Calendar.getInstance().getTime();

    @Override
    public int getNumRows() throws ErrorException {
        if (null != this.m_hiveServer2Buffer.getResults()) {
            List list = this.m_hiveServer2Buffer.getResults().getColumns();
            if (null == list) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Thrift column information request error");
                throw errorException;
            }
            if (0 == list.size()) {
                return 0;
            }
            TColumn tColumn = (TColumn)list.get(0);
            if (tColumn.isSetBinaryVal()) {
                return tColumn.getBinaryVal().getValuesSize();
            }
            if (tColumn.isSetBoolVal()) {
                return tColumn.getBoolVal().getValuesSize();
            }
            if (tColumn.isSetByteVal()) {
                return tColumn.getByteVal().getValuesSize();
            }
            if (tColumn.isSetDoubleVal()) {
                return tColumn.getDoubleVal().getValuesSize();
            }
            if (tColumn.isSetI16Val()) {
                return tColumn.getI16Val().getValuesSize();
            }
            if (tColumn.isSetI32Val()) {
                return tColumn.getI32Val().getValuesSize();
            }
            if (tColumn.isSetI64Val()) {
                return tColumn.getI64Val().getValuesSize();
            }
            return tColumn.getStringVal().getValuesSize();
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Thrift column information request error");
        throw errorException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, int n2, short s, String string, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        IServerVersionUtils iServerVersionUtils = hiveJDBCSettings.m_platformVersionUtils;
        IServerVersion iServerVersion = hiveJDBCSettings.m_serverVersion;
        switch (s) {
            case -2: {
                TBinaryColumn tBinaryColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getBinaryVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tBinaryColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                ByteBuffer byteBuffer = (ByteBuffer)tBinaryColumn.getValues().get(n2);
                if (null != byteBuffer && null != byteBuffer.array()) return DSITypeUtilities.outputBinary(byteBuffer.array(), dataWrapper, l, l2);
                dataWrapper.setNull(s);
                return false;
            }
            case 12: {
                TStringColumn tStringColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tStringColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string2 = (String)tStringColumn.getValues().get(n2);
                return DSITypeUtilities.outputVarCharStringData(string2, dataWrapper, l, l2);
            }
            case 1: {
                TStringColumn tStringColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tStringColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string3 = (String)tStringColumn.getValues().get(n2);
                return DSITypeUtilities.outputCharStringData(string3, dataWrapper, l, l2);
            }
            case 16: {
                if (iServerVersionUtils.hasIssueWithNullTypeData(iServerVersion) && ((TColumn._Fields)((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getSetField()).getFieldName().equals("stringVal")) {
                    TStringColumn tStringColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getStringVal();
                    if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tStringColumn.getNulls())) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Incorrect data type returned from server."});
                    throw errorException;
                }
                TBoolColumn tBoolColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getBoolVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tBoolColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Boolean bl = (Boolean)tBoolColumn.getValues().get(n2);
                dataWrapper.setBoolean(bl);
                return false;
            }
            case -6: {
                TByteColumn tByteColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getByteVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tByteColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Byte by = (Byte)tByteColumn.getValues().get(n2);
                dataWrapper.setTinyInt(by.byteValue());
                return false;
            }
            case 5: {
                TI16Column tI16Column = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getI16Val();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tI16Column.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Short s2 = (Short)tI16Column.getValues().get(n2);
                dataWrapper.setSmallInt(s2.shortValue());
                return false;
            }
            case 4: {
                TI32Column tI32Column = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getI32Val();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tI32Column.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Integer n3 = (Integer)tI32Column.getValues().get(n2);
                dataWrapper.setInteger(n3.intValue());
                return false;
            }
            case -5: {
                TI64Column tI64Column = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getI64Val();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tI64Column.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Long l3 = (Long)tI64Column.getValues().get(n2);
                dataWrapper.setBigInt(l3);
                return false;
            }
            case 7: {
                TDoubleColumn tDoubleColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getDoubleVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tDoubleColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Double d = (Double)tDoubleColumn.getValues().get(n2);
                dataWrapper.setReal(d.floatValue());
                return false;
            }
            case 8: {
                TDoubleColumn tDoubleColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getDoubleVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tDoubleColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Double d = (Double)tDoubleColumn.getValues().get(n2);
                dataWrapper.setDouble(d);
                return false;
            }
            case 93: {
                TStringColumn tStringColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tStringColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string4 = (String)tStringColumn.getValues().get(n2);
                Timestamp timestamp = null;
                try {
                    timestamp = StringConverter.parseTimestamp(string4, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!iServerVersionUtils.supportsTimeOnlyTimestamp(iServerVersion) || !hiveJDBCSettings.m_supportTimeOnlyTimestamp) throw illegalArgumentException;
                    try {
                        Time time = StringConverter.parseTime(string4, null);
                        if (null != time) {
                            timestamp = new Timestamp(time.getTime());
                            timestamp.setDate(today.getDate());
                            timestamp.setMonth(today.getMonth());
                            timestamp.setYear(today.getYear());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        if (!iServerVersionUtils.supportsDateOnlyTimestamp(iServerVersion)) throw illegalArgumentException;
                        Date date = StringConverter.parseDate(string4, null);
                        if (null == date) throw illegalArgumentException;
                        timestamp = new Timestamp(date.getDate());
                    }
                }
                dataWrapper.setTimestamp(timestamp);
                return false;
            }
            case 3: {
                TStringColumn tStringColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tStringColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string5 = (String)tStringColumn.getValues().get(n2);
                dataWrapper.setDecimal(new BigDecimal(string5));
                return false;
            }
            case 91: {
                TStringColumn tStringColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n)).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, tStringColumn.getNulls())) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string6 = (String)tStringColumn.getValues().get(n2);
                dataWrapper.setDate(Date.valueOf(string6));
                return false;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
        throw errorException;
    }

    @Override
    public String getString(int n, int n2) throws Exception {
        TStringColumn tStringColumn = ((TColumn)this.m_hiveServer2Buffer.getResults().getColumns().get(n2)).getStringVal();
        if (HS2v6Buffer.checkIfNull(n, tStringColumn.getNulls())) {
            return null;
        }
        return (String)tStringColumn.getValues().get(n);
    }

    private static boolean checkIfNull(int n, byte[] byArray) {
        int n2 = n / 8;
        int n3 = n % 8;
        return HS2v6Buffer.checkIfNull(n2, n3, byArray);
    }

    private static boolean checkIfNull(int n, int n2, byte[] byArray) {
        if (n >= byArray.length) {
            return false;
        }
        return (byArray[n] & BITMASK_TO_CELL_MAP[n2]) != 0;
    }
}

