/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.materializer;

import com.cloudera.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.conversions.SqlConverterGenerator;
import com.cloudera.sqlengine.executor.etree.ETDefaultVisitor;
import com.cloudera.sqlengine.executor.etree.IETNode;
import com.cloudera.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.sqlengine.executor.etree.relation.ETTable;
import com.cloudera.sqlengine.executor.etree.value.ETColumnRef;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MaterializerContext {
    private Map<AERelationalExpr, ETRelationalExpr> m_materializedRelationMap;
    private Map<AEColumnReference, ETColumnRef> m_materializedValueMap;
    private final SqlConverterGenerator m_converterGenerator;
    private final IWarningListener m_warningListner;

    public MaterializerContext(SqlConverterGenerator sqlConverterGenerator, IWarningListener iWarningListener) {
        this.m_converterGenerator = sqlConverterGenerator;
        this.m_warningListner = iWarningListener;
        this.m_materializedRelationMap = new HashMap<AERelationalExpr, ETRelationalExpr>();
        this.m_materializedValueMap = new HashMap<AEColumnReference, ETColumnRef>();
    }

    public SqlConverterGenerator getSqlConverterGenerator() {
        return this.m_converterGenerator;
    }

    public ETRelationalExpr getMaterializedRelation(AERelationalExpr aERelationalExpr) {
        return this.m_materializedRelationMap.get(aERelationalExpr);
    }

    public ETColumnRef getMaterializedValue(AEColumnReference aEColumnReference) {
        return this.m_materializedValueMap.get(aEColumnReference);
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListner;
    }

    public void setMaterializedRelation(AERelationalExpr aERelationalExpr, ETRelationalExpr eTRelationalExpr) {
        if (this.m_materializedRelationMap.containsKey(aERelationalExpr)) {
            throw new UnsupportedOperationException("Logic error - the key: " + aERelationalExpr + " already has a materialized relation.");
        }
        this.m_materializedRelationMap.put(aERelationalExpr, eTRelationalExpr);
    }

    public void setMaterializedValue(AEColumnReference aEColumnReference, ETColumnRef eTColumnRef) {
        if (this.m_materializedValueMap.containsKey(aEColumnReference)) {
            throw new UnsupportedOperationException("Logic error - the key: " + aEColumnReference + " already has a materialized value.");
        }
        this.m_materializedValueMap.put(aEColumnReference, eTColumnRef);
    }

    public void setDataNeededAll(ETRelationalExpr eTRelationalExpr) throws ErrorException {
        ETDefaultVisitor<Map<DSIExtJResultSet, Set<Integer>>> eTDefaultVisitor = new ETDefaultVisitor<Map<DSIExtJResultSet, Set<Integer>>>(){
            private final Map<DSIExtJResultSet, Set<Integer>> m_result = new HashMap<DSIExtJResultSet, Set<Integer>>();

            @Override
            public Map<DSIExtJResultSet, Set<Integer>> visit(ETColumnRef eTColumnRef) throws ErrorException {
                ETRelationalExpr eTRelationalExpr = eTColumnRef.getRelationalExpression();
                DSIExtJResultSet dSIExtJResultSet = null;
                Integer n = null;
                if (!(eTRelationalExpr instanceof ETTable)) {
                    throw SQLEngineExceptionFactory.featureNotImplementedException("setDataNeeded for " + eTRelationalExpr.getLogString());
                }
                dSIExtJResultSet = ((ETTable)eTRelationalExpr).getUnderlyingTable();
                n = eTColumnRef.getColumnNumber();
                if (!this.m_result.containsKey(dSIExtJResultSet)) {
                    this.m_result.put(dSIExtJResultSet, new HashSet());
                }
                this.m_result.get(dSIExtJResultSet).add(n);
                return this.m_result;
            }

            @Override
            protected Map<DSIExtJResultSet, Set<Integer>> defaultVisit(IETNode iETNode) throws ErrorException {
                Iterator<? extends IETNode> iterator = iETNode.getChildItr();
                while (iterator.hasNext()) {
                    iterator.next().acceptVisitor(this);
                }
                return this.m_result;
            }
        };
        Map<DSIExtJResultSet, Set<Integer>> map = eTRelationalExpr.acceptVisitor(eTDefaultVisitor);
        for (DSIExtJResultSet dSIExtJResultSet : map.keySet()) {
            for (int n : map.get(dSIExtJResultSet)) {
                dSIExtJResultSet.setDataNeeded(n, true);
            }
        }
    }
}

