/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.conversions;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.sqlengine.executor.conversions.ISqlConverterFactory;
import com.cloudera.sqlengine.executor.conversions.SqlApproxNumConverterFactory;
import com.cloudera.sqlengine.executor.conversions.SqlCharTypeConverterFactory;
import com.cloudera.sqlengine.executor.conversions.SqlDateTimeConverterFactory;
import com.cloudera.sqlengine.executor.conversions.SqlExactNumberConverterFactory;
import com.cloudera.sqlengine.executor.conversions.SqlIntegralConverterFactory;
import com.cloudera.support.Pair;
import com.cloudera.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Map;

public class SqlConverterGenerator {
    private Map<Pair<Integer, Integer>, ISqlConverterFactory> m_converterFactoryTable;

    public SqlConverterGenerator() {
        this.init();
    }

    public ISqlConverter createConverter(IColumn iColumn, IColumn iColumn2) throws ErrorException {
        short s = iColumn.getTypeMetadata().getType();
        short s2 = iColumn2.getTypeMetadata().getType();
        Pair<Integer, Integer> pair = new Pair<Integer, Integer>(Integer.valueOf(s), Integer.valueOf(s2));
        ISqlConverterFactory iSqlConverterFactory = this.m_converterFactoryTable.get(pair);
        if (null == iSqlConverterFactory) {
            throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString(s), TypeUtilities.sqlTypeToString(s2));
        }
        return iSqlConverterFactory.createSqlConverter(iColumn, iColumn2);
    }

    public ISqlConverter createCustomConverter(IColumn iColumn, IColumn iColumn2) throws ErrorException {
        return null;
    }

    private void init() {
        this.m_converterFactoryTable = new HashMap<Pair<Integer, Integer>, ISqlConverterFactory>();
        SqlCharTypeConverterFactory sqlCharTypeConverterFactory = new SqlCharTypeConverterFactory();
        SqlDateTimeConverterFactory sqlDateTimeConverterFactory = new SqlDateTimeConverterFactory();
        SqlExactNumberConverterFactory sqlExactNumberConverterFactory = new SqlExactNumberConverterFactory();
        SqlApproxNumConverterFactory sqlApproxNumConverterFactory = new SqlApproxNumConverterFactory();
        SqlIntegralConverterFactory sqlIntegralConverterFactory = new SqlIntegralConverterFactory();
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, -5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, -5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, -5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, -5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, -7), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, -7), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, -7), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, -7), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 16), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 16), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 16), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 16), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 16), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 16), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 91), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 91), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 91), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 91), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 91), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 91), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -11), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -11), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -11), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -11), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -11), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -11), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, 4), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, 4), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, 4), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, 4), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 4), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 4), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 4), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 4), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 4), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 4), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 7), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, 5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, 5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, 5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, 5), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 5), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 92), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 92), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 92), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 92), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 92), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 92), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, -6), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, -6), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, -6), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, -6), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -6), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 93), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 93), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 93), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 93), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 93), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 93), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 12), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 12), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 12), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 12), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 12), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 12), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -1), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -8), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -9), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -9), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -9), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -9), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -9), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -9), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, -10), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, -10), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, -10), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, -10), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, -10), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, -10), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(91, 93), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(92, 92), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(93, 93), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, 8), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, 3), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, 3), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, 3), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, 3), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, 3), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, 3), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, 3), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, 3), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, 3), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, 3), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, 3), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, 3), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 3), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 3), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 3), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 3), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 3), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 3), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, 8), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, 2), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, 2), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, 2), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, 2), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, 2), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, 2), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, 2), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, 2), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, 2), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, 2), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, 2), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(1, 2), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(12, 2), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-1, 2), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-8, 2), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-9, 2), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-10, 2), sqlCharTypeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, 1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, 1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, 1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, 1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, 1), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, 1), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, 1), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(91, 1), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(92, 1), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(93, 1), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, 1), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, 1), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, 1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, 1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, 12), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, 12), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, 12), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, 12), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, 12), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, 12), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, 12), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(91, 12), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(92, 12), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(93, 12), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, 12), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, 12), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, 12), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, 12), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, -1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, -1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, -1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, -1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, -1), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, -1), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, -1), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(91, -1), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(92, -1), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(93, -1), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, -1), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, -1), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, -1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, -1), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, -8), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, -8), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, -8), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, -8), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, -8), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, -8), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, -8), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(91, -8), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(92, -8), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(93, -8), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, -8), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, -8), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, -8), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, -8), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, -9), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, -9), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, -9), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, -9), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, -9), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, -9), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, -9), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(91, -9), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(92, -9), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(93, -9), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, -9), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, -9), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, -9), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, -9), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(4, -10), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-6, -10), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(5, -10), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-5, -10), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(8, -10), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(6, -10), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(7, -10), sqlApproxNumConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(91, -10), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(92, -10), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(93, -10), sqlDateTimeConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(2, -10), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(3, -10), sqlExactNumberConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(-7, -10), sqlIntegralConverterFactory);
        this.m_converterFactoryTable.put(new Pair<Integer, Integer>(16, -10), sqlIntegralConverterFactory);
    }
}

