/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree.relation;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AESetOperation;
import com.cloudera.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.cloudera.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEUnion
extends AESetOperation {
    private List<ColumnMetadata> m_columnMetadataList;

    public AEUnion(AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2, boolean bl, ICoercionHandler iCoercionHandler) throws ErrorException {
        this(aERelationalExpr, aERelationalExpr2, bl, AEUnion.calculateMetadata(aERelationalExpr, aERelationalExpr2, iCoercionHandler));
    }

    private AEUnion(AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2, boolean bl, List<ColumnMetadata> list) {
        super(aERelationalExpr, aERelationalExpr2, bl);
        this.m_columnMetadataList = list;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AEUnion copy() {
        return new AEUnion(this.getLeftOperand(), this.getRightOperand(), this.isAllOptPresent(), new ArrayList<ColumnMetadata>(this.m_columnMetadataList));
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_columnMetadataList.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_columnMetadataList.size();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEUnion)) {
            return false;
        }
        AEUnion aEUnion = (AEUnion)iAENode;
        return this.isAllOptPresent() == aEUnion.isAllOptPresent() && this.getLeftOperand().isEquivalent(aEUnion.getLeftOperand()) && this.getRightOperand().isEquivalent(aEUnion.getRightOperand());
    }

    @Override
    protected IAENode getChild(int n) {
        if (0 == n) {
            return this.getLeftOperand();
        }
        if (1 == n) {
            return this.getRightOperand();
        }
        throw new IndexOutOfBoundsException("" + n);
    }

    private static List<ColumnMetadata> calculateMetadata(AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2, ICoercionHandler iCoercionHandler) throws ErrorException {
        int n = aERelationalExpr.getColumnCount();
        if (n <= 0 || n != aERelationalExpr2.getColumnCount()) {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(n);
        for (int i = 0; i < n; ++i) {
            IColumn iColumn = iCoercionHandler.coerceUnionColumns(new MetadataColumnInfo(aERelationalExpr.getColumn(i), IColumnInfo.ColumnType.COLUMN), new MetadataColumnInfo(aERelationalExpr2.getColumn(i), IColumnInfo.ColumnType.COLUMN));
            ColumnMetadata columnMetadata = ColumnMetadata.copyOf(iColumn);
            columnMetadata.setName(aERelationalExpr.getColumn(i).getName());
            arrayList.add(columnMetadata);
        }
        return arrayList;
    }
}

