/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.utils;

import com.cloudera.hivecommon.api.TETSSLTransportFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class DSTrustManager
implements X509TrustManager {
    X509TrustManager m_defaultTrustManager;
    X509TrustManager m_userSetTrustManager;
    boolean m_allowSelfSigned;
    boolean m_certNamesMismatch;
    String m_host;
    boolean m_hostNameInSAN;

    public DSTrustManager(TETSSLTransportFactory.TETSSLTransportParameters tETSSLTransportParameters, String string) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException {
        TrustManagerFactory trustManagerFactory;
        this.m_allowSelfSigned = tETSSLTransportParameters.isAllowSelfSigned();
        this.m_certNamesMismatch = tETSSLTransportParameters.isCertNamesMismatch();
        this.m_host = string;
        this.m_hostNameInSAN = tETSSLTransportParameters.isHostNameInSAN();
        this.m_userSetTrustManager = null;
        this.m_defaultTrustManager = null;
        TrustManager[] trustManagerArray = null;
        if (tETSSLTransportParameters.isTrustStoreSet()) {
            trustManagerFactory = TrustManagerFactory.getInstance(tETSSLTransportParameters.getTrustManagerType());
            KeyStore keyStore = KeyStore.getInstance(tETSSLTransportParameters.getTrustStoreType());
            char[] cArray = null;
            if (null != tETSSLTransportParameters.getTrustPass()) {
                cArray = tETSSLTransportParameters.getTrustPass().toCharArray();
            }
            keyStore.load(new FileInputStream(tETSSLTransportParameters.getTrustStore()), cArray);
            trustManagerFactory.init(keyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
            if (null != trustManagerArray) {
                for (int i = 0; i < trustManagerArray.length; ++i) {
                    if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
                    this.m_userSetTrustManager = (X509TrustManager)trustManagerArray[0];
                    break;
                }
            }
        }
        if (null == this.m_userSetTrustManager) {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            trustManagerArray = trustManagerFactory.getTrustManagers();
            if (trustManagerArray != null) {
                for (int i = 0; i < trustManagerArray.length; ++i) {
                    if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
                    this.m_defaultTrustManager = (X509TrustManager)trustManagerArray[0];
                    break;
                }
            }
            if (null == this.m_defaultTrustManager) {
                throw new CertificateException("Can not load TrustManager.");
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (!this.m_allowSelfSigned) {
            if (null != this.m_userSetTrustManager) {
                this.m_userSetTrustManager.checkServerTrusted(x509CertificateArray, string);
            } else {
                this.m_defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
            }
            if (!this.verifyHost(x509CertificateArray[0])) {
                throw new CertificateException("Hostname and certificate CN are mismatched.");
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    private boolean matchName(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < this.m_host.length()) {
            if (Character.toUpperCase(string.charAt(n)) == Character.toUpperCase(this.m_host.charAt(n2))) {
                ++n;
                ++n2;
                continue;
            }
            if ('*' != string.charAt(n)) break;
            while ('.' != this.m_host.charAt(n2) && n2 < this.m_host.length()) {
                ++n2;
            }
            ++n;
        }
        if (n == string.length() && n2 == this.m_host.length()) {
            bl = true;
        }
        return bl;
    }

    private boolean verifyHost(X509Certificate x509Certificate) throws CertificateParsingException {
        Object object;
        Object object2;
        if (this.m_certNamesMismatch) {
            return true;
        }
        if (null == x509Certificate) {
            return false;
        }
        if (this.m_hostNameInSAN && null != (object2 = x509Certificate.getSubjectAlternativeNames())) {
            object = object2.iterator();
            while (object.hasNext()) {
                List list = (List)object.next();
                if (!list.get(0).equals(2) && !list.get(0).equals(7) || !this.matchName((String)list.get(1))) continue;
                return true;
            }
        }
        object = "";
        try {
            object2 = new LdapName(x509Certificate.getSubjectX500Principal().getName());
            for (Rdn rdn : ((LdapName)object2).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                object = rdn.getValue().toString();
                break;
            }
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
        return this.matchName((String)object);
    }
}

