/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZookeeperDynamicDiscovery {
    private static final String PARSE_REGEX = ".*serverUri=(.+);version.+";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 3000;
    private static final String HOST_PORT_SEPERATOR = ":";
    private CountDownLatch m_connectedSignal = new CountDownLatch(1);

    public ArrayList<String> retrieveInfoFromZooKeeper(String string, int n, String string2, int n2) throws KeeperException, IOException, InterruptedException, NumberFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.connect(string, n, n2, string2);
        Pattern pattern = Pattern.compile(PARSE_REGEX);
        for (String string3 : list) {
            String string4;
            Matcher matcher = pattern.matcher(string3);
            if (!matcher.matches() || !(string4 = matcher.group(1)).contains(HOST_PORT_SEPERATOR)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    private List<String> connect(String string, int n, int n2, String string2) throws KeeperException, IOException, InterruptedException {
        String string3;
        ZooKeeper zooKeeper;
        Stat stat;
        this.m_connectedSignal = new CountDownLatch(1);
        if (0 >= n2) {
            n2 = 3000;
        }
        if (null != (stat = (zooKeeper = new ZooKeeper(string3 = string + HOST_PORT_SEPERATOR + n, n2, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    ZookeeperDynamicDiscovery.this.m_connectedSignal.countDown();
                }
            }
        })).exists(string2, false))) {
            List list = zooKeeper.getChildren(string2, false);
            zooKeeper.close();
            return list;
        }
        zooKeeper.close();
        return null;
    }
}

