/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import com.cloudera.dsi.dataengine.utilities.Nullable;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.dsi.exceptions.NumericOverflowException;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.util.EnumMap;
import java.util.HashMap;
import org.apache.hive.service.cli.thrift.TTypeId;

public class DataTypeUtilities {
    private static HashMap<String, String> s_sqlNameToHiveName;
    private static EnumMap<TTypeId, Short> s_hiveTypeToSqlType;
    private static HashMap<String, Short> s_HiveNameToSqltype;

    public static void addHiveType(TTypeId tTypeId, short s) {
        s_hiveTypeToSqlType.put(tTypeId, s);
    }

    public static HiveCommonColumnMetadata createColumn(String string, String string2, String string3, String string4, String string5, short s, String string6, int n, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(s);
        HiveCommonColumnMetadata hiveCommonColumnMetadata = new HiveCommonColumnMetadata(typeMetadata);
        String string7 = DataTypeUtilities.mapSqlTypeNameToHiveTypeName(typeMetadata.getTypeName());
        switch (s) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                try {
                    typeMetadata.setSigned(true);
                    int n2 = (int)TypeUtilities.getColumnSize(typeMetadata, typeMetadata.getPrecision());
                    hiveCommonColumnMetadata.setColumnLength(n2);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    throw errorException;
                }
            }
            case 1: {
                try {
                    if (string6.contains("CHAR") && string6.contains("(") && hiveJDBCSettings.m_platformVersionUtils.supportsCharLength(hiveJDBCSettings.m_serverVersion)) {
                        string7 = string6.substring(0, string6.indexOf(40)).trim();
                        int n3 = Integer.parseInt(string6.substring(string6.indexOf(40) + 1, string6.indexOf(41)));
                        hiveCommonColumnMetadata.setColumnLength(n3);
                        break;
                    }
                    string7 = "STRING";
                    hiveCommonColumnMetadata.setColumnLength(hiveJDBCSettings.m_stringColumnSize);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    throw errorException;
                }
            }
            case 12: {
                try {
                    if ((hiveJDBCSettings.m_platformVersionUtils.supportsNestedDataTypes(hiveJDBCSettings.m_serverVersion) || hiveJDBCSettings.m_platformVersionUtils.supportsUnionDataTypes(hiveJDBCSettings.m_serverVersion)) && DataTypeUtilities.isDataTypeNested(string6)) {
                        string7 = string6;
                        hiveCommonColumnMetadata.setColumnLength(hiveJDBCSettings.m_stringColumnSize);
                        break;
                    }
                    if (string6.contains("VARCHAR") && string6.contains("(") && (hiveJDBCSettings.m_platformVersionUtils.supportsVarcharLength(hiveJDBCSettings.m_serverVersion) || n == 1)) {
                        string7 = string6.substring(0, string6.indexOf(40)).trim();
                        int n4 = Integer.parseInt(string6.substring(string6.indexOf(40) + 1, string6.indexOf(41)));
                        hiveCommonColumnMetadata.setColumnLength(n4);
                        break;
                    }
                    hiveCommonColumnMetadata.setColumnLength(hiveJDBCSettings.m_stringColumnSize);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    throw errorException;
                }
            }
            case 3: {
                typeMetadata.setScale(hiveJDBCSettings.m_decimalColumnScale);
                try {
                    if (string6.contains("DECIMAL") && string6.contains("(") && hiveJDBCSettings.m_platformVersionUtils.supportsDecimalPrecisionAndScale(hiveJDBCSettings.m_serverVersion)) {
                        string7 = string6.substring(0, string6.indexOf(40)).trim();
                        int n5 = Integer.parseInt(string6.substring(string6.indexOf(40) + 1, string6.indexOf(44)).trim());
                        hiveCommonColumnMetadata.setColumnLength(n5);
                        short s2 = Short.parseShort(string6.substring(string6.indexOf(40) + 1, string6.indexOf(44)).trim());
                        short s3 = Short.parseShort(string6.substring(string6.indexOf(44) + 1, string6.indexOf(41)).trim());
                        typeMetadata.setPrecision(s2);
                        typeMetadata.setScale(s3);
                        break;
                    }
                    int n6 = (int)TypeUtilities.getColumnSize(typeMetadata, typeMetadata.getPrecision());
                    hiveCommonColumnMetadata.setColumnLength(n6);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    throw errorException;
                }
            }
            case 93: {
                try {
                    typeMetadata.setPrecision((short)9);
                    typeMetadata.setScale((short)9);
                    int n7 = (int)TypeUtilities.getColumnSize(typeMetadata, typeMetadata.getPrecision());
                    hiveCommonColumnMetadata.setColumnLength(n7);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    throw errorException;
                }
            }
            case -2: 
            case 16: 
            case 91: {
                try {
                    int n8 = (int)TypeUtilities.getColumnSize(typeMetadata, typeMetadata.getPrecision());
                    hiveCommonColumnMetadata.setColumnLength(n8);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    throw errorException;
                }
            }
        }
        typeMetadata.setTypeName(string7);
        hiveCommonColumnMetadata.setCatalogName(string);
        hiveCommonColumnMetadata.setSchemaName(string2);
        hiveCommonColumnMetadata.setTableName(string3);
        hiveCommonColumnMetadata.setName(string4);
        hiveCommonColumnMetadata.setLabel(string4);
        hiveCommonColumnMetadata.setNullable(Nullable.NULLABLE);
        hiveCommonColumnMetadata.setComment(string5);
        return hiveCommonColumnMetadata;
    }

    public static short mapHiveTypeToSqlType(TTypeId tTypeId) {
        Short s = s_hiveTypeToSqlType.get(tTypeId);
        if (null != s) {
            return s;
        }
        return 12;
    }

    public static String mapSqlTypeNameToHiveTypeName(String string) {
        return s_sqlNameToHiveName.get(string.trim());
    }

    public static short mapHiveTypeNameToSqltype(String string, int n, HiveJDBCSettings hiveJDBCSettings) {
        if (hiveJDBCSettings.m_platformVersionUtils.supportsNestedDataTypes(hiveJDBCSettings.m_serverVersion)) {
            int n2 = string.indexOf("<");
            String string2 = null;
            if (-1 != n2) {
                string2 = string.substring(0, n2);
            }
            if (string2 != null) {
                return s_HiveNameToSqltype.get(string2.toUpperCase());
            }
        }
        if (hiveJDBCSettings.m_platformVersionUtils.supportsTypeDecimal(hiveJDBCSettings.m_serverVersion) && string.contains("DECIMAL")) {
            return s_HiveNameToSqltype.get("DECIMAL");
        }
        if ((hiveJDBCSettings.m_platformVersionUtils.supportsTypeVarchar(hiveJDBCSettings.m_serverVersion) || n == 1) && string.contains("VARCHAR")) {
            return s_HiveNameToSqltype.get("VARCHAR");
        }
        if (hiveJDBCSettings.m_platformVersionUtils.supportsTypeChar(hiveJDBCSettings.m_serverVersion) && string.contains("CHAR")) {
            return s_HiveNameToSqltype.get("CHAR");
        }
        return s_HiveNameToSqltype.get(string.trim());
    }

    private static void initializeHiveTypeToSqlTypeMap() {
        s_hiveTypeToSqlType = new EnumMap(TTypeId.class);
        s_hiveTypeToSqlType.put(TTypeId.BOOLEAN_TYPE, (short)16);
        s_hiveTypeToSqlType.put(TTypeId.TINYINT_TYPE, (short)-6);
        s_hiveTypeToSqlType.put(TTypeId.SMALLINT_TYPE, (short)5);
        s_hiveTypeToSqlType.put(TTypeId.INT_TYPE, (short)4);
        s_hiveTypeToSqlType.put(TTypeId.BIGINT_TYPE, (short)-5);
        s_hiveTypeToSqlType.put(TTypeId.BINARY_TYPE, (short)-2);
        s_hiveTypeToSqlType.put(TTypeId.DOUBLE_TYPE, (short)8);
        s_hiveTypeToSqlType.put(TTypeId.FLOAT_TYPE, (short)7);
        s_hiveTypeToSqlType.put(TTypeId.TIMESTAMP_TYPE, (short)93);
        s_hiveTypeToSqlType.put(TTypeId.STRING_TYPE, (short)12);
        s_hiveTypeToSqlType.put(TTypeId.DECIMAL_TYPE, (short)3);
        s_hiveTypeToSqlType.put(TTypeId.USER_DEFINED_TYPE, (short)12);
    }

    private static void initializeSqlNameToHiveNameMap() {
        s_sqlNameToHiveName = new HashMap();
        s_sqlNameToHiveName.put("BOOLEAN", "BOOLEAN");
        s_sqlNameToHiveName.put("SQL_BINARY", "BINARY");
        s_sqlNameToHiveName.put("SQL_VARBINARY", "VARBINARY");
        s_sqlNameToHiveName.put("SQL_TINYINT", "TINYINT");
        s_sqlNameToHiveName.put("SQL_SMALLINT", "SMALLINT");
        s_sqlNameToHiveName.put("SQL_INTEGER", "INT");
        s_sqlNameToHiveName.put("SQL_BIGINT", "BIGINT");
        s_sqlNameToHiveName.put("SQL_DOUBLE", "DOUBLE");
        s_sqlNameToHiveName.put("SQL_FLOAT", "FLOAT");
        s_sqlNameToHiveName.put("SQL_REAL", "FLOAT");
        s_sqlNameToHiveName.put("SQL_TIMESTAMP", "TIMESTAMP");
        s_sqlNameToHiveName.put("SQL_TYPE_TIMESTAMP", "TIMESTAMP");
        s_sqlNameToHiveName.put("SQL_VARCHAR", "STRING");
        s_sqlNameToHiveName.put("SQL_DECIMAL", "DECIMAL");
        s_sqlNameToHiveName.put("SQL_DATE", "DATE");
        s_sqlNameToHiveName.put("SQL_TYPE_DATE", "DATE");
        s_sqlNameToHiveName.put("SQL_CHAR", "CHAR");
    }

    private static void initializeHiveNameToSqlNameMap() {
        s_HiveNameToSqltype = new HashMap();
        s_HiveNameToSqltype.put("BOOLEAN", (short)16);
        s_HiveNameToSqltype.put("BINARY", (short)-2);
        s_HiveNameToSqltype.put("TINYINT", (short)-6);
        s_HiveNameToSqltype.put("SMALLINT", (short)5);
        s_HiveNameToSqltype.put("INT", (short)4);
        s_HiveNameToSqltype.put("BIGINT", (short)-5);
        s_HiveNameToSqltype.put("DOUBLE", (short)8);
        s_HiveNameToSqltype.put("FLOAT", (short)7);
        s_HiveNameToSqltype.put("TIMESTAMP", (short)93);
        s_HiveNameToSqltype.put("STRING", (short)12);
        s_HiveNameToSqltype.put("DECIMAL", (short)3);
        s_HiveNameToSqltype.put("DATE", (short)91);
        s_HiveNameToSqltype.put("CHAR", (short)1);
        s_HiveNameToSqltype.put("VARCHAR", (short)12);
        s_HiveNameToSqltype.put("MAP", (short)12);
        s_HiveNameToSqltype.put("ARRAY", (short)12);
        s_HiveNameToSqltype.put("STRUCT", (short)12);
        s_HiveNameToSqltype.put("UNIONTYPE", (short)12);
    }

    private static boolean isDataTypeNested(String string) {
        return string.toUpperCase().startsWith("ARRAY") || string.toUpperCase().startsWith("STRUCT") || string.toUpperCase().startsWith("MAP") || string.toUpperCase().startsWith("UNIONTYPE") || string.toUpperCase().startsWith("UNION");
    }

    static {
        DataTypeUtilities.initializeSqlNameToHiveNameMap();
        DataTypeUtilities.initializeHiveTypeToSqlTypeMap();
        DataTypeUtilities.initializeHiveNameToSqlNameMap();
    }
}

